/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Element;
import uk.ac.starlink.util.Loader;

public abstract class Namespacing {
    private final String name_;
    private static Namespacing instance_;
    private static final Logger logger_;
    public static final String POLICY_PROP = "votable.namespacing";
    public static final Namespacing NONE;
    public static final Namespacing LAX;
    public static final Namespacing STRICT;
    private static final Namespacing[] KNOWN_POLICIES;
    private static final String POLICY_DEFAULT;

    public Namespacing(String name) {
        this.name_ = name;
    }

    public abstract void configureSAXParserFactory(SAXParserFactory var1);

    public abstract String getVOTagName(String var1, String var2, String var3);

    public String getVOTagName(Element el) {
        return this.getVOTagName(el.getNamespaceURI(), el.getLocalName(), el.getTagName());
    }

    public String toString() {
        return this.name_;
    }

    public static Namespacing getInstance() {
        if (instance_ == null) {
            String policy;
            try {
                policy = System.getProperty(POLICY_PROP, POLICY_DEFAULT);
            }
            catch (SecurityException e) {
                policy = POLICY_DEFAULT;
            }
            Namespacing ns = null;
            for (int i = 0; i < KNOWN_POLICIES.length; ++i) {
                if (!KNOWN_POLICIES[i].toString().equalsIgnoreCase(policy)) continue;
                ns = KNOWN_POLICIES[i];
            }
            if (ns == null) {
                ns = Loader.getClassInstance(policy, Namespacing.class);
            }
            if (ns == null) {
                StringBuffer sbuf = new StringBuffer().append("Unknown value \"").append(policy).append("\" for system property ").append(POLICY_PROP).append(".  Known values: ");
                for (int i = 0; i < KNOWN_POLICIES.length; ++i) {
                    if (i > 0) {
                        sbuf.append(", ");
                    }
                    sbuf.append(KNOWN_POLICIES[i]);
                }
                sbuf.append(".");
                throw new RuntimeException(sbuf.toString());
            }
            instance_ = ns;
            logger_.config("VOTable namespacing mode is " + instance_);
        }
        return instance_;
    }

    public void setInstance(Namespacing instance) {
        instance_ = instance;
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.votable");
        NONE = new NoNamespacing();
        LAX = new LaxNamespacing();
        STRICT = new StrictNamespacing();
        KNOWN_POLICIES = new Namespacing[]{NONE, LAX, STRICT};
        POLICY_DEFAULT = LAX.toString();
    }

    private static class StrictNamespacing
    extends Namespacing {
        private final Pattern votUriRegex_ = Pattern.compile("\\Qhttp://www.ivoa.net/xml/VOTable/v\\E[0-9\\.\\-]+");

        StrictNamespacing() {
            super("strict");
        }

        @Override
        public void configureSAXParserFactory(SAXParserFactory spfact) {
            spfact.setNamespaceAware(true);
        }

        @Override
        public String getVOTagName(String namespaceURI, String localName, String qName) {
            if (localName != null && localName.trim().length() > 0) {
                if (this.isVotableUri(namespaceURI)) {
                    return localName;
                }
                if (qName.endsWith(":VOTABLE") || qName.equals("VOTABLE") || localName.equals("VOTABLE")) {
                    logger_.warning("<VOTABLE> element in non-VOTable namespace " + namespaceURI + " not treated as VOTable");
                }
                if (qName != null) {
                    return qName.indexOf(58) >= 0 ? qName : ":" + qName;
                }
                return localName;
            }
            return qName;
        }

        private boolean isVotableUri(String uri) {
            return this.votUriRegex_.matcher(uri).matches();
        }
    }

    private static class LaxNamespacing
    extends Namespacing {
        LaxNamespacing() {
            super("lax");
        }

        @Override
        public void configureSAXParserFactory(SAXParserFactory fact) {
            fact.setNamespaceAware(false);
        }

        @Override
        public String getVOTagName(String namespaceURI, String localName, String qName) {
            if (qName != null) {
                int iColon = qName.indexOf(58);
                return iColon >= 0 ? qName.substring(iColon + 1) : qName;
            }
            return localName;
        }
    }

    private static class NoNamespacing
    extends Namespacing {
        NoNamespacing() {
            super("none");
        }

        @Override
        public void configureSAXParserFactory(SAXParserFactory spfact) {
            spfact.setNamespaceAware(false);
        }

        @Override
        public String getVOTagName(String namespaceURI, String localName, String qName) {
            if (qName != null) {
                return qName;
            }
            assert (false);
            return localName;
        }
    }
}

