/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.fits.CardFactory;
import uk.ac.starlink.fits.CardImage;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.fits.FitsTableWriter;
import uk.ac.starlink.fits.FitsUtil;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.formats.DocumentedIOHandler;
import uk.ac.starlink.util.ConfigMethod;
import uk.ac.starlink.util.DataBufferedOutputStream;
import uk.ac.starlink.votable.ColFitsPlusTableBuilder;
import uk.ac.starlink.votable.FitsPlusTableBuilder;
import uk.ac.starlink.votable.VOSerializer;
import uk.ac.starlink.votable.VOTableVersion;
import uk.ac.starlink.votable.VOTableWriter;

public class UnifiedFitsTableWriter
extends FitsTableWriter
implements DocumentedIOHandler {
    public static final FitsTableWriter.PrimaryType VOTABLE_PRIMARY_TYPE = new VOTablePrimaryType("votable", VOTableVersion.getDefaultVersion());
    public static final FitsTableWriter.PrimaryType BASIC_PRIMARY_TYPE = FitsTableWriter.PrimaryType.BASIC;
    public static final FitsTableWriter.PrimaryType NONE_PRIMARY_TYPE = FitsTableWriter.PrimaryType.NONE;
    private static final Charset XML_ENCODING = StandardCharsets.UTF_8;

    public UnifiedFitsTableWriter() {
        this.setFormatName("fits");
        this.setPrimaryType(VOTABLE_PRIMARY_TYPE);
    }

    @Override
    public String[] getExtensions() {
        String[] stringArray;
        if (this.isColfits()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "colfits";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "fits";
            stringArray3[1] = "fit";
            stringArray = stringArray3;
            stringArray3[2] = "fts";
        }
        return stringArray;
    }

    @Override
    public boolean looksLikeFile(String location) {
        return DocumentedIOHandler.matchesExtension(this, location);
    }

    @Override
    public boolean docIncludesExample() {
        return false;
    }

    @Override
    public String getXmlDescription() {
        return this.readText("/uk/ac/starlink/votable/UnifiedFitsTableWriter.xml");
    }

    @Override
    @ConfigMethod(property="primary", usage="basic|votable[n.n]|none", example="basic", sequence=110, doc="<p>Determines what is written into the Primary HDU.\nThe Primary HDU (PHDU) of a FITS file cannot contain a table;\nthe following options are available.\n<dl>\n<dt><code>basic</code></dt>\n<dd><p>A minimal PHDU is written with no interesting content\n    </p></dd><dt><code>votable[n.n]</code></dt>\n<dd><p>The PHDU contains the full table metadata as the text\n    of a VOTable document, along with headers to indicate\n    that this has been done.\n    This corresponds to the \"<strong>fits-plus</strong>\"\n    format.\n    The \"<code>[n.n]</code>\" part\n    is optional, but if included\n    (e.g. \"<code>votable1.5</code>\")\n    indicates the version of the VOTable format to use.\n    </p></dd>\n<dt><code>none</code></dt>\n<dd><p>No PHDU is written.\n    The output is therefore not a legal FITS file,\n    but it can be appended to an existing FITS file that\n    already has a PHDU and perhaps other extension HDUs.\n    </p></dd>\n</dl>\n</p>")
    public void setPrimaryType(FitsTableWriter.PrimaryType primaryType) {
        super.setPrimaryType(primaryType);
    }

    @Override
    @ConfigMethod(property="col", sequence=120, doc="<p>If true, writes data in column-oriented format.\nIn this case, the output is a single-row table in which\neach cell is an array value holding the data\nfor an entire column.\nAll the arrays in the row have the same length,\nwhich is the row count of the table being represented.\nThis corresponds to the \"<strong>colfits</strong>\" format.\n</p>")
    public void setColfits(boolean colfits) {
        super.setColfits(colfits);
    }

    @Override
    @ConfigMethod(property="var", sequence=130, example="true", doc="<p>Determines how variable-length array-valued columns\nwill be stored.\n<code>True</code> stores variable-length array values\nafter the main part of the table in the heap,\nwhile <code>false</code> stores all arrays as fixed-length\n(with a length equal to that of the longest array\nin the column) in the body of the table.The options <code>P</code> or <code>Q</code> can be used\nto force 32-bit or 64-bit pointers for indexing into the heap,\nbut it's not usually necessary since a suitable choice\nis otherwise made from the data.\n</p>")
    public void setVarArray(FitsTableWriter.VarArrayMode varArray) {
        super.setVarArray(varArray);
    }

    public static FitsTableWriter.PrimaryType createVOTablePrimaryType(VOTableVersion vers) {
        return new VOTablePrimaryType("votable" + vers.getVersionNumber(), vers);
    }

    public static FitsTableWriter.PrimaryType toPrimaryTypeInstance(String txt) {
        if (FitsTableWriter.PrimaryType.BASIC.toString().equalsIgnoreCase(txt)) {
            return FitsTableWriter.PrimaryType.BASIC;
        }
        if (FitsTableWriter.PrimaryType.NONE.toString().equalsIgnoreCase(txt)) {
            return FitsTableWriter.PrimaryType.NONE;
        }
        if (txt.length() >= 7 && "votable".equalsIgnoreCase(txt.substring(0, 7))) {
            String vtxt = txt.substring(7);
            if (vtxt.length() == 0) {
                return VOTABLE_PRIMARY_TYPE;
            }
            VOTableVersion votvers = VOTableVersion.getKnownVersions().get(vtxt);
            return votvers == null ? null : UnifiedFitsTableWriter.createVOTablePrimaryType(votvers);
        }
        return null;
    }

    private static class TableWithSerializer {
        final StarTable table_;
        final FitsTableSerializer fitser_;

        TableWithSerializer(StarTable table, FitsTableSerializer fitser) {
            this.table_ = table;
            this.fitser_ = fitser;
        }
    }

    private static class VOTablePrimaryType
    extends FitsTableWriter.PrimaryType {
        private final VOTableVersion votVersion_;

        VOTablePrimaryType(String name, VOTableVersion version) {
            super(name);
            this.votVersion_ = version;
        }

        @Override
        public boolean allowSignedByte() {
            return false;
        }

        @Override
        public void writeTables(FitsTableWriter writer, TableSequence tseq, OutputStream out) throws IOException {
            StarTable table;
            ArrayList<StarTable> tlist = new ArrayList<StarTable>();
            while ((table = tseq.nextTable()) != null) {
                tlist.add(table);
            }
            StarTable[] tables = tlist.toArray(new StarTable[0]);
            this.writeFitsPlusTables(writer, tables, out);
        }

        public int hashCode() {
            return this.votVersion_.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof VOTablePrimaryType) {
                VOTablePrimaryType other = (VOTablePrimaryType)o;
                return this.votVersion_.equals(other.votVersion_);
            }
            return false;
        }

        private void writeFitsPlusTables(FitsTableWriter writer, StarTable[] tables, OutputStream out) throws IOException {
            ArrayList<TableWithSerializer> tsList = new ArrayList<TableWithSerializer>();
            for (StarTable table : tables) {
                FitsTableSerializer fitser = writer.createSerializer(table);
                tsList.add(new TableWithSerializer(table, fitser));
            }
            TableWithSerializer[] tss = tsList.toArray(new TableWithSerializer[0]);
            DataBufferedOutputStream dout = new DataBufferedOutputStream(out);
            out = null;
            this.writeVOTablePrimary(writer, tss, dout);
            for (TableWithSerializer ts : tss) {
                writer.writeTableHDU(ts.table_, ts.fitser_, dout);
            }
            dout.flush();
        }

        private void writeVOTablePrimary(FitsTableWriter fitsWriter, TableWithSerializer[] tss, OutputStream out) throws IOException {
            String[] comments;
            int ntable = tss.length;
            StringWriter textWriter = new StringWriter();
            BufferedWriter writer = new BufferedWriter(textWriter);
            VOTableWriter votWriter = new VOTableWriter(null, false, this.votVersion_);
            votWriter.setWriteDate(fitsWriter.getWriteDate());
            votWriter.writePreTableXML(writer);
            String plusComment = new StringBuffer().append("<!-- ").append("Describes BINTABLE extensions in the following ").append(ntable == 1 ? "HDU" : ntable + " HDUs").append(".").append("-->").toString();
            writer.write(plusComment);
            writer.newLine();
            int i = 0;
            for (TableWithSerializer ts : tss) {
                if (i++ > 0) {
                    votWriter.writeBetweenTableXML(writer);
                }
                VOSerializer voser = VOSerializer.makeFitsSerializer(ts.table_, ts.fitser_, this.votVersion_);
                voser.writePreDataXML(writer);
                writer.write("<!-- Dummy VOTable - no DATA element -->");
                writer.newLine();
                voser.writePostDataXML(writer);
            }
            votWriter.writePostTableXML(writer);
            writer.flush();
            byte[] textBytes = textWriter.getBuffer().toString().getBytes(XML_ENCODING);
            int nbyte = textBytes.length;
            ArrayList<CardImage> cards = new ArrayList<CardImage>();
            CardFactory cf = CardFactory.STRICT;
            cards.addAll(Arrays.asList(cf.createLogicalCard("SIMPLE", true, "Standard FITS format"), cf.createIntegerCard("BITPIX", 8L, "Character data"), cf.createIntegerCard("NAXIS", 1L, "Text string"), cf.createIntegerCard("NAXIS1", nbyte, "Number of characters")));
            if (fitsWriter.isColfits()) {
                cards.add(cf.createLogicalCard("COLFITS", true, "Table extension stored column-oriented"));
            }
            cards.add(cf.createLogicalCard("VOTMETA", true, "Table metadata in VOTable format"));
            cards.add(cf.createLogicalCard("EXTEND", true, "There are standard extensions"));
            String plural = ntable == 1 ? "" : "s";
            for (String comm : comments = new String[]{" ", "The data in this primary HDU consists of bytes which", "comprise a VOTABLE document.", "The VOTable describes the metadata of the table" + plural + " contained", "in the following BINTABLE extension" + plural + ".", "Such a BINTABLE extension can be used on its own as a perfectly", "good table, but the information from this HDU may provide some", "useful additional metadata.", ntable == 1 ? "There is one following BINTABLE." : "There are " + ntable + " following BINTABLEs."}) {
                cards.add(cf.createCommentCard(comm));
            }
            cards.add(cf.createIntegerCard("NTABLE", ntable, "Number of following BINTABLE HDUs"));
            cards.add(CardFactory.END_CARD);
            assert (this.primaryHeaderOK(fitsWriter, cards.toArray(new CardImage[0])));
            FitsUtil.writeHeader(cards.toArray(new CardImage[0]), out);
            out.write(textBytes);
            int partial = textBytes.length % 2880;
            if (partial > 0) {
                int pad = 2880 - partial;
                out.write(new byte[pad]);
            }
        }

        private boolean primaryHeaderOK(FitsTableWriter fitsWriter, CardImage[] cards) {
            byte[] buf;
            try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
                FitsUtil.writeHeader(cards, bout);
                buf = bout.toByteArray();
            }
            catch (IOException e) {
                assert (false);
                return false;
            }
            return fitsWriter.isColfits() ? ColFitsPlusTableBuilder.isMagic(buf) : FitsPlusTableBuilder.isMagic(buf);
        }
    }

    public static class Col
    extends UnifiedFitsTableWriter {
        public Col() {
            this.setColfits(true);
            this.setFormatName("colfits");
        }
    }
}

