/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable.datalink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.w3c.dom.NodeList;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.votable.ParamElement;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.ValuesElement;
import uk.ac.starlink.votable.datalink.ExampleUrl;
import uk.ac.starlink.votable.datalink.ServiceDescriptor;
import uk.ac.starlink.votable.datalink.ServiceParam;

public class ServiceDescriptorFactory {
    public ServiceDescriptor[] readAllServiceDescriptors(VOElement el) {
        ArrayList<ServiceDescriptor> descriptorList = new ArrayList<ServiceDescriptor>();
        for (VOElement resEl : this.findServiceDescriptorResources(el)) {
            descriptorList.add(this.createServiceDescriptor(resEl));
        }
        return descriptorList.toArray(new ServiceDescriptor[0]);
    }

    public ServiceDescriptor[] readTableServiceDescriptors(TableElement tableEl) {
        VOElement scopeEl = this.getAncestorResource(this.getAncestorResource(tableEl));
        if (scopeEl == null) {
            scopeEl = (VOElement)tableEl.getOwnerDocument().getDocumentElement();
        }
        VOElement[] sdResources = this.findServiceDescriptorResources(scopeEl);
        ArrayList<ServiceDescriptor> sdList = new ArrayList<ServiceDescriptor>();
        for (VOElement sdEl : sdResources) {
            VOElement parent = sdEl.getParent();
            VOElement[] siblingTables = parent.getChildrenByName("TABLE");
            if (siblingTables != null && siblingTables.length != 0 && !Arrays.asList(siblingTables).contains(tableEl)) continue;
            sdList.add(this.createServiceDescriptor(sdEl));
        }
        return sdList.toArray(new ServiceDescriptor[0]);
    }

    public ServiceDescriptor createServiceDescriptor(VOElement resourceEl) {
        final String descriptorId = resourceEl.hasAttribute("ID") ? resourceEl.getAttribute("ID") : null;
        final String name = resourceEl.hasAttribute("name") ? resourceEl.getAttribute("name") : null;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        ArrayList<1> exampleList = new ArrayList<1>();
        for (VOElement pEl : resourceEl.getChildrenByName("PARAM")) {
            ParamElement paramEl = (ParamElement)pEl;
            String pname = paramEl.getName();
            VOElement[] value = paramEl.getObject();
            if (!(value instanceof String)) continue;
            final String pvalue = (String)value;
            if ("exampleURL".equals(pname)) {
                VOElement descripEl = pEl.getChildByName("DESCRIPTION");
                final String description = descripEl == null ? null : DOMUtils.getTextContent(descripEl);
                exampleList.add(new ExampleUrl(){

                    @Override
                    public String getUrl() {
                        return pvalue;
                    }

                    @Override
                    public String getDescription() {
                        return description;
                    }
                });
                continue;
            }
            paramMap.put(pname, pvalue);
        }
        final String accessUrl = (String)paramMap.get("accessURL");
        final String standardId = (String)paramMap.get("standardID");
        final String resourceIdentifier = (String)paramMap.get("resourceIdentifier");
        final String contentType = (String)paramMap.get("contentType");
        final ExampleUrl[] exampleUrls = exampleList.toArray(new ExampleUrl[0]);
        ArrayList<ServiceParam> inParamList = new ArrayList<ServiceParam>();
        for (VOElement groupEl : resourceEl.getChildrenByName("GROUP")) {
            if (!"inputParams".equals(groupEl.getName())) continue;
            for (VOElement pEl : groupEl.getChildrenByName("PARAM")) {
                inParamList.add(this.createServiceParam((ParamElement)pEl));
            }
        }
        VOElement descripEl = resourceEl.getChildByName("DESCRIPTION");
        final String description = descripEl == null ? null : DOMUtils.getTextContent(descripEl);
        final ServiceParam[] inputParams = inParamList.toArray(new ServiceParam[0]);
        return new ServiceDescriptor(){

            @Override
            public String getDescriptorId() {
                return descriptorId;
            }

            @Override
            public String getAccessUrl() {
                return accessUrl;
            }

            @Override
            public String getStandardId() {
                return standardId;
            }

            @Override
            public String getResourceIdentifier() {
                return resourceIdentifier;
            }

            @Override
            public String getContentType() {
                return contentType;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public ServiceParam[] getInputParams() {
                return inputParams;
            }

            @Override
            public ExampleUrl[] getExampleUrls() {
                return exampleUrls;
            }
        };
    }

    public ServiceParam createServiceParam(ParamElement paramEl) {
        String[] stringArray;
        final String name = paramEl.getName();
        String v = paramEl.getValue();
        final String value = v == null || v.trim().length() == 0 ? null : paramEl.getValue();
        final String id = paramEl.getID();
        final String ref = paramEl.hasAttribute("ref") ? paramEl.getAttribute("ref") : null;
        final String datatype = paramEl.getDatatype();
        final String unit = paramEl.getUnit();
        final String ucd = paramEl.getUcd();
        final String utype = paramEl.getUtype();
        final String xtype = paramEl.getXtype();
        final String description = paramEl.getDescription();
        final int[] arraysize = ServiceDescriptorFactory.longsToInts(paramEl.getArraysize());
        ValuesElement valuesEl = (ValuesElement)paramEl.getChildByName("VALUES");
        if (valuesEl == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = valuesEl.getMinimum();
            stringArray = stringArray2;
            stringArray2[1] = valuesEl.getMaximum();
        }
        final String[] minmax = stringArray;
        final String[] options = valuesEl == null ? null : valuesEl.getOptions();
        return new ServiceParam(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getValue() {
                return value;
            }

            @Override
            public String getId() {
                return id;
            }

            @Override
            public String getRef() {
                return ref;
            }

            @Override
            public String getDatatype() {
                return datatype;
            }

            @Override
            public String getUnit() {
                return unit;
            }

            @Override
            public String getUcd() {
                return ucd;
            }

            @Override
            public String getUtype() {
                return utype;
            }

            @Override
            public String getXtype() {
                return xtype;
            }

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public int[] getArraysize() {
                return arraysize;
            }

            @Override
            public String[] getMinMax() {
                return minmax;
            }

            @Override
            public String[] getOptions() {
                return options;
            }
        };
    }

    private VOElement[] findServiceDescriptorResources(VOElement el) {
        ArrayList<VOElement> resList = new ArrayList<VOElement>();
        NodeList resourceList = el.getElementsByVOTagName("RESOURCE");
        for (int i = 0; i < resourceList.getLength(); ++i) {
            VOElement resEl = (VOElement)resourceList.item(i);
            if (!"meta".equals(resEl.getAttribute("type")) || !"adhoc:service".equals(resEl.getAttribute("utype"))) continue;
            resList.add(resEl);
        }
        return resList.toArray(new VOElement[0]);
    }

    private VOElement getAncestorResource(VOElement el) {
        if (el != null) {
            while ((el = el.getParent()) != null && !"RESOURCE".equals(el.getVOTagName())) {
            }
        }
        return el;
    }

    private static int[] longsToInts(long[] larray) {
        if (larray == null) {
            return null;
        }
        int[] iarray = new int[larray.length];
        for (int i = 0; i < larray.length; ++i) {
            iarray[i] = (int)larray[i];
        }
        return iarray;
    }
}

