/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.feather;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.ac.bristol.star.fbs.feather.CTable;
import uk.ac.bristol.star.fbs.feather.Column;
import uk.ac.bristol.star.fbs.feather.PrimitiveArray;
import uk.ac.bristol.star.fbs.google.FlatBufferBuilder;
import uk.ac.bristol.star.feather.BufUtils;
import uk.ac.bristol.star.feather.ColStat;
import uk.ac.bristol.star.feather.FeatherColumnWriter;
import uk.ac.bristol.star.feather.NumberRandomWriter;
import uk.ac.bristol.star.feather.VariableLengthRandomWriter;

public class FeatherWriter {
    public static final int FEATHER_VERSION = 1;
    private final String description_;
    private final String tableUserMeta_;
    private final FeatherColumnWriter[] colWriters_;

    public FeatherWriter(String string, String string2, FeatherColumnWriter[] featherColumnWriterArray) {
        this.description_ = string;
        this.tableUserMeta_ = string2;
        this.colWriters_ = featherColumnWriterArray;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream = new BufferedOutputStream(outputStream);
        long l = 0L;
        l += (long)FeatherWriter.writeLittleEndianInt(outputStream, 826361158);
        assert ((l += (long)FeatherWriter.writeLittleEndianInt(outputStream, 0)) % 8L == 0L);
        int n = this.colWriters_.length;
        ColStat[] colStatArray = new ColStat[n];
        for (int i = 0; i < n; ++i) {
            colStatArray[i] = this.colWriters_[i].writeColumnBytes(outputStream);
            assert (colStatArray[i].getByteCount() % 8L == 0L);
        }
        byte[] byArray = this.createMetadataBlock(colStatArray, l);
        int n2 = byArray.length;
        assert (n2 % 8 == 0);
        outputStream.write(byArray);
        FeatherWriter.writeLittleEndianInt(outputStream, n2);
        FeatherWriter.writeLittleEndianInt(outputStream, 826361158);
        outputStream.flush();
    }

    private byte[] createMetadataBlock(ColStat[] colStatArray, long l) {
        int n;
        FlatBufferBuilder flatBufferBuilder = new FlatBufferBuilder();
        int n2 = FeatherWriter.createStringTag(flatBufferBuilder, this.description_);
        int n3 = FeatherWriter.createStringTag(flatBufferBuilder, this.tableUserMeta_);
        int n4 = this.colWriters_.length;
        int[] nArray = new int[n4];
        long l2 = l;
        long l3 = 0L;
        for (n = 0; n < n4; ++n) {
            FeatherColumnWriter featherColumnWriter = this.colWriters_[n];
            ColStat colStat = colStatArray[n];
            long l4 = colStat.getRowCount();
            long l5 = colStat.getNullCount();
            l3 = n == 0 ? l4 : Math.min(l4, l3);
            long l6 = l5 == 0L ? colStat.getDataOffset() : 0L;
            long l7 = l2 + l6;
            long l8 = colStat.getByteCount() - l6;
            l2 += colStat.getByteCount();
            PrimitiveArray.startPrimitiveArray(flatBufferBuilder);
            PrimitiveArray.addType(flatBufferBuilder, featherColumnWriter.getFeatherType().getTypeByte());
            PrimitiveArray.addOffset(flatBufferBuilder, l7);
            PrimitiveArray.addLength(flatBufferBuilder, l4);
            PrimitiveArray.addNullCount(flatBufferBuilder, l5);
            PrimitiveArray.addTotalBytes(flatBufferBuilder, l8);
            int n5 = PrimitiveArray.endPrimitiveArray(flatBufferBuilder);
            int n6 = FeatherWriter.createStringTag(flatBufferBuilder, featherColumnWriter.getName());
            int n7 = FeatherWriter.createStringTag(flatBufferBuilder, featherColumnWriter.getUserMetadata());
            Column.startColumn(flatBufferBuilder);
            Column.addName(flatBufferBuilder, n6);
            Column.addUserMetadata(flatBufferBuilder, n7);
            Column.addValues(flatBufferBuilder, n5);
            nArray[n] = Column.endColumn(flatBufferBuilder);
        }
        n = CTable.createColumnsVector(flatBufferBuilder, nArray);
        CTable.startCTable(flatBufferBuilder);
        CTable.addVersion(flatBufferBuilder, 1);
        CTable.addNumRows(flatBufferBuilder, l3);
        CTable.addDescription(flatBufferBuilder, n2);
        CTable.addMetadata(flatBufferBuilder, n3);
        CTable.addColumns(flatBufferBuilder, n);
        int n8 = CTable.endCTable(flatBufferBuilder);
        CTable.finishCTableBuffer(flatBufferBuilder, n8);
        return flatBufferBuilder.sizedByteArray();
    }

    private static int createStringTag(FlatBufferBuilder flatBufferBuilder, String string) {
        return string == null ? 0 : flatBufferBuilder.createString(string);
    }

    private static int writeLittleEndianInt(OutputStream outputStream, int n) throws IOException {
        BufUtils.writeLittleEndianInt(outputStream, n);
        return 4;
    }

    public static void main(String[] stringArray) throws IOException {
        int n = stringArray.length > 0 ? Integer.parseInt(stringArray[0]) : 5;
        short[] sArray = new short[n];
        int[] nArray = new int[n];
        long[] lArray = new long[n];
        float[] fArray = new float[n];
        double[] dArray = new double[n];
        String[] stringArray2 = new String[n];
        String[] stringArray3 = new String[]{"zero", "one", null, "three", ""};
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)i;
            nArray[i] = -i;
            lArray[i] = 4000000000L + (long)i;
            fArray[i] = i == 2 ? Float.NaN : 0.25f + (float)i;
            dArray[i] = i == 2 ? Double.NaN : 0.5 + (double)i;
            stringArray2[i] = stringArray3[i % stringArray3.length];
        }
        FeatherColumnWriter[] featherColumnWriterArray = new FeatherColumnWriter[]{NumberRandomWriter.createShortWriter("scol", sArray, null), NumberRandomWriter.createIntWriter("icol", nArray, "int col"), NumberRandomWriter.createLongWriter("lcol", lArray, null), NumberRandomWriter.createFloatWriter("fcol", fArray, null), NumberRandomWriter.createDoubleWriter("dcol", dArray, null), VariableLengthRandomWriter.createStringWriter("tcol", stringArray2, null, false)};
        new FeatherWriter("test table", null, featherColumnWriterArray).write(System.out);
    }
}

