/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.gbin;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.ac.starlink.gbin.GbinTableProfile;
import uk.ac.starlink.gbin.Representation;

public class DefaultGbinTableProfile
implements GbinTableProfile {
    private final Map<Class<?>, Representation<?>> reprMap_ = new LinkedHashMap();
    private static final Map<Class<?>, Class<?>> primMap_ = Collections.unmodifiableMap(DefaultGbinTableProfile.createPrimitiveMap());

    public DefaultGbinTableProfile() {
        this(new Class[]{String.class}, new Class[]{Class.class}, new Class[0]);
    }

    public DefaultGbinTableProfile(Class<?>[] simpleClasses, Class<?>[] stringClasses, Class<?>[] ignoreClasses) {
        for (Class<?> primClazz : primMap_.keySet()) {
            Class<?> wrapperClazz = primMap_.get(primClazz);
            Class<?> arrayClazz = Array.newInstance(primClazz, 0).getClass();
            Representation<?> wrapperRepr = DefaultGbinTableProfile.createSimpleColumnRepresentation(wrapperClazz);
            this.reprMap_.put(primClazz, wrapperRepr);
            this.reprMap_.put(wrapperClazz, wrapperRepr);
            this.reprMap_.put(arrayClazz, DefaultGbinTableProfile.createSimpleColumnRepresentation(arrayClazz));
        }
        for (Class<?> clazz : simpleClasses) {
            this.reprMap_.put(clazz, DefaultGbinTableProfile.createSimpleColumnRepresentation(clazz));
        }
        for (Class<?> clazz : stringClasses) {
            this.reprMap_.put(clazz, DefaultGbinTableProfile.createStringColumnRepresentation(clazz));
        }
        for (Class<?> clazz : ignoreClasses) {
            this.reprMap_.put(clazz, null);
        }
    }

    @Override
    public boolean isReadMeta() {
        return true;
    }

    @Override
    public boolean isTestMagic() {
        return true;
    }

    @Override
    public boolean isHierarchicalNames() {
        return false;
    }

    @Override
    public String getNameSeparator() {
        return "_";
    }

    @Override
    public boolean isSortedMethods() {
        return true;
    }

    @Override
    public String[] getIgnoreMethodNames() {
        return new String[]{"getClass", "getField", "getStringValue", "getGTDescription", "getParamMaxValues", "getParamMinValues", "getParamOutOfRangeValues", "getFieldNames"};
    }

    @Override
    public String[] getIgnoreMethodDeclaringClasses() {
        return new String[]{"gaia.cu1.tools.dm.GaiaRoot", "gaia.cu1.tools.dmimpl.GaiaRootImpl"};
    }

    @Override
    public Representation<?> createRepresentation(Class<?> clazz) {
        if (this.reprMap_.containsKey(clazz)) {
            return this.reprMap_.get(clazz);
        }
        if (clazz.isArray()) {
            Class<?> scalarClass = this.getScalarClass(clazz);
            if (this.reprMap_.containsKey(scalarClass)) {
                Representation<?> scalarRepr = this.reprMap_.get(scalarClass);
                if (scalarRepr == null || !scalarRepr.isColumn()) {
                    return null;
                }
                return DefaultGbinTableProfile.createSimpleColumnRepresentation(clazz);
            }
            return null;
        }
        return DefaultGbinTableProfile.createIdentityRepresentation(clazz, false);
    }

    private Class<?> getScalarClass(Class<?> clazz) {
        if (this.reprMap_.containsKey(clazz)) {
            return clazz;
        }
        if (clazz.isArray()) {
            return this.getScalarClass(clazz.getComponentType());
        }
        return clazz;
    }

    public static <T> Representation<T> createIdentityRepresentation(final Class<T> clazz, final boolean isColumn) {
        return new Representation<T>(){

            @Override
            public Class<T> getContentClass() {
                return clazz;
            }

            @Override
            public T representValue(Object value) {
                return clazz.isInstance(value) ? (Object)clazz.cast(value) : null;
            }

            @Override
            public boolean isColumn() {
                return isColumn;
            }
        };
    }

    private static <T> Representation<T> createSimpleColumnRepresentation(Class<T> clazz) {
        return DefaultGbinTableProfile.createIdentityRepresentation(clazz, true);
    }

    public static Representation<String> createStringColumnRepresentation(Class<?> clazz) {
        return new Representation<String>(){

            @Override
            public Class<String> getContentClass() {
                return String.class;
            }

            @Override
            public String representValue(Object value) {
                return value == null ? null : value.toString();
            }

            @Override
            public boolean isColumn() {
                return true;
            }
        };
    }

    private static Map<Class<?>, Class<?>> createPrimitiveMap() {
        LinkedHashMap map = new LinkedHashMap();
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Character.TYPE, Character.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Short.TYPE, Short.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Float.TYPE, Float.class);
        map.put(Double.TYPE, Double.class);
        return map;
    }
}

