/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.parquet;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Types;
import uk.ac.starlink.parquet.Encoder;
import uk.ac.starlink.parquet.Encoders;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.util.IntList;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.StringElementSizer;
import uk.ac.starlink.votable.VOSerializer;
import uk.ac.starlink.votable.VOSerializerConfig;
import uk.ac.starlink.votable.VOTableVersion;
import uk.ac.starlink.votable.VOTableWriter;

public class StarParquetWriter
extends ParquetWriter<Object[]> {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.parquet");

    private StarParquetWriter(Path path, StarWriteSupport support) throws IOException {
        super(path, (WriteSupport)support);
    }

    private static Map<String, String> getParquetMetadata(StarTable table) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String name = table.getName();
        if (name != null && name.trim().length() > 0) {
            map.put("name", name);
        }
        int maxleng = 160;
        for (DescribedValue dval : table.getParameters()) {
            String ptxt;
            ValueInfo pinfo = dval.getInfo();
            String pname = pinfo.getName();
            Object pvalue = dval.getValue();
            if (pvalue == null || (ptxt = pinfo.formatValue(pvalue, maxleng)) == null || ptxt.trim().length() <= 0 || !ptxt.equals(pinfo.formatValue(pvalue, maxleng + 1)) || map.containsKey(pname)) continue;
            map.put(pname, ptxt);
        }
        return map;
    }

    private static String createMetadataVOTable(StarTable table, VOTableVersion version) {
        if (version == null) {
            return null;
        }
        StringWriter textWriter = new StringWriter();
        BufferedWriter writer = new BufferedWriter(textWriter);
        VOTableWriter votWriter = new VOTableWriter(null, false, version){};
        votWriter.setWriteDate(false);
        VOSerializerConfig config = new VOSerializerConfig(DataFormat.TABLEDATA, version, StringElementSizer.FIXED2);
        try {
            VOSerializer voser = VOSerializer.makeSerializer(config, table);
            votWriter.writePreTableXML(writer);
            voser.writePreDataXML(writer);
            writer.write("<!-- Dummy VOTable - no DATA element -->");
            writer.newLine();
            voser.writePostDataXML(writer);
            votWriter.writePostTableXML(writer);
            writer.flush();
            return textWriter.getBuffer().toString();
        }
        catch (IOException e) {
            logger_.log(Level.WARNING, "Failed to serialize VOTable metadata: " + e, e);
            return null;
        }
    }

    private static class OutCol<T> {
        final Encoder<T> encoder_;
        final int icIn_;
        final int icOut_;
        final String cname_;

        OutCol(Encoder<T> encoder, int icIn, int icOut) {
            this.encoder_ = encoder;
            this.icIn_ = icIn;
            this.icOut_ = icOut;
            this.cname_ = encoder.getColumnName();
        }

        void write(Object value, RecordConsumer consumer) {
            T typedValue = this.encoder_.typedValue(value);
            if (typedValue != null) {
                consumer.startField(this.cname_, this.icOut_);
                this.encoder_.addValue(typedValue, consumer);
                consumer.endField(this.cname_, this.icOut_);
            } else {
                this.encoder_.checkNull();
            }
        }

        static <T> OutCol<T> create(Encoder<T> encoder, int icIn, int icOut) {
            return new OutCol<T>(encoder, icIn, icOut);
        }
    }

    private static class StarWriteSupport
    extends WriteSupport<Object[]> {
        private final int ncol_;
        private final OutCol<?>[] outcols_;
        private final MessageType schema_;
        private final Map<String, String> metaMap_;
        private RecordConsumer consumer_;

        StarWriteSupport(StarTable table, boolean groupArray, VOTableVersion votmetaVersion, Map<String, String> kvItems) {
            String votmeta;
            ArrayList outcols = new ArrayList();
            Types.MessageTypeBuilder schemaBuilder = Types.buildMessage();
            int jc = 0;
            int nc = table.getColumnCount();
            IntList icList = new IntList(nc);
            for (int ic = 0; ic < nc; ++ic) {
                ColumnInfo cinfo = table.getColumnInfo(ic);
                Encoder<?> encoder = Encoders.createEncoder(cinfo, groupArray);
                if (encoder != null) {
                    outcols.add(OutCol.create(encoder, ic, jc++));
                    schemaBuilder.addField(encoder.getColumnType());
                    icList.add(ic);
                    continue;
                }
                logger_.warning("Can't write column to parquet: " + cinfo);
            }
            this.schema_ = schemaBuilder.named("table");
            this.outcols_ = outcols.toArray(new OutCol[0]);
            this.ncol_ = this.outcols_.length;
            ColumnPermutedStarTable outTable = new ColumnPermutedStarTable(table, icList.toIntArray());
            assert (outTable.getColumnCount() == this.ncol_);
            this.metaMap_ = StarParquetWriter.getParquetMetadata(outTable);
            if (votmetaVersion != null && (votmeta = StarParquetWriter.createMetadataVOTable(outTable, votmetaVersion)) != null) {
                this.metaMap_.put("IVOA.VOTable-Parquet.content", votmeta);
                this.metaMap_.put("IVOA.VOTable-Parquet.version", "1.0");
            }
            if (kvItems != null) {
                for (Map.Entry<String, String> entry : kvItems.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (value == null) {
                        this.metaMap_.remove(key);
                        continue;
                    }
                    this.metaMap_.put(key, value);
                }
            }
        }

        public String getName() {
            return "STIL";
        }

        public WriteSupport.WriteContext init(Configuration config) {
            return new WriteSupport.WriteContext(this.schema_, this.metaMap_);
        }

        public WriteSupport.FinalizedWriteContext finalizeWrite() {
            return new WriteSupport.FinalizedWriteContext(this.metaMap_);
        }

        public void prepareForWrite(RecordConsumer recordConsumer) {
            this.consumer_ = recordConsumer;
        }

        public void write(Object[] record) {
            this.consumer_.startMessage();
            for (OutCol<?> outcol : this.outcols_) {
                outcol.write(record[outcol.icIn_], this.consumer_);
            }
            this.consumer_.endMessage();
        }
    }

    public static class StarBuilder
    extends ParquetWriter.Builder<Object[], StarBuilder> {
        private final StarTable table_;
        private boolean groupArray_;
        private VOTableVersion votmetaVersion_;
        private Map<String, String> kvItems_;

        public StarBuilder(StarTable table, Path path) {
            super(path);
            this.table_ = table;
        }

        public StarBuilder(StarTable table, OutputFile ofile) {
            super(ofile);
            this.table_ = table;
        }

        public StarTable getTable() {
            return this.table_;
        }

        public StarBuilder withGroupArray(boolean groupArray) {
            this.groupArray_ = groupArray;
            return this.self();
        }

        public StarBuilder withVOTableMetadata(VOTableVersion version) {
            this.votmetaVersion_ = version;
            return this.self();
        }

        public StarBuilder withKeyValueItems(Map<String, String> kvItems) {
            this.kvItems_ = kvItems;
            return this.self();
        }

        public StarBuilder self() {
            return this;
        }

        public WriteSupport<Object[]> getWriteSupport(Configuration config) {
            if (this.table_ == null) {
                throw new IllegalStateException("builder.withTable not called");
            }
            return new StarWriteSupport(this.table_, this.groupArray_, this.votmetaVersion_, this.kvItems_);
        }
    }
}

