/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.awt.datatransfer.DataFlavor;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import uk.ac.starlink.fits.ColFitsStarTable;
import uk.ac.starlink.fits.FitsHeader;
import uk.ac.starlink.fits.FitsUtil;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.formats.DocumentedTableBuilder;
import uk.ac.starlink.util.DataSource;

public class ColFitsTableBuilder
extends DocumentedTableBuilder {
    private final WideFits wide_;

    public ColFitsTableBuilder() {
        this(WideFits.DEFAULT);
    }

    public ColFitsTableBuilder(WideFits wide) {
        super(new String[]{"colfits"});
        this.wide_ = wide;
    }

    @Override
    public String getFormatName() {
        return "colfits-basic";
    }

    @Override
    public void streamStarTable(InputStream in, TableSink sink, String pos) throws TableFormatException {
        throw new TableFormatException("Can't stream from colFITS format");
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy storagePolicy) throws IOException {
        if (!FitsUtil.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("Doesn't look like a FITS file");
        }
        try (InputStream in = datsrc.getInputStream();){
            long pos = 0L;
            pos += FitsUtil.skipHDUs(in, 1);
            FitsHeader hdr = FitsUtil.readHeader(in);
            ColFitsStarTable colFitsStarTable = new ColFitsStarTable(datsrc, hdr, pos += hdr.getHeaderByteCount(), false, this.wide_);
            return colFitsStarTable;
        }
        catch (EOFException e) {
            throw new TableFormatException("No extensions", e);
        }
    }

    @Override
    public boolean canStream() {
        return false;
    }

    @Override
    public boolean docIncludesExample() {
        return false;
    }

    @Override
    public String getXmlDescription() {
        return this.readText("ColFitsTableBuilder.xml");
    }
}

