/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.auth.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

public class BasicX509TrustManager
implements X509TrustManager {
    private static final String TRUST_ALL_PROPERTY = BasicX509TrustManager.class.getName() + ".trust";
    private X509TrustManager delegate;

    public BasicX509TrustManager(X509TrustManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] xcs, String str) throws CertificateException {
        this.delegate.checkClientTrusted(xcs, str);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] xcs, String str) throws CertificateException {
        if (System.getProperty(TRUST_ALL_PROPERTY) != null) {
            return;
        }
        this.delegate.checkServerTrusted(xcs, str);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] ret = this.delegate.getAcceptedIssuers();
        return ret;
    }
}

