/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ecsv;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public abstract class LineReader
implements Closeable {
    private final InputStream in_;
    private static final int BUFSIZ = 16384;

    protected LineReader(InputStream in) {
        this.in_ = in;
    }

    public abstract String readLine() throws IOException;

    @Override
    public void close() throws IOException {
        this.in_.close();
    }

    public static LineReader createAsciiLineReader(InputStream in) {
        return new AsciiLineReader(in);
    }

    public static LineReader createArrayLineReader(final String[] lines) {
        return new LineReader(null){
            int irow_;

            @Override
            public String readLine() {
                while (this.irow_ < lines.length) {
                    String line = lines[this.irow_];
                    if (line != null && line.trim().length() > 0) {
                        return line;
                    }
                    ++this.irow_;
                }
                return null;
            }

            @Override
            public void close() {
            }
        };
    }

    private static class AsciiLineReader
    extends LineReader {
        private final InputStream in_;
        private final byte[] bbuf_;
        private final StringBuilder sbuf_;
        private int nb_ = 0;
        private int ipos_ = 0;

        public AsciiLineReader(InputStream in) {
            super(in);
            this.in_ = in;
            this.bbuf_ = new byte[16384];
            this.sbuf_ = new StringBuilder();
        }

        @Override
        public String readLine() throws IOException {
            this.sbuf_.setLength(0);
            boolean hasContent = false;
            while (true) {
                if (this.ipos_ >= this.nb_) {
                    this.nb_ = this.in_.read(this.bbuf_);
                    if (this.nb_ <= 0) {
                        assert (this.nb_ < 0);
                        return null;
                    }
                    this.ipos_ = 0;
                }
                char chr = (char)(this.bbuf_[this.ipos_] & 0xFF);
                switch (chr) {
                    case '\r': {
                        break;
                    }
                    case '\n': {
                        if (hasContent) {
                            return this.sbuf_.toString();
                        }
                        this.sbuf_.setLength(0);
                        break;
                    }
                    case '\t': 
                    case ' ': {
                        this.sbuf_.append(chr);
                        break;
                    }
                    default: {
                        hasContent = true;
                        this.sbuf_.append(chr);
                    }
                }
                ++this.ipos_;
            }
        }
    }
}

