/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.feather;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import uk.ac.bristol.star.feather.Decoder;
import uk.ac.bristol.star.feather.FeatherColumn;
import uk.ac.bristol.star.feather.FeatherTable;
import uk.ac.bristol.star.feather.FeatherType;
import uk.ac.bristol.star.feather.Reader;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;

public class FeatherStarTable
extends AbstractStarTable {
    private final FeatherTable ftable_;
    private final int ncol_;
    private final long nrow_;
    private final String name_;
    private final FeatherColumn[] fcols_;
    private final ColumnInfo[] colInfos_;
    private final RowReader randomReader_;
    public static final String UCD_KEY = "ucd";
    public static final String UTYPE_KEY = "utype";
    public static final String UNIT_KEY = "unit";
    public static final String DESCRIPTION_KEY = "description";
    public static final String SHAPE_KEY = "shape";
    public static final String META_KEY = "meta";
    public static final ValueInfo FTYPE_INFO = new DefaultValueInfo("feather_type", String.class, "Data type code from Feather format input file");

    public FeatherStarTable(FeatherTable ftable) {
        this.ftable_ = ftable;
        this.ncol_ = ftable.getColumnCount();
        this.nrow_ = ftable.getRowCount();
        this.name_ = ftable.getDescription();
        this.fcols_ = new FeatherColumn[this.ncol_];
        this.colInfos_ = new ColumnInfo[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            this.fcols_[icol] = ftable.getColumn(icol);
            this.colInfos_[icol] = FeatherStarTable.createColumnInfo(this.fcols_[icol]);
        }
        this.randomReader_ = new RowReader();
    }

    public FeatherStarTable(File file) throws IOException {
        this(FeatherTable.fromFile(file));
    }

    public int getColumnCount() {
        return this.ncol_;
    }

    public long getRowCount() {
        return this.nrow_;
    }

    public boolean isRandom() {
        return true;
    }

    public String getName() {
        return this.name_;
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos_[icol];
    }

    public Object getCell(long irow, int icol) throws IOException {
        return this.randomReader_.getCell(irow, icol);
    }

    public Object getRow(long irow, int icol) throws IOException {
        return this.randomReader_.getRow(irow);
    }

    public RowSequence getRowSequence() {
        final RowReader rowReader = new RowReader();
        return new RowSequence(){
            long irow_ = -1L;
            boolean hasData_ = false;

            public boolean next() {
                if (this.irow_ < FeatherStarTable.this.nrow_ - 1L) {
                    ++this.irow_;
                    this.hasData_ = true;
                } else {
                    this.hasData_ = false;
                }
                return this.hasData_;
            }

            public Object getCell(int icol) throws IOException {
                if (this.hasData_) {
                    return rowReader.getCell(this.irow_, icol);
                }
                throw new IllegalStateException();
            }

            public Object[] getRow() throws IOException {
                if (this.hasData_) {
                    return rowReader.getRow(this.irow_);
                }
                throw new IllegalStateException();
            }

            public void close() {
            }
        };
    }

    public RowAccess getRowAccess() {
        final RowReader rowReader = new RowReader();
        return new RowAccess(){
            long irow_ = -1L;

            public void setRowIndex(long irow) {
                this.irow_ = irow;
            }

            public Object getCell(int icol) throws IOException {
                return rowReader.getCell(this.irow_, icol);
            }

            public Object[] getRow() throws IOException {
                return rowReader.getRow(this.irow_);
            }

            public void close() {
            }
        };
    }

    public void close() throws IOException {
    }

    private static ColumnInfo createColumnInfo(FeatherColumn fcol) {
        Decoder<?> decoder = fcol.getDecoder();
        Class<?> clazz = decoder.getValueClass();
        FeatherType ftype = decoder.getFeatherType();
        ColumnInfo info = new ColumnInfo(fcol.getName(), clazz, null);
        info.setNullable(fcol.getNullCount() > 0L);
        Map<String, String> metaMap = FeatherStarTable.getColumnMetaMap(fcol.getUserMeta());
        for (Map.Entry<String, String> entry : metaMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equals(UCD_KEY)) {
                info.setUCD(value);
            }
            if (key.equals(UTYPE_KEY)) {
                info.setUtype(value);
            }
            if (key.equals(UNIT_KEY)) {
                info.setUnitString(value);
            }
            if (key.equals(DESCRIPTION_KEY)) {
                info.setDescription(value);
            }
            if (!key.equals(SHAPE_KEY)) continue;
            info.setShape(DefaultValueInfo.unformatShape((String)value));
        }
        info.setAuxDatum(new DescribedValue(FTYPE_INFO, (Object)ftype.toString()));
        if (ftype == FeatherType.UINT8 && clazz.equals(Short.class)) {
            info.setAuxDatum(new DescribedValue(Tables.UBYTE_FLAG_INFO, (Object)Boolean.TRUE));
        }
        return info;
    }

    private static Map<String, String> getColumnMetaMap(String userMeta) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (userMeta != null && userMeta.trim().length() > 0) {
            try {
                JSONObject json = new JSONObject(userMeta);
                for (String key : json.keySet()) {
                    if (!key.equals(UCD_KEY) && !key.equals(UTYPE_KEY) && !key.equals(UNIT_KEY) && !key.equals(DESCRIPTION_KEY) && !key.equals(SHAPE_KEY)) continue;
                    map.put(key, json.get(key).toString());
                }
            }
            catch (JSONException e) {
                map.put(META_KEY, userMeta);
            }
        }
        return map;
    }

    private class RowReader {
        final Reader<?>[] rdrs_;

        private RowReader() {
            this.rdrs_ = new Reader[FeatherStarTable.this.ncol_];
        }

        Reader<?> getReader(int icol) throws IOException {
            Reader<?> rdr = this.rdrs_[icol];
            if (rdr != null) {
                return rdr;
            }
            this.rdrs_[icol] = FeatherStarTable.this.fcols_[icol].createReader();
            return this.rdrs_[icol];
        }

        Object getCell(long irow, int icol) throws IOException {
            return this.getReader(icol).getObject(irow);
        }

        Object[] getRow(long irow) throws IOException {
            Object[] row = new Object[FeatherStarTable.this.ncol_];
            for (int ic = 0; ic < FeatherStarTable.this.ncol_; ++ic) {
                row[ic] = this.getReader(ic).getObject(irow);
            }
            return row;
        }
    }
}

