/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.util.regex.Pattern;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.TimeMapper;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.votable.Timesys;

class VOTableDomainMappers {
    static final Pattern ISO8601_UNIT_PATTERN = Pattern.compile("iso.?8601", 2);
    static final Pattern ISO8601_UCD_PATTERN = Pattern.compile("time(\\.(epoch|start|end))?(;.*)?|TIME_DATE(_.*)?", 2);
    static final Pattern OBSCORE_T_UTYPE_PATTERN = Pattern.compile(".*Char\\.TimeAxis\\.Coverage\\.Bounds\\.Limits.*", 2);

    VOTableDomainMappers() {
    }

    public static DomainMapper[] getMappers(ValueInfo info) {
        DomainMapper[] domainMapperArray;
        TimeMapper tmapper = VOTableDomainMappers.getTimeMapper(info);
        if (tmapper == null) {
            domainMapperArray = new DomainMapper[]{};
        } else {
            DomainMapper[] domainMapperArray2 = new DomainMapper[1];
            domainMapperArray = domainMapperArray2;
            domainMapperArray2[0] = tmapper;
        }
        return domainMapperArray;
    }

    private static TimeMapper getTimeMapper(ValueInfo info) {
        Class<?> clazz = info.getContentClass();
        String units = info.getUnitString();
        String ucd = info.getUCD();
        String utype = info.getUtype();
        String xtype = info.getXtype();
        if (xtype == null) {
            xtype = "";
        }
        if (units == null) {
            units = "";
        }
        if (ucd == null) {
            ucd = "";
        }
        if (utype == null) {
            utype = "";
        }
        units = VOTableDomainMappers.unquote(units.trim()).trim();
        if (String.class.isAssignableFrom(clazz) && ("iso8601".equals(xtype) || ISO8601_UNIT_PATTERN.matcher(xtype).matches() || "adql:TIMESTAMP".equalsIgnoreCase(xtype) || "timestamp".equalsIgnoreCase(xtype) || ISO8601_UNIT_PATTERN.matcher(units).matches() || ISO8601_UCD_PATTERN.matcher(ucd).matches())) {
            return TimeMapper.ISO_8601;
        }
        Timesys tsys = Timesys.getTimesys(info);
        if (tsys != null && Number.class.isAssignableFrom(clazz)) {
            double jdOrigin = tsys.getTimeorigin();
            final double unitSec = VOTableDomainMappers.getUnitInSeconds(units);
            if (!Double.isNaN(unitSec) && !Double.isNaN(jdOrigin)) {
                double unixDayOrigin = jdOrigin - 2440587.5;
                final double unixSecOrigin = unixDayOrigin * 60.0 * 60.0 * 24.0;
                return new TimeMapper(clazz, "TIMESYS", tsys.toString()){

                    @Override
                    public double toUnixSeconds(Object sourceValue) {
                        double val = sourceValue instanceof Number ? ((Number)sourceValue).doubleValue() : Double.NaN;
                        return Double.isNaN(val) ? Double.NaN : val * unitSec + unixSecOrigin;
                    }
                };
            }
        }
        if (Number.class.isAssignableFrom(clazz)) {
            if ("mjd".equalsIgnoreCase(xtype) || OBSCORE_T_UTYPE_PATTERN.matcher(utype).matches() && "d".equals(units)) {
                return TimeMapper.MJD;
            }
            if ("jd".equalsIgnoreCase(xtype)) {
                return TimeMapper.JD;
            }
            if ("yr".equals(units) || "a".equals(units) || "year".equals(units)) {
                return TimeMapper.DECIMAL_YEAR;
            }
        }
        return null;
    }

    private static String unquote(String str) {
        int leng = str.length();
        if (leng > 1 && (str.charAt(0) == '\'' && str.charAt(leng - 1) == '\'' || str.charAt(0) == '\"' && str.charAt(leng - 1) == '\"')) {
            return str.substring(1, leng - 1);
        }
        return str;
    }

    private static double getUnitInSeconds(String units) {
        if ("ps".equals(units)) {
            return 1.0E-12;
        }
        if ("ns".equals(units)) {
            return 1.0E-9;
        }
        if ("us".equals(units)) {
            return 1.0E-6;
        }
        if ("ms".equals(units)) {
            return 0.001;
        }
        if ("s".equals(units)) {
            return 1.0;
        }
        if ("ks".equals(units)) {
            return 1000.0;
        }
        if ("d".equals(units)) {
            return 86400.0;
        }
        if ("a".equals(units) || "yr".equals(units) || "year".equals(units)) {
            return 3.15576E7;
        }
        return Double.NaN;
    }
}

