/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

public class HapiVersion {
    private final String name_;
    private final String datasetName_;
    private final String startName_;
    private final String stopName_;
    public static final HapiVersion ASSUMED = HapiVersion.createVersion2("2.x?");
    public static final HapiVersion V20 = HapiVersion.createVersion2("2");
    public static final HapiVersion V30;
    private static final HapiVersion[] STANDARD_VERSIONS;

    private HapiVersion(String name, String datasetName, String startName, String stopName) {
        this.name_ = name;
        this.datasetName_ = datasetName;
        this.startName_ = startName;
        this.stopName_ = stopName;
    }

    public String getName() {
        return this.name_;
    }

    public String getDatasetRequestParam() {
        return this.datasetName_;
    }

    public String getStartRequestParam() {
        return this.startName_;
    }

    public String getStopRequestParam() {
        return this.stopName_;
    }

    public static HapiVersion fromText(String name) {
        if (name == null) {
            return ASSUMED;
        }
        return name.startsWith("3") ? HapiVersion.createVersion3(name) : HapiVersion.createVersion2(name);
    }

    public static HapiVersion[] getStandardVersions() {
        return (HapiVersion[])STANDARD_VERSIONS.clone();
    }

    private static HapiVersion createVersion2(String name) {
        return new HapiVersion(name, "id", "time.min", "time.max");
    }

    private static HapiVersion createVersion3(String name) {
        return new HapiVersion(name, "dataset", "start", "stop");
    }

    static {
        STANDARD_VERSIONS = new HapiVersion[]{V20, V30 = HapiVersion.createVersion3("3")};
    }
}

