/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.formats.CsvStarTable;
import uk.ac.starlink.table.formats.RowEvaluatorTableBuilder;
import uk.ac.starlink.util.ConfigMethod;
import uk.ac.starlink.util.DataSource;

public class CsvTableBuilder
extends RowEvaluatorTableBuilder {
    private Boolean hasHeader_;
    private char delimiter_ = (char)44;

    public CsvTableBuilder() {
        super(new String[]{"csv"});
    }

    @Override
    public String getFormatName() {
        return "CSV";
    }

    @Override
    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy policy) throws TableFormatException, IOException {
        return new CsvStarTable(datsrc, this.hasHeader_, this.getMaxSample(), this.getDelimiter(), this.getDecoders());
    }

    @Override
    public boolean docIncludesExample() {
        return true;
    }

    @Override
    public String getXmlDescription() {
        return this.readText("CsvTableBuilder.xml");
    }

    @ConfigMethod(property="header", doc="<p>Indicates whether the input CSV file contains the\noptional one-line header giving column names.\nOptions are:\n<ul>\n<li><code>true</code>: the first line is a header line containing column names</li>\n<li><code>false</code>: all lines are data lines, and column names will be assigned automatically</li>\n<li><code>null</code>: a guess will be made about whether the first line is a header or not depending on what it looks like</li>\n</ul>\nThe default value is <code>null</code> (auto-determination).\nThis usually works OK, but can get into trouble if\nall the columns look like string values.\n</p>", usage="true|false|null", example="true", sequence=1)
    public void setHasHeader(Boolean hasHeader) {
        this.hasHeader_ = hasHeader;
    }

    public Boolean getHasHeader() {
        return this.hasHeader_;
    }

    @ConfigMethod(property="delimiter", doc="<p>Field delimiter character, by default a comma. Permitted values are a single character like \"<code>|</code>\", a hexadecimal character code like \"<code>0x7C</code>\", or one of the names \"<code>comma</code>\", \"<code>space</code>\" or \"<code>tab</code>\". Some choices of delimiter, for instance whitespace characters, might not work well or might behave in surprising ways.</p>", example="|", sequence=2)
    public void setDelimiter(char delimiter) {
        this.delimiter_ = delimiter;
    }

    public char getDelimiter() {
        return this.delimiter_;
    }
}

