/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.util.logging.Logger;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.util.IOConsumer;

public abstract class ErrorMode {
    private final String name_;
    private final boolean isReport_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.formats");
    public static final ErrorMode IGNORE;
    public static final ErrorMode WARN;
    public static final ErrorMode FAIL;
    public static final ErrorMode[] OPTIONS;

    protected ErrorMode(String name, boolean isReport) {
        this.isReport_ = isReport;
        this.name_ = name;
    }

    public boolean isReport() {
        return this.isReport_;
    }

    public String toString() {
        return this.name_;
    }

    public abstract void report(String var1) throws IOException;

    private static ErrorMode createMode(String name, boolean isReport, final IOConsumer<String> reporter) {
        return new ErrorMode(name, isReport){

            @Override
            public void report(String msg) throws IOException {
                reporter.accept(msg);
            }
        };
    }

    static {
        ErrorMode[] errorModeArray = new ErrorMode[3];
        errorModeArray[0] = IGNORE = ErrorMode.createMode("ignore", false, txt -> {});
        errorModeArray[1] = WARN = ErrorMode.createMode("warn", true, logger_::warning);
        errorModeArray[2] = FAIL = ErrorMode.createMode("fail", true, txt -> {
            throw new TableFormatException((String)txt);
        });
        OPTIONS = errorModeArray;
    }
}

