/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.gui.FilestoreTableLoadDialog;
import uk.ac.starlink.table.gui.TableLoadClient;
import uk.ac.starlink.table.gui.TableLoadDialog;
import uk.ac.starlink.table.gui.TableLoadWorker;

public abstract class TableLoadPanel
extends JPanel {
    private final TableLoadDialog tld_;
    private final Action okAct_;
    private final Action cancelAct_;
    private JProgressBar progBar_;
    private volatile TableLoadWorker worker_;

    public TableLoadPanel(TableLoadDialog tld, StarTableFactory tfact) {
        super(new BorderLayout());
        this.tld_ = tld;
        this.progBar_ = new JProgressBar();
        this.progBar_.setString("");
        this.progBar_.setStringPainted(true);
        JPanel main = new JPanel(new BorderLayout());
        Box controlBox = Box.createHorizontalBox();
        controlBox.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        main.add((Component)controlBox, "South");
        this.add((Component)main, "Center");
        this.okAct_ = new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                assert (TableLoadPanel.this.worker_ == null);
                TableLoadPanel.this.worker_ = new TableLoadWorker(TableLoadPanel.this.tld_.createTableLoader(), TableLoadPanel.this.getLoadClient(), TableLoadPanel.this.getProgressBar()){

                    @Override
                    protected void finish(boolean cancelled) {
                        super.finish(cancelled);
                        assert (TableLoadPanel.this.worker_ == this);
                        TableLoadPanel.this.worker_ = null;
                        TableLoadPanel.this.updateStatus();
                    }
                };
                TableLoadPanel.this.worker_.start();
                TableLoadPanel.this.updateStatus();
            }
        };
        this.cancelAct_ = new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                assert (TableLoadPanel.this.worker_ != null);
                if (TableLoadPanel.this.worker_ != null) {
                    TableLoadPanel.this.worker_.cancel();
                }
            }
        };
        controlBox.add(Box.createHorizontalGlue());
        controlBox.add(new JButton(this.cancelAct_));
        controlBox.add(Box.createHorizontalStrut(5));
        controlBox.add(new JButton(this.okAct_));
        this.okAct_.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    TableLoadPanel.this.updateStatus();
                }
            }
        });
        this.tld_.configure(tfact, this.okAct_);
        main.add(tld.getQueryComponent(), "Center");
        this.updateStatus();
    }

    protected abstract TableLoadClient getLoadClient();

    public Action getOkAction() {
        return this.okAct_;
    }

    public Action getCancelAction() {
        return this.cancelAct_;
    }

    public boolean isLoading() {
        return this.worker_ != null;
    }

    public JProgressBar getProgressBar() {
        return this.progBar_;
    }

    public void setProgressBar(JProgressBar progBar) {
        this.progBar_ = progBar;
    }

    private void updateStatus() {
        this.okAct_.setEnabled(this.worker_ == null);
        this.cancelAct_.setEnabled(this.worker_ != null);
    }

    public static StarTable loadTable(Component parent, TableLoadDialog tld, StarTableFactory tfact) throws IOException {
        ModalDialog dia = new ModalDialog(parent, tld, tfact, false);
        dia.pack();
        dia.setLocationRelativeTo(parent);
        dia.setVisible(true);
        StarTable[] tables = dia.getTables();
        if (tables.length == 0) {
            return null;
        }
        assert (tables.length == 1);
        return tables[0];
    }

    public static StarTable[] loadTables(Component parent, TableLoadDialog tld, StarTableFactory tfact) throws IOException {
        ModalDialog dia = new ModalDialog(parent, tld, tfact, true);
        dia.pack();
        dia.setLocationRelativeTo(parent);
        dia.setVisible(true);
        return dia.getTables();
    }

    public static void main(String[] args) throws IOException {
        FilestoreTableLoadDialog tld = new FilestoreTableLoadDialog();
        StarTableFactory tfact = new StarTableFactory(true);
        boolean multi = false;
        if (multi) {
            StarTable[] tables = TableLoadPanel.loadTables(null, tld, tfact);
            for (int i = 0; i < tables.length; ++i) {
                StarTable table = tables[i];
                System.out.println(i + ":\t" + table.getName() + " \t" + table.getColumnCount() + " x " + table.getRowCount());
            }
        } else {
            StarTable table = TableLoadPanel.loadTable(null, tld, tfact);
            System.out.println(table.getName() + " \t" + table.getColumnCount() + " x " + table.getRowCount());
        }
    }

    private static class ModalDialog
    extends JDialog {
        private final List<StarTable> tableList_;
        private Throwable error_;

        ModalDialog(Component parent, TableLoadDialog tld, final StarTableFactory tfact, final boolean multi) {
            super(parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent), tld.getName(), true);
            Action[] tacts;
            this.setDefaultCloseOperation(2);
            this.tableList_ = new ArrayList<StarTable>();
            final TableLoadClient client = new TableLoadClient(){

                @Override
                public StarTableFactory getTableFactory() {
                    return tfact;
                }

                @Override
                public void startSequence() {
                    tableList_.clear();
                }

                @Override
                public void setLabel(String label) {
                }

                @Override
                public boolean loadSuccess(StarTable table) {
                    tableList_.add(table);
                    return multi;
                }

                @Override
                public boolean loadFailure(Throwable error) {
                    error_ = error;
                    return false;
                }

                @Override
                public void endSequence(boolean cancelled) {
                    if (!cancelled) {
                        this.dispose();
                    }
                }
            };
            final TableLoadPanel tlp = new TableLoadPanel(tld, tfact){

                @Override
                protected TableLoadClient getLoadClient() {
                    return client;
                }
            };
            tlp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)tlp, "Center");
            this.getContentPane().add((Component)tlp.getProgressBar(), "South");
            JMenu[] menus = tld.getMenus();
            if (menus != null) {
                JMenuBar mbar = new JMenuBar();
                this.setJMenuBar(mbar);
                for (int im = 0; im < menus.length; ++im) {
                    mbar.add(menus[im]);
                }
            }
            if ((tacts = tld.getToolbarActions()) != null && tacts.length > 0) {
                JToolBar tbar = new JToolBar();
                this.getContentPane().add((Component)tbar, "North");
                for (int ia = 0; ia < tacts.length; ++ia) {
                    tbar.add(tacts[ia]);
                }
            }
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent evt) {
                    Action cancelAct = tlp.getCancelAction();
                    if (cancelAct.isEnabled()) {
                        cancelAct.actionPerformed(new ActionEvent(evt.getSource(), evt.getID(), "Close"));
                    }
                }
            });
        }

        public StarTable[] getTables() throws IOException {
            if (this.error_ == null) {
                return this.tableList_.toArray(new StarTable[0]);
            }
            throw (IOException)new IOException(this.error_.getMessage()).initCause(this.error_);
        }
    }
}

