/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import uk.ac.starlink.table.storage.ByteStoreAccess;
import uk.ac.starlink.table.storage.MultiNioAccess;
import uk.ac.starlink.table.storage.SingleNioAccess;

public abstract class NioByteStoreAccess
implements ByteStoreAccess {
    protected abstract ByteBuffer getBuffer(int var1) throws IOException;

    @Override
    public byte readByte() throws IOException {
        return this.getBuffer(1).get();
    }

    @Override
    public short readShort() throws IOException {
        return this.getBuffer(2).getShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.getBuffer(2).getChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.getBuffer(4).getInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.getBuffer(8).getLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.getBuffer(4).getFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.getBuffer(8).getDouble();
    }

    @Override
    public void readBytes(byte[] b, int offset, int length) throws IOException {
        this.getBuffer(length).get(b, offset, length);
    }

    public static ByteBuffer[] copyBuffers(ByteBuffer[] bufs) {
        int nbuf = bufs.length;
        ByteBuffer[] bufs1 = new ByteBuffer[nbuf];
        for (int i = 0; i < nbuf; ++i) {
            bufs1[i] = bufs[i].duplicate();
        }
        return bufs1;
    }

    public static ByteStoreAccess createAccess(ByteBuffer[] bbufs) {
        if (bbufs.length == 1) {
            return new SingleNioAccess(bbufs[0]);
        }
        return new MultiNioAccess(bbufs);
    }
}

