/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.gbin;

import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import uk.ac.starlink.gbin.GaiaTableMetadata;
import uk.ac.starlink.gbin.GbinMeta;
import uk.ac.starlink.gbin.GbinObjectReader;
import uk.ac.starlink.gbin.Proxies;

public class GbinMetadataReader {
    private static final ClassMap classMap_ = GbinMetadataReader.createClassMap();
    private static final MetadataReader mr_ = GbinMetadataReader.createMetadataReader();
    private static final Method nameChangeMethod_ = GbinMetadataReader.createNameChangeMethod();

    private GbinMetadataReader() {
    }

    public static GbinMeta attemptReadMetadata(Object gbinReaderObj) throws Throwable {
        Object metaObj = gbinReaderObj.getClass().getMethod("getGbinMetaData", new Class[0]).invoke(gbinReaderObj, new Object[0]);
        return Proxies.createReflectionProxy(GbinMeta.class, metaObj);
    }

    public static String getGaiaTableName(Class<?> objClazz) {
        Class<?> dmClazz = classMap_.getDefinition(objClazz);
        if (dmClazz != null && nameChangeMethod_ != null) {
            String dmClazzName = dmClazz.getSimpleName();
            try {
                return (String)nameChangeMethod_.invoke(null, dmClazzName);
            }
            catch (Throwable e) {
                GbinObjectReader.logError(Level.WARNING, "No gaia table name for class " + dmClazz, e);
                return null;
            }
        }
        return null;
    }

    public static String convertNameToArchiveFormat(String gbinName) {
        Object nameObj = null;
        if (nameChangeMethod_ != null) {
            try {
                nameObj = nameChangeMethod_.invoke(null, gbinName);
            }
            catch (Throwable e) {
                GbinObjectReader.logError(Level.INFO, "Can't convert gbin name " + gbinName, e);
            }
        }
        return nameObj instanceof String ? (String)nameObj : gbinName;
    }

    public static GaiaTableMetadata getTableMetadata(String gaiaTableName) {
        List<String> tnlist = mr_ == null ? null : mr_.getTableNameList();
        return tnlist != null && tnlist.indexOf(gaiaTableName) >= 0 ? new GaiaTableMetadataImpl(mr_, gaiaTableName) : null;
    }

    private static ClassMap createClassMap() {
        String clazzName = "gaia.cu1.tools.util.GaiaFactory";
        String methodName = "getClassMap";
        try {
            Object cmObj = Class.forName(clazzName).getMethod(methodName, new Class[0]).invoke(null, new Object[0]);
            return Proxies.createReflectionProxy(ClassMap.class, cmObj);
        }
        catch (Throwable e) {
            GbinObjectReader.logError(Level.WARNING, "Failed to invoke " + clazzName + "." + methodName + "()", e);
            return Proxies.createNullsProxy(ClassMap.class);
        }
    }

    private static MetadataReader createMetadataReader() {
        String clazzName = "gaia.cu9.tools.documentationexport.MetadataReader";
        String methodName = "getInstance";
        try {
            Object mrObj = Class.forName(clazzName).getMethod(methodName, new Class[0]).invoke(null, new Object[0]);
            return Proxies.createReflectionProxy(MetadataReader.class, mrObj);
        }
        catch (Throwable e) {
            GbinObjectReader.logError(Level.WARNING, "Failed to invoke " + clazzName + "." + methodName + "()", e);
            return Proxies.createNullsProxy(MetadataReader.class);
        }
    }

    private static Method createNameChangeMethod() {
        String clazzName = "gaia.cu9.tools.nameconventions.NameChanger";
        String methodName = "convertNameToArchiveFormat";
        try {
            return Class.forName(clazzName).getMethod(methodName, String.class);
        }
        catch (Throwable e) {
            GbinObjectReader.logError(Level.WARNING, "Failed to invoke " + clazzName + "." + methodName, e);
            return null;
        }
    }

    public static void main(String[] args) throws Throwable {
        FileInputStream in = new FileInputStream(args[0]);
        GbinObjectReader.initGaiaTools();
        Object gbinRdrObj = GbinObjectReader.createGbinReaderObject(in);
        GbinMeta meta = GbinMetadataReader.attemptReadMetadata(gbinRdrObj);
        System.out.println(meta);
    }

    private static class GaiaTableMetadataImpl
    implements GaiaTableMetadata {
        private final MetadataReader mr_;
        private final String tableName_;

        GaiaTableMetadataImpl(MetadataReader mr, String tableName) {
            this.mr_ = mr;
            this.tableName_ = tableName;
        }

        @Override
        public Map<String, String> getParametersWithTypes() {
            return this.mr_.getParametersWithTypes(this.tableName_);
        }

        @Override
        public String getTableDescription() {
            return this.mr_.getTableDescription(this.tableName_);
        }

        @Override
        public String getParameterDetailedDescription(String paramName) {
            return this.mr_.getParameterDetailedDescription(this.tableName_, paramName);
        }

        @Override
        public String getParameterDescription(String paramName) {
            return this.mr_.getParameterDescription(this.tableName_, paramName);
        }

        @Override
        public List<?> getUcds(String paramName) {
            return this.mr_.getUcds(this.tableName_, paramName);
        }
    }

    private static interface MetadataReader {
        public List<String> getTableNameList();

        public Map<String, String> getParametersWithTypes(String var1);

        public String getTableDescription(String var1);

        public String getParameterDetailedDescription(String var1, String var2);

        public String getParameterDescription(String var1, String var2);

        public List<?> getUcds(String var1, String var2);
    }

    private static interface ClassMap {
        public Class<?> getDefinition(Class<?> var1);

        public Class<?> getImplementation(Class<?> var1);
    }
}

