/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.starlink.hapi.HapiVersion;

public interface HapiCatalog {
    public HapiVersion getHapiVersion();

    public String[] getDatasetIds();

    public static HapiCatalog fromJson(JSONObject json) {
        final HapiVersion version = HapiVersion.fromText(json.optString("HAPI", null));
        JSONArray catalog = json.optJSONArray("catalog");
        int nel = catalog.length();
        ArrayList<String> datasets = new ArrayList<String>();
        for (int i = 0; i < nel; ++i) {
            String id;
            JSONObject dsObj = catalog.optJSONObject(i);
            if (dsObj == null || (id = dsObj.optString("id")) == null) continue;
            datasets.add(id);
        }
        final String[] dsids = datasets.toArray(new String[0]);
        return new HapiCatalog(){

            @Override
            public HapiVersion getHapiVersion() {
                return version;
            }

            @Override
            public String[] getDatasetIds() {
                return dsids;
            }
        };
    }
}

