/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.hapi.HapiParam;
import uk.ac.starlink.hapi.HapiService;
import uk.ac.starlink.hapi.HapiTableBuilder;
import uk.ac.starlink.hapi.HapiTableReader;
import uk.ac.starlink.hapi.HapiVersion;
import uk.ac.starlink.hapi.Times;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.util.IOConsumer;
import uk.ac.starlink.util.URLUtils;

public class HapiSource {
    private final HapiService service_;
    private final URL dataUrl_;
    private final HapiParam[] params_;
    private final String urlTxt_;
    private final String format_;
    private final URL standaloneUrl_;
    private final String label_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.hapi");

    public HapiSource(HapiService service, URL dataUrl, HapiParam[] params) {
        this.service_ = service;
        this.dataUrl_ = dataUrl;
        this.params_ = params;
        this.urlTxt_ = dataUrl.toString();
        Map<String, String> reqParams = HapiService.getRequestParameters(dataUrl);
        String string = this.format_ = reqParams.containsKey("format") ? reqParams.get("format") : "csv";
        if (reqParams.containsKey("include")) {
            logger_.warning("URL should not include 'include' param: " + dataUrl);
        }
        try {
            this.standaloneUrl_ = URLUtils.newURL(dataUrl + "&include=header");
        }
        catch (MalformedURLException e) {
            throw new AssertionError();
        }
        String dataset = null;
        String start = null;
        String stop = null;
        for (HapiVersion version : HapiVersion.getStandardVersions()) {
            if (dataset == null) {
                dataset = reqParams.get(version.getDatasetRequestParam());
            }
            if (start == null) {
                start = reqParams.get(version.getStartRequestParam());
            }
            if (stop != null) continue;
            stop = reqParams.get(version.getStopRequestParam());
        }
        this.label_ = (dataset == null ? "HAPI" : dataset) + "-" + HapiSource.getTimeRangeText(start, stop);
    }

    public URL getStandaloneUrl() {
        return this.standaloneUrl_;
    }

    public String getLabel() {
        return this.label_;
    }

    public void streamHapi(TableSink sink, int chunkLimit, IOConsumer<String> limitCallback) throws IOException {
        if (this.params_ == null) {
            try (InputStream in = this.service_.openChunkedStream(this.standaloneUrl_, chunkLimit, limitCallback);){
                new HapiTableBuilder().streamStarTable(in, sink, null);
            }
        }
        HapiTableReader rdr = new HapiTableReader(this.params_);
        StarTable meta = rdr.createStarTable(null);
        try (InputStream in = this.service_.openChunkedStream(this.dataUrl_, chunkLimit, limitCallback);){
            sink.acceptMetadata(meta);
            RowSequence rseq = rdr.createRowSequence(in, null, this.format_);
            while (rseq.next()) {
                sink.acceptRow(rseq.getRow());
            }
            sink.endRows();
        }
    }

    public int hashCode() {
        int code = 220139;
        code = 23 * code + this.urlTxt_.hashCode();
        code = 23 * code + this.service_.hashCode();
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof HapiSource) {
            HapiSource other = (HapiSource)o;
            return this.service_.equals(other.service_) && this.urlTxt_.equals(other.urlTxt_);
        }
        return false;
    }

    private static String getTimeRangeText(String isoStart, String isoStop) {
        String format;
        String unit;
        int leng;
        double startSec = Times.isoToUnixSeconds(isoStart);
        double stopSec = Times.isoToUnixSeconds(isoStop);
        double sec = stopSec - startSec;
        if (Double.isNaN(sec)) {
            return isoStart;
        }
        if (sec < 60.0) {
            leng = (int)Math.round(sec);
            unit = "s";
            format = "yyyy-MM-dd'T'HH:mm:ss";
        } else if (sec < 3600.0) {
            leng = (int)Math.round(sec / 60.0);
            unit = "m";
            format = "yyyy-MM-dd'T'HH:mm";
        } else if (sec < 86400.0) {
            leng = (int)Math.round(sec / 3600.0);
            unit = "h";
            format = "yyyy-MM-dd'T'HH";
        } else if (sec < 8640000.0) {
            leng = (int)Math.round(sec / 3600.0 / 24.0);
            unit = "d";
            format = "yyyy-MM-dd";
        } else if (sec < 6.3072E7) {
            leng = (int)Math.round(sec / 3600.0 / 24.0 / 30.0);
            unit = "M";
            format = "yyyy-MM";
        } else {
            leng = (int)Math.round(sec / 3600.0 / 24.0 / 365.0);
            unit = "y";
            format = "yyyy";
        }
        return Times.formatUnixSeconds((long)startSec, format) + "+" + leng + unit;
    }
}

