/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import uk.ac.starlink.hapi.Times;

public class SlideDateRanger
extends JPanel {
    private final JSlider durationSlider_;
    private final JSlider epochSlider_ = new JSlider();
    private final boolean smooth_;
    private Scaler durationScaler_;
    private Scaler epochScaler_;
    private long minSec_;
    private long maxSec_;
    private long[] range_;
    public static final String PROP_RANGE = "range";

    public SlideDateRanger() {
        super(new BorderLayout());
        this.durationSlider_ = new JSlider();
        this.smooth_ = false;
        Box sbox = Box.createHorizontalBox();
        sbox.add(this.epochSlider_);
        sbox.add(Box.createHorizontalStrut(10));
        sbox.add(this.durationSlider_);
        this.add((Component)sbox, "North");
        this.setLimits(0L, 0L);
        for (JSlider slider : new JSlider[]{this.epochSlider_, this.durationSlider_}) {
            slider.setPaintLabels(true);
            slider.setPaintTicks(false);
            slider.addChangeListener(evt -> this.updateRange());
        }
    }

    public void setLimits(long minSec, long maxSec) {
        if (minSec >= maxSec) {
            minSec = 0L;
            maxSec = System.currentTimeMillis() / 1000L;
        }
        this.minSec_ = minSec;
        this.maxSec_ = maxSec;
        this.epochScaler_ = SlideDateRanger.createEpochScaler(minSec, maxSec);
        this.epochScaler_.configureSlider(this.epochSlider_);
        this.durationScaler_ = SlideDateRanger.createDurationScaler(maxSec - minSec);
        this.durationScaler_.configureSlider(this.durationSlider_);
        this.durationSlider_.setValue(this.durationScaler_.secondsToScale(3600L));
    }

    public long[] getRange() {
        long stopSec;
        long startSec;
        int durationValue = this.durationSlider_.getValue();
        int epochValue = this.epochSlider_.getValue();
        int epochMin = this.epochSlider_.getMinimum();
        int epochMax = this.epochSlider_.getMaximum();
        long durationSec = this.durationScaler_.scaleToSeconds(durationValue);
        long epochSec = this.epochScaler_.scaleToSeconds(epochValue);
        if (this.smooth_) {
            double epochFrac = 1.0 * (double)(epochValue - epochMin) / (double)(epochMax - epochMin);
            startSec = epochSec - (long)(epochFrac * (double)durationSec);
            stopSec = epochSec + (long)((1.0 - epochFrac) * (double)durationSec);
        } else if (epochSec + durationSec <= this.maxSec_) {
            startSec = epochSec;
            stopSec = epochSec + durationSec;
        } else {
            stopSec = this.maxSec_;
            startSec = stopSec - durationSec;
        }
        return new long[]{Math.max(this.minSec_, startSec), Math.min(this.maxSec_, stopSec)};
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.durationSlider_.setEnabled(isEnabled);
        this.epochSlider_.setEnabled(isEnabled);
    }

    private void updateRange() {
        long[] oldRange = this.range_;
        long[] newRange = this.getRange();
        if (!Arrays.equals(oldRange, newRange)) {
            this.range_ = newRange;
            this.firePropertyChange(PROP_RANGE, oldRange, newRange);
        }
    }

    private static Scaler createEpochScaler(long minSec, long maxSec) {
        Scaler scaler = new Scaler(minSec, maxSec){

            @Override
            public long scaleToSeconds(int scale) {
                return (long)scale * 1000L;
            }

            @Override
            public int secondsToScale(long sec) {
                return (int)(sec / 1000L);
            }
        };
        int minYear = Times.secToYear(minSec);
        int maxYear = Times.secToYear(maxSec);
        int ystep = Math.max(1, (maxYear - minYear) / 4);
        for (int iy = minYear; iy <= maxYear; ++iy) {
            long sec;
            if (iy % ystep != 0 || (sec = Times.yearToSec(iy)) < minSec || sec > maxSec) continue;
            scaler.addTick(sec, Integer.toString(iy));
        }
        if (scaler.labelTable_.isEmpty()) {
            assert (minYear == maxYear);
            scaler.addTick((maxSec + minSec) / 2L, Integer.toString(minYear));
        }
        return scaler;
    }

    private static Scaler createDurationScaler(long maxDuration) {
        Scaler scaler = new Scaler(1L, maxDuration){

            @Override
            public long scaleToSeconds(int scale) {
                return (long)Math.pow(10.0, 0.01 * (double)scale);
            }

            @Override
            public int secondsToScale(long seconds) {
                return (int)(Math.log10(seconds) * 100.0);
            }
        };
        scaler.addTick(1L, "1sec");
        scaler.addTick(60L, "1min");
        scaler.addTick(3600L, "1hr");
        scaler.addTick(86400L, "1day");
        scaler.addTick(2628000L, "1m");
        scaler.addTick(31557600L, "1yr");
        return scaler;
    }

    private static abstract class Scaler {
        final long secMin_;
        final long secMax_;
        final Hashtable<Integer, JComponent> labelTable_;

        Scaler(long secMin, long secMax) {
            this.secMin_ = secMin;
            this.secMax_ = secMax;
            this.labelTable_ = new Hashtable();
        }

        abstract int secondsToScale(long var1);

        abstract long scaleToSeconds(int var1);

        void addTick(long seconds, String text) {
            this.labelTable_.put(this.secondsToScale(seconds), new JLabel(text));
        }

        void configureSlider(JSlider slider) {
            slider.setMinimum(this.secondsToScale(this.secMin_));
            slider.setMaximum(this.secondsToScale(this.secMax_));
            slider.setLabelTable(this.labelTable_);
        }
    }
}

