/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import uk.ac.starlink.fits.BasicInput;

public class BufferedRandomInput
implements BasicInput {
    private final RandomAccessFile file_;
    private final long offset0_;
    private final byte[] array_;
    private final int bufsize_;
    private final ByteBuffer buf_;
    private final long filesize_;
    private long bufOffset_;
    public static final int DFLT_BUFSIZE = BufferedRandomInput.getDefaultBufferSize();

    public BufferedRandomInput(RandomAccessFile file, long offset0) throws IOException {
        this(file, offset0, DFLT_BUFSIZE);
    }

    public BufferedRandomInput(RandomAccessFile file, long offset0, int bufsize) throws IOException {
        this.file_ = file;
        this.offset0_ = offset0;
        this.bufsize_ = bufsize;
        this.filesize_ = file.length();
        this.array_ = new byte[bufsize];
        this.buf_ = ByteBuffer.wrap(this.array_);
        this.buf_.clear();
        this.bufOffset_ = this.offset0_;
        this.buf_.limit(0);
        assert (this.getOffset() == 0L);
        assert (this.buf_.remaining() == 0);
    }

    @Override
    public byte readByte() throws IOException {
        return this.getAssuredBuffer(1).get();
    }

    @Override
    public short readShort() throws IOException {
        return this.getAssuredBuffer(2).getShort();
    }

    @Override
    public int readInt() throws IOException {
        return this.getAssuredBuffer(4).getInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.getAssuredBuffer(8).getLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.getAssuredBuffer(4).getFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.getAssuredBuffer(8).getDouble();
    }

    @Override
    public void readBytes(byte[] bbuf) throws IOException {
        this.getAssuredBuffer(bbuf.length).get(bbuf);
    }

    @Override
    public boolean isRandom() {
        return true;
    }

    @Override
    public void skip(long nbytes) throws IOException {
        this.seek(this.getOffset() + nbytes);
    }

    @Override
    public long getOffset() {
        return this.bufOffset_ + (long)this.buf_.position() - this.offset0_;
    }

    @Override
    public void seek(long offset) throws IOException {
        if (offset < 0L) {
            throw new IOException("Negative seek " + offset);
        }
        if (offset > this.filesize_ - this.offset0_) {
            throw new EOFException("Seek out of range " + offset);
        }
        long bpos = offset - this.bufOffset_ + this.offset0_;
        if (bpos >= 0L && bpos <= (long)this.buf_.limit()) {
            this.buf_.position((int)bpos);
        } else {
            this.bufOffset_ = offset + this.offset0_;
            this.buf_.limit(0);
        }
        assert (offset == this.getOffset());
    }

    @Override
    public void close() throws IOException {
        this.file_.close();
    }

    private ByteBuffer getAssuredBuffer(int nbyte) throws IOException {
        int c;
        int nb;
        if (this.buf_.remaining() >= nbyte) {
            return this.buf_;
        }
        long bufoff = this.bufOffset_ + (long)this.buf_.position();
        this.file_.seek(bufoff);
        for (c = 0; c < nbyte; c += nb) {
            nb = this.file_.read(this.array_, c, this.bufsize_ - c);
            if (nb >= 0) continue;
            throw new EOFException();
        }
        this.bufOffset_ = bufoff;
        this.buf_.position(0);
        this.buf_.limit(c);
        return this.buf_;
    }

    private static int getDefaultBufferSize() {
        final int[] sizer = new int[1];
        new BufferedInputStream((InputStream)new ByteArrayInputStream(new byte[0])){
            {
                super(x0);
                sizer[0] = this.buf.length;
            }
        };
        return sizer[0];
    }
}

