/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.nio.charset.StandardCharsets;
import uk.ac.starlink.fits.FitsUtil;

public class CardImage {
    private final byte[] buf80_;

    public CardImage(byte[] buf80) {
        if (buf80.length != 80) {
            String txt = new String(buf80, StandardCharsets.US_ASCII);
            throw new IllegalArgumentException("Buffer wrong length (" + buf80.length + " != 80): " + txt);
        }
        for (int i = 0; i < 80; ++i) {
            CardImage.checkFitsCharacter(buf80[i] & 0xFF);
        }
        this.buf80_ = buf80;
    }

    public CardImage(CharSequence txt80) {
        this(CardImage.toByteArray(txt80));
    }

    public byte[] getBytes() {
        return this.buf80_;
    }

    public String toString() {
        return new String(this.buf80_, StandardCharsets.US_ASCII);
    }

    private static byte[] toByteArray(CharSequence txt) {
        int n = txt.length();
        byte[] buf = new byte[n];
        for (int i = 0; i < n; ++i) {
            char ch = txt.charAt(i);
            CardImage.checkFitsCharacter(ch);
            buf[i] = (byte)ch;
        }
        return buf;
    }

    private static void checkFitsCharacter(int ch) {
        if (!FitsUtil.isFitsCharacter(ch)) {
            throw new IllegalArgumentException("Bad character: 0x" + Integer.toHexString(ch));
        }
    }
}

