/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.function.LongSupplier;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowData;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;

public abstract class CalcStarTable<C>
extends AbstractStarTable {
    private final StarTable base_;
    private final Col<C, ?>[] columns_;
    private RowCalculation<C> rowCalc_;

    public CalcStarTable(StarTable base, Col<C, ?>[] columns) {
        this.base_ = base;
        this.columns_ = columns;
    }

    public abstract C createCalculation(RowData var1) throws IOException;

    public abstract C createCalculation(long var1) throws IOException;

    public StarTable getBaseTable() {
        return this.base_;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.columns_[icol].getInfo();
    }

    @Override
    public int getColumnCount() {
        return this.columns_.length;
    }

    @Override
    public long getRowCount() {
        return this.base_.getRowCount();
    }

    @Override
    public boolean isRandom() {
        return this.base_.isRandom();
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        final RowSequence baseSeq = this.base_.getRowSequence();
        return new RowSequence(){
            private C calc_;

            @Override
            public boolean next() throws IOException {
                this.calc_ = null;
                return baseSeq.next();
            }

            @Override
            public Object getCell(int icol) throws IOException {
                return CalcStarTable.this.getCalculatedCell(this.getCalculation(), icol);
            }

            @Override
            public Object[] getRow() throws IOException {
                return CalcStarTable.this.getCalculatedRow(this.getCalculation());
            }

            @Override
            public void close() throws IOException {
                baseSeq.close();
            }

            private C getCalculation() throws IOException {
                if (this.calc_ == null) {
                    this.calc_ = CalcStarTable.this.createCalculation(baseSeq);
                }
                return this.calc_;
            }
        };
    }

    @Override
    public RowSplittable getRowSplittable() throws IOException {
        return new CalcRowSplittable(this.base_.getRowSplittable());
    }

    @Override
    public RowAccess getRowAccess() throws IOException {
        final RowAccess baseAcc = this.base_.getRowAccess();
        return new RowAccess(){
            private C calc_;
            private long irow_ = -1L;

            @Override
            public void setRowIndex(long irow) throws IOException {
                if (irow != this.irow_) {
                    this.irow_ = irow;
                    this.calc_ = null;
                    baseAcc.setRowIndex(irow);
                }
            }

            @Override
            public Object getCell(int icol) throws IOException {
                return CalcStarTable.this.getCalculatedCell(this.getCalculation(), icol);
            }

            @Override
            public Object[] getRow() throws IOException {
                return CalcStarTable.this.getCalculatedRow(this.getCalculation());
            }

            @Override
            public void close() throws IOException {
                baseAcc.close();
            }

            private C getCalculation() throws IOException {
                if (this.calc_ == null) {
                    this.calc_ = CalcStarTable.this.createCalculation(baseAcc);
                }
                return this.calc_;
            }
        };
    }

    @Override
    public Object[] getRow(long irow) throws IOException {
        return this.getCalculatedRow(this.getCalculation(irow));
    }

    @Override
    public Object getCell(long irow, int icol) throws IOException {
        return this.getCalculatedCell(this.getCalculation(irow), icol);
    }

    private C getCalculation(long irow) throws IOException {
        RowCalculation<C> rowCalc = this.rowCalc_;
        if (rowCalc != null && rowCalc.irow_ == irow) {
            return rowCalc.calc_;
        }
        C calc = this.createCalculation(irow);
        this.rowCalc_ = new RowCalculation<C>(irow, calc);
        return calc;
    }

    private Object getCalculatedCell(C calculation, int icol) {
        return this.columns_[icol].getValue(calculation);
    }

    private Object[] getCalculatedRow(C calculation) {
        int nc = this.columns_.length;
        Object[] row = new Object[nc];
        for (int ic = 0; ic < nc; ++ic) {
            row[ic] = this.columns_[ic].getValue(calculation);
        }
        return row;
    }

    private static class RowCalculation<C> {
        final long irow_;
        final C calc_;

        RowCalculation(long irow, C calc) {
            this.irow_ = irow;
            this.calc_ = calc;
        }
    }

    public static interface Col<C, T> {
        public ColumnInfo getInfo();

        public T getValue(C var1);
    }

    private class CalcRowSplittable
    extends WrapperRowSequence
    implements RowSplittable {
        private C calc_;
        private final RowSplittable baseSplit_;

        CalcRowSplittable(RowSplittable base) {
            super(base);
            this.baseSplit_ = base;
        }

        @Override
        public long splittableSize() {
            return this.baseSplit_.splittableSize();
        }

        @Override
        public LongSupplier rowIndex() {
            return this.baseSplit_.rowIndex();
        }

        @Override
        public boolean next() throws IOException {
            this.calc_ = null;
            return this.baseSplit_.next();
        }

        @Override
        public Object getCell(int icol) throws IOException {
            return CalcStarTable.this.getCalculatedCell(this.getCalculation(), icol);
        }

        @Override
        public Object[] getRow() throws IOException {
            return CalcStarTable.this.getCalculatedRow(this.getCalculation());
        }

        @Override
        public CalcRowSplittable split() {
            RowSplittable spl = (RowSplittable)this.baseSplit_.split();
            return spl == null ? null : new CalcRowSplittable(spl);
        }

        private C getCalculation() throws IOException {
            if (this.calc_ == null) {
                this.calc_ = CalcStarTable.this.createCalculation(this.baseSplit_);
            }
            return this.calc_;
        }
    }
}

