/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.MappingRowSplittable;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowData;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.WrapperRowAccess;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public class ExplodedStarTable
extends WrapperStarTable {
    private final StarTable baseTable_;
    private final ColPointer[] pointers_;

    public ExplodedStarTable(StarTable baseTable, boolean[] colFlags) {
        super(baseTable);
        this.baseTable_ = baseTable;
        ArrayList<ColPointer> colList = new ArrayList<ColPointer>();
        for (int icol = 0; icol < baseTable.getColumnCount(); ++icol) {
            if (colFlags[icol]) {
                String[] labels;
                ColumnInfo baseInfo = baseTable.getColumnInfo(icol);
                String[] stringArray = labels = baseInfo.isArray() ? Tables.getElementLabels(baseInfo.getShape()) : null;
                if (labels != null) {
                    for (int j = 0; j < labels.length; ++j) {
                        colList.add(new ColPointer(icol, j, labels[j]));
                    }
                    continue;
                }
                throw new IllegalArgumentException("Column cannot be exploded, not fixed-length array: " + baseInfo);
            }
            colList.add(new ColPointer(icol));
        }
        this.pointers_ = colList.toArray(new ColPointer[0]);
    }

    public ExplodedStarTable(StarTable baseTable) {
        this(baseTable, ExplodedStarTable.findExplodableColumns(baseTable));
    }

    @Override
    public int getColumnCount() {
        return this.pointers_.length;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        ColPointer pointer = this.pointers_[icol];
        ColumnInfo baseInfo = this.baseTable_.getColumnInfo(pointer.getBaseIndex());
        if (pointer.getSubIndex() < 0) {
            return baseInfo;
        }
        int subIndex = pointer.getSubIndex();
        int subIndex1 = subIndex + 1;
        ColumnInfo info = new ColumnInfo(baseInfo);
        info.setContentClass(ExplodedStarTable.getComponentType(info.getContentClass()));
        info.setName(info.getName() + pointer.getLabel());
        String desc = info.getDescription();
        desc = desc == null || desc.length() == 0 ? baseInfo.getName() + " element #" + subIndex1 : desc + " (element #" + subIndex1 + ")";
        info.setDescription(desc);
        return info;
    }

    @Override
    public Object getCell(long irow, int icol) throws IOException {
        ColPointer pointer = this.pointers_[icol];
        Object baseCell = this.baseTable.getCell(irow, pointer.getBaseIndex());
        return this.translateCell(pointer, baseCell);
    }

    @Override
    public Object[] getRow(long irow) throws IOException {
        return this.translateRow(this.baseTable.getRow(irow));
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        RowSequence baseSeq = this.baseTable.getRowSequence();
        return new WrapperRowSequence(baseSeq, this.explodeMapper(baseSeq));
    }

    @Override
    public RowAccess getRowAccess() throws IOException {
        RowAccess baseAcc = this.baseTable.getRowAccess();
        return new WrapperRowAccess(baseAcc, this.explodeMapper(baseAcc));
    }

    @Override
    public RowSplittable getRowSplittable() throws IOException {
        RowSplittable baseSplit = this.baseTable.getRowSplittable();
        return new MappingRowSplittable(baseSplit, this::explodeMapper);
    }

    private RowData explodeMapper(final RowData baseData) {
        return new RowData(){

            @Override
            public Object getCell(int icol) throws IOException {
                ColPointer pointer = ExplodedStarTable.this.pointers_[icol];
                Object baseCell = baseData.getCell(pointer.getBaseIndex());
                return ExplodedStarTable.this.translateCell(pointer, baseCell);
            }

            @Override
            public Object[] getRow() throws IOException {
                return ExplodedStarTable.this.translateRow(baseData.getRow());
            }
        };
    }

    private Object translateCell(ColPointer pointer, Object baseCell) {
        if (pointer.getSubIndex() < 0 || baseCell == null || !baseCell.getClass().isArray()) {
            return baseCell;
        }
        return Array.get(baseCell, pointer.getSubIndex());
    }

    private Object[] translateRow(Object[] baseRow) {
        int ncol = this.pointers_.length;
        Object[] row = new Object[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            ColPointer pointer = this.pointers_[icol];
            Object baseCell = baseRow[pointer.getBaseIndex()];
            row[icol] = this.translateCell(pointer, baseCell);
        }
        return row;
    }

    private static Class<?> getComponentType(Class<?> aclazz) {
        Class<?> clazz = aclazz.getComponentType();
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        return clazz;
    }

    private static boolean[] findExplodableColumns(StarTable table) {
        int ncol = table.getColumnCount();
        boolean[] colFlags = new boolean[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnInfo info = table.getColumnInfo(icol);
            colFlags[icol] = info.isArray() && Tables.getElementLabels(info.getShape()) != null;
        }
        return colFlags;
    }

    private static class ColPointer {
        final int baseIndex_;
        final int subIndex_;
        final String label_;

        public ColPointer(int baseIndex, int subIndex, String label) {
            this.baseIndex_ = baseIndex;
            this.subIndex_ = subIndex;
            this.label_ = label;
        }

        public ColPointer(int baseIndex) {
            this(baseIndex, -1, null);
        }

        public int getBaseIndex() {
            return this.baseIndex_;
        }

        public int getSubIndex() {
            return this.subIndex_;
        }

        public String getLabel() {
            return this.label_;
        }
    }
}

