/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;

public class JoinStarTable
extends AbstractStarTable {
    private final StarTable[] tables_;
    private final StarTable[] tablesByColumn_;
    private final int[] indicesByColumn_;
    private final int[] nCols_;
    private final int nTab_;
    private final int nCol_;
    private final boolean isRandom_;
    private final ColumnInfo[] colInfos_;
    private final List<ValueInfo> auxData_;

    public JoinStarTable(StarTable[] tables, JoinFixAction[] fixCols) {
        int ic;
        int itab;
        this.nTab_ = tables.length;
        this.tables_ = (StarTable[])tables.clone();
        if (fixCols == null) {
            fixCols = new JoinFixAction[this.nTab_];
            Arrays.fill(fixCols, JoinFixAction.NO_ACTION);
        }
        if (fixCols.length != this.nTab_) {
            throw new IllegalArgumentException("Incompatible length of array arguments");
        }
        int nc = 0;
        this.nCols_ = new int[this.nTab_];
        for (int itab2 = 0; itab2 < this.nTab_; ++itab2) {
            this.nCols_[itab2] = tables[itab2].getColumnCount();
            nc += this.nCols_[itab2];
        }
        this.nCol_ = nc;
        this.tablesByColumn_ = new StarTable[this.nCol_];
        this.indicesByColumn_ = new int[this.nCol_];
        int icol = 0;
        for (int itab3 = 0; itab3 < this.nTab_; ++itab3) {
            int ic2 = 0;
            while (ic2 < this.nCols_[itab3]) {
                this.tablesByColumn_[icol] = tables[itab3];
                this.indicesByColumn_[icol] = ic2++;
                ++icol;
            }
        }
        assert (icol == this.nCol_);
        this.colInfos_ = new ColumnInfo[this.nCol_];
        ArrayList<String> nameList = new ArrayList<String>();
        icol = 0;
        for (itab = 0; itab < this.nTab_; ++itab) {
            for (ic = 0; ic < this.nCols_[itab]; ++ic) {
                this.colInfos_[icol] = new ColumnInfo(tables[itab].getColumnInfo(ic));
                nameList.add(this.colInfos_[icol].getName());
                ++icol;
            }
        }
        assert (icol == this.nCol_);
        icol = 0;
        for (itab = 0; itab < this.nTab_; ++itab) {
            for (ic = 0; ic < this.nCols_[itab]; ++ic) {
                String origName = (String)nameList.remove(icol);
                assert (origName.equals(this.colInfos_[icol].getName()));
                String name = fixCols[itab].getFixedName(origName, nameList);
                nameList.add(icol, origName);
                nameList.add(name);
                this.colInfos_[icol].setName(name);
                ++icol;
            }
        }
        assert (icol == this.nCol_);
        LinkedHashSet<ValueInfo> auxInfos = new LinkedHashSet<ValueInfo>();
        for (StarTable table : tables) {
            auxInfos.addAll(table.getColumnAuxDataInfos());
        }
        this.auxData_ = new ArrayList<ValueInfo>(auxInfos);
        LinkedHashSet<DescribedValue> params = new LinkedHashSet<DescribedValue>();
        for (StarTable table : tables) {
            params.addAll(table.getParameters());
        }
        this.setParameters(new ArrayList<DescribedValue>(params));
        boolean rand = true;
        for (StarTable table : tables) {
            rand = rand && table.isRandom();
        }
        this.isRandom_ = rand;
    }

    public JoinStarTable(StarTable[] tables) {
        this(tables, null);
    }

    public List<StarTable> getTables() {
        return Collections.unmodifiableList(Arrays.asList(this.tables_));
    }

    @Override
    public int getColumnCount() {
        return this.nCol_;
    }

    @Override
    public long getRowCount() {
        if (this.nTab_ == 0) {
            return 0L;
        }
        long nrow = Long.MAX_VALUE;
        for (StarTable table : this.tables_) {
            nrow = Math.min(nrow, table.getRowCount());
        }
        return nrow;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos_[icol];
    }

    @Override
    public boolean isRandom() {
        return this.isRandom_;
    }

    @Override
    public Object getCell(long irow, int icol) throws IOException {
        if (!this.isRandom()) {
            throw new UnsupportedOperationException("No random access");
        }
        return this.tablesByColumn_[icol].getCell(irow, this.indicesByColumn_[icol]);
    }

    @Override
    public Object[] getRow(long irow) throws IOException {
        if (!this.isRandom()) {
            throw new UnsupportedOperationException("No random access");
        }
        Object[] row = new Object[this.nCol_];
        int icol = 0;
        for (int itab = 0; itab < this.nTab_; ++itab) {
            Object[] subrow = this.tables_[itab].getRow(irow);
            System.arraycopy(subrow, 0, row, icol, this.nCols_[itab]);
            icol += this.nCols_[itab];
        }
        assert (icol == this.nCol_);
        return row;
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        return new JoinRowSequence();
    }

    @Override
    public RowAccess getRowAccess() throws IOException {
        return new JoinRowAccess();
    }

    @Override
    public void close() throws IOException {
        for (StarTable table : this.tables_) {
            table.close();
        }
    }

    private class JoinRowAccess
    implements RowAccess {
        final RowAccess[] raccs_;
        final RowAccess[] raccsByColumn_;
        final Object[] row_;
        long irow_;

        JoinRowAccess() throws IOException {
            this.row_ = new Object[JoinStarTable.this.nCol_];
            this.raccs_ = new RowAccess[JoinStarTable.this.nTab_];
            this.raccsByColumn_ = new RowAccess[JoinStarTable.this.nCol_];
            int icol = 0;
            for (int itab = 0; itab < JoinStarTable.this.nTab_; ++itab) {
                this.raccs_[itab] = JoinStarTable.this.tables_[itab].getRowAccess();
                for (int ic = 0; ic < JoinStarTable.this.nCols_[itab]; ++ic) {
                    this.raccsByColumn_[icol] = this.raccs_[itab];
                    assert (JoinStarTable.this.indicesByColumn_[icol] == ic);
                    ++icol;
                }
            }
            assert (icol == JoinStarTable.this.nCol_);
        }

        @Override
        public void setRowIndex(long irow) throws IOException {
            for (int itab = 0; itab < JoinStarTable.this.nTab_; ++itab) {
                this.raccs_[itab].setRowIndex(irow);
            }
        }

        @Override
        public Object getCell(int icol) throws IOException {
            return this.raccsByColumn_[icol].getCell(JoinStarTable.this.indicesByColumn_[icol]);
        }

        @Override
        public Object[] getRow() throws IOException {
            int icol = 0;
            for (int itab = 0; itab < JoinStarTable.this.nTab_; ++itab) {
                Object[] subrow = this.raccs_[itab].getRow();
                System.arraycopy(subrow, 0, this.row_, icol, JoinStarTable.this.nCols_[itab]);
                icol += JoinStarTable.this.nCols_[itab];
            }
            assert (icol == JoinStarTable.this.nCol_);
            return this.row_;
        }

        @Override
        public void close() throws IOException {
            for (RowAccess racc : this.raccs_) {
                try {
                    racc.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private class JoinRowSequence
    implements RowSequence {
        final RowSequence[] rseqs_;
        final RowSequence[] rseqsByColumn_;

        JoinRowSequence() throws IOException {
            this.rseqs_ = new RowSequence[JoinStarTable.this.nTab_];
            this.rseqsByColumn_ = new RowSequence[JoinStarTable.this.nCol_];
            int icol = 0;
            for (int itab = 0; itab < JoinStarTable.this.nTab_; ++itab) {
                this.rseqs_[itab] = JoinStarTable.this.tables_[itab].getRowSequence();
                for (int ic = 0; ic < JoinStarTable.this.nCols_[itab]; ++ic) {
                    this.rseqsByColumn_[icol] = this.rseqs_[itab];
                    assert (JoinStarTable.this.indicesByColumn_[icol] == ic);
                    ++icol;
                }
            }
            assert (icol == JoinStarTable.this.nCol_);
        }

        @Override
        public boolean next() throws IOException {
            for (RowSequence rseq : this.rseqs_) {
                if (rseq.next()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Object getCell(int icol) throws IOException {
            return this.rseqsByColumn_[icol].getCell(JoinStarTable.this.indicesByColumn_[icol]);
        }

        @Override
        public Object[] getRow() throws IOException {
            Object[] row = new Object[JoinStarTable.this.nCol_];
            int icol = 0;
            for (int itab = 0; itab < JoinStarTable.this.nTab_; ++itab) {
                Object[] subrow = this.rseqs_[itab].getRow();
                System.arraycopy(subrow, 0, row, icol, JoinStarTable.this.nCols_[itab]);
                icol += JoinStarTable.this.nCols_[itab];
            }
            assert (icol == JoinStarTable.this.nCol_);
            return row;
        }

        @Override
        public void close() throws IOException {
            for (RowSequence rseq : this.rseqs_) {
                rseq.close();
            }
        }
    }
}

