/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.Documented;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableScheme;
import uk.ac.starlink.table.Tables;

public class TestTableScheme
implements TableScheme,
Documented {
    private static final int DFLT_NROW = 10;
    private static final Map<Character, ContentOpt> OPTS = TestTableScheme.createOpts();
    private static final String OPT_CHRS = OPTS.keySet().stream().map(Object::toString).collect(Collectors.joining());
    private static final int ZP = 10;

    @Override
    public String getSchemeName() {
        return "test";
    }

    @Override
    public String getSchemeUsage() {
        return "[<nrow>[,<opts-" + OPT_CHRS + "*>]]";
    }

    @Override
    public String getExampleSpecification() {
        return "10,is";
    }

    @Override
    public String getXmlDescription() {
        return String.join((CharSequence)"\n", "<p>Generates a table containing test data.", "The idea is to include columns of different data types,", "for instance to provide an example for testing", "I/O handler implementations.", "The columns will contain some variety of more or less meaningless", "values, but the content is reproducible between runs,", "so the same specification will produce the same output each time.", "Updates of the implementation might change the output however,", "so the output is not guaranteed to be the same for all time.", "</p>", "<p>The table specification has two comma-separated parameters:", "<ul>", "<li><code>&lt;nrow&gt;</code>: row count</li>", "<li><code>&lt;opts&gt;</code>:", "a string of letter options specifying what types of data", "will be included; options are:", "<ul>", OPTS.values().stream().map(opt -> new StringBuffer().append("<li><strong>").append(opt.idChr_).append("</strong>: ").append(opt.description_).append("</li>\n").toString()).collect(Collectors.joining("\n")), "<li><strong>*</strong>: equivalent to all of the above</li>", "</ul>", "</li>", "</ul>", "If <code>&lt;opts&gt;</code> and/or <code>&lt;nrow&gt;</code>", "are omitted, some default values are used.", "</p>", "<p>The <code>&lt;nrow&gt;</code> argument", " may be given as a plain integer (<code>1000</code>),\nor with embedded underscores (<code>1_000</code>),\nor in exponential format (<code>1e3</code>).", "</p>", "");
    }

    @Override
    public StarTable createTable(String spec) throws TableFormatException {
        long nrow;
        String[] args = spec.split(",", -1);
        if (args.length > 2) {
            throw new TableFormatException("Too many args");
        }
        try {
            nrow = args.length > 0 && args[0].trim().length() > 0 ? Tables.parseCount(args[0]) : 10L;
        }
        catch (NumberFormatException e) {
            throw new TableFormatException("Bad row count \"" + args[0] + "\"");
        }
        String optsTxt = args.length > 1 ? args[1] : "b";
        ArrayList<ContentOpt> optList = new ArrayList<ContentOpt>();
        for (int ic = 0; ic < optsTxt.length(); ++ic) {
            Character chr = Character.valueOf(optsTxt.charAt(ic));
            if (chr.charValue() == '*') {
                optList.addAll(OPTS.values());
                continue;
            }
            ContentOpt opt = OPTS.get(chr);
            if (opt == null) {
                throw new TableFormatException("Unknown content option '" + chr + "' - must be one of [" + OPT_CHRS + "*]");
            }
            optList.add(opt);
        }
        ColumnStarTable table = new ColumnStarTable(){

            @Override
            public long getRowCount() {
                return nrow;
            }
        };
        for (ContentOpt opt : optList) {
            opt.addContent_.accept(table);
        }
        return table;
    }

    private static Map<Character, ContentOpt> createOpts() {
        ContentOpt[] opts = new ContentOpt[]{new ContentOpt('i', "index", "an integer index column", t -> t.addColumn(new ColumnData(new ColumnInfo("i_index", Integer.class, "Row index")){

            @Override
            public Object readValue(long irow) {
                return (int)irow;
            }
        })), new ContentOpt('b', "basic", "a few basic columns", t -> {
            int nPhase = 1;
            TestTableScheme.addColumn(t, "b_int", Integer.class, nPhase++, i -> i);
            TestTableScheme.addColumn(t, "b_double", Double.class, nPhase++, i -> i);
            TestTableScheme.addColumn(t, "b_string", String.class, nPhase++, i -> TestTableScheme.valString(i, false));
        }), new ContentOpt('s', "scalars", "a selection of typed scalar columns", t -> {
            int nPhase = 1;
            TestTableScheme.addColumn(t, "s_byte", Byte.class, nPhase++, i -> (byte)TestTableScheme.valInt(i));
            TestTableScheme.addColumn(t, "s_short", Short.class, nPhase++, i -> (short)TestTableScheme.valInt(i));
            TestTableScheme.addColumn(t, "s_int", Integer.class, nPhase++, i -> TestTableScheme.valInt(i));
            TestTableScheme.addColumn(t, "s_long", Long.class, nPhase++, i -> TestTableScheme.valInt(i));
            TestTableScheme.addColumn(t, "s_float", Float.class, nPhase++, i -> Float.valueOf((float)TestTableScheme.valDouble(i)));
            TestTableScheme.addColumn(t, "s_double", Double.class, nPhase++, i -> TestTableScheme.valDouble(i));
            TestTableScheme.addColumn(t, "s_string", String.class, nPhase++, i -> TestTableScheme.valString(i, true));
            TestTableScheme.addColumn(t, "s_boolean", Boolean.class, nPhase++, i -> i % 2 == 1);
        }), new ContentOpt('f', "fixed-vectors", "a selection of fixed-length 1-d array columns", t -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }), new ContentOpt('g', "fixed-vectors-nostr", "a selection of fixed-length 1-d array columns excluding strings", t -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }), new ContentOpt('v', "var-vectors", "a selection of variable-length 1-d array columns", t -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }), new ContentOpt('w', "var-vectors-nostr", "a selection of variable-length 1-d array columns excluding strings", t -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }), new ContentOpt('m', "multi-d arrays", "a selection of multi-dimensional array columns", t -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }), new ContentOpt('k', "kilo-column", "almost a thousand columns", t -> {
            for (int j = 0; j < 995; ++j) {
                TestTableScheme.addColumn(t, "k_" + (j + 1), Integer.class, 0, i -> TestTableScheme.valInt(i));
            }
        })};
        LinkedHashMap<Character, ContentOpt> map = new LinkedHashMap<Character, ContentOpt>();
        for (ContentOpt opt : opts) {
            char chr = Character.valueOf(opt.idChr_).charValue();
            assert (!map.containsKey(Character.valueOf(chr)));
            map.put(Character.valueOf(chr), opt);
        }
        return Collections.unmodifiableMap(map);
    }

    private static int valInt(int ix) {
        return ix * (ix / 10 % 2 == 0 ? 1 : -1);
    }

    private static double valDouble(int ix) {
        return TestTableScheme.isBlank(ix) ? Double.NaN : (double)TestTableScheme.valInt(ix);
    }

    private static String valString(int ix, boolean isTricky) {
        String postQuote;
        if (TestTableScheme.isBlank(ix)) {
            return "";
        }
        if (isTricky && TestTableScheme.isFunny(ix)) {
            return "' \"\\\"\"' ; '&<>";
        }
        if (ix == 0) {
            return "zero";
        }
        int u = ix % 10;
        int t = ix / 10 * 10;
        int v = ix / 10;
        StringBuffer sbuf = new StringBuffer();
        String[] qpairs = new String[]{null, "\"\"", "''", "<>", "()", "{}", "[]", ",;"};
        String qpair = isTricky ? qpairs[v % qpairs.length] : null;
        String preQuote = qpair == null ? "" : qpair.substring(0, 1);
        String string = postQuote = qpair == null ? "" : qpair.substring(1, 2);
        if (t != 0) {
            sbuf.append(Integer.toString(t));
            if (u != 0) {
                sbuf.append(isTricky ? " + " : "+");
            }
        }
        if (u != 0) {
            sbuf.append(preQuote).append((new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"})[u]).append(postQuote);
        }
        return sbuf.toString();
    }

    private static boolean isBlank(int ix) {
        return ix % 10 == 9;
    }

    private static boolean isFunny(int ix) {
        return ix % 10 == 8;
    }

    private static <T> void addColumn(ColumnStarTable table, String name, Class<T> clazz, final int nullPhase, final IntFunction<T> cellData) {
        table.addColumn(new ColumnData(new ColumnInfo(name, clazz, null)){

            public T readValue(long irow) {
                return irow % 10L == (long)nullPhase ? null : (Object)cellData.apply((int)irow);
            }
        });
    }

    private static <T> void addShapeColumn(ColumnStarTable table, String name, Class<T> clazz, int[] shape, int nullPhase, IntFunction<T> cellData) {
        TestTableScheme.addColumn(table, name, clazz, nullPhase, cellData);
        table.getColumnInfo(table.getColumnCount() - 1).setShape(shape);
    }

    private static <T> void addVarColumn(ColumnStarTable table, String name, final Class<T> clazz, final int nullPhase, final IntFunction<T> cellData) {
        final Class<?> elClazz = clazz.getComponentType();
        table.addColumn(new ColumnData(new ColumnInfo(name, clazz, null)){

            public T readValue(long irow) {
                if (irow % 10L == (long)nullPhase) {
                    return null;
                }
                Object value0 = cellData.apply((int)irow);
                if (value0 != null) {
                    int leng0 = Array.getLength(value0);
                    int leng1 = leng0 - (int)irow % (leng0 + 1);
                    if (leng1 == leng0) {
                        return value0;
                    }
                    Object value1 = clazz.cast(Array.newInstance(elClazz, leng1));
                    for (int i = 0; i < leng1; ++i) {
                        Array.set(value1, i, Array.get(value0, i));
                    }
                    return value1;
                }
                return value0;
            }
        });
    }

    private static /* synthetic */ double[] lambda$null$50(int i) {
        return new double[]{(double)i + 0.25, (double)i + 0.5, (double)i + 0.75, (double)(-i) - 0.25, (double)(-i) - 0.5, (double)(-i) - 0.75};
    }

    private static /* synthetic */ boolean[] lambda$null$47(int i) {
        return new boolean[]{i / 1 % 2 == 1, i / 2 % 2 == 1, i / 4 % 2 == 1};
    }

    private static /* synthetic */ double[] lambda$null$46(int i) {
        return new double[]{i + 0, Double.NaN, (double)i + 2.5};
    }

    private static /* synthetic */ float[] lambda$null$45(int i) {
        return new float[]{i + 0, Float.NaN, (float)i + 2.5f};
    }

    private static /* synthetic */ long[] lambda$null$44(int i) {
        return new long[]{i + 0, i + 1, i + 2};
    }

    private static /* synthetic */ int[] lambda$null$43(int i) {
        return new int[]{i + 0, i + 1, i + 2};
    }

    private static /* synthetic */ short[] lambda$null$42(int i) {
        return new short[]{(short)(i + 0), (short)(i + 1), (short)(i + 2)};
    }

    private static /* synthetic */ boolean[] lambda$null$39(int i) {
        return new boolean[]{i / 1 % 2 == 1, i / 2 % 2 == 1, i / 4 % 2 == 1};
    }

    private static /* synthetic */ String[] lambda$null$38(int i) {
        return new String[]{"foo", null, TestTableScheme.valString(i, true)};
    }

    private static /* synthetic */ double[] lambda$null$37(int i) {
        return new double[]{i + 0, Double.NaN, (double)i + 2.5};
    }

    private static /* synthetic */ float[] lambda$null$36(int i) {
        return new float[]{i + 0, Float.NaN, (float)i + 2.5f};
    }

    private static /* synthetic */ long[] lambda$null$35(int i) {
        return new long[]{i + 0, i + 1, i + 2};
    }

    private static /* synthetic */ int[] lambda$null$34(int i) {
        return new int[]{i + 0, i + 1, i + 2};
    }

    private static /* synthetic */ short[] lambda$null$33(int i) {
        return new short[]{(short)(i + 0), (short)(i + 1), (short)(i + 2)};
    }

    private static /* synthetic */ boolean[] lambda$null$30(int i) {
        return new boolean[]{i / 1 % 2 == 1, i / 2 % 2 == 1, i / 4 % 2 == 1};
    }

    private static /* synthetic */ double[] lambda$null$29(int i) {
        return new double[]{i, Double.NaN, (double)i + 2.5};
    }

    private static /* synthetic */ float[] lambda$null$28(int i) {
        return new float[]{i, Float.NaN, (float)i + 2.5f};
    }

    private static /* synthetic */ long[] lambda$null$27(int i) {
        return new long[]{i + 0, i + 1, i + 2};
    }

    private static /* synthetic */ int[] lambda$null$26(int i) {
        return new int[]{i + 0, i + 1, i + 2};
    }

    private static /* synthetic */ short[] lambda$null$25(int i) {
        return new short[]{(short)(i + 0), (short)(i + 1), (short)(i + 2)};
    }

    private static /* synthetic */ boolean[] lambda$null$22(int i) {
        return new boolean[]{i / 1 % 2 == 1, i / 2 % 2 == 1, i / 4 % 2 == 1};
    }

    private static /* synthetic */ String[] lambda$null$21(int i) {
        return new String[]{"foo", null, TestTableScheme.valString(i, true)};
    }

    private static /* synthetic */ double[] lambda$null$20(int i) {
        return new double[]{i, Double.NaN, (double)i + 2.5};
    }

    private static /* synthetic */ float[] lambda$null$19(int i) {
        return new float[]{i, Float.NaN, (float)i + 2.5f};
    }

    private static /* synthetic */ long[] lambda$null$18(int i) {
        return new long[]{i + 0, i + 1, i + 2};
    }

    private static /* synthetic */ int[] lambda$null$17(int i) {
        return new int[]{i + 0, i + 1, i + 2};
    }

    private static /* synthetic */ short[] lambda$null$16(int i) {
        return new short[]{(short)(i + 0), (short)(i + 1), (short)(i + 2)};
    }

    private static class ContentOpt {
        final char idChr_;
        final String name_;
        final String description_;
        final Consumer<ColumnStarTable> addContent_;

        ContentOpt(char idChr, String name, String description, Consumer<ColumnStarTable> addContent) {
            this.idChr_ = idChr;
            this.name_ = name;
            this.description_ = description;
            this.addContent_ = addContent;
        }
    }
}

