/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.formats.RowEvaluator;
import uk.ac.starlink.table.formats.StreamStarTable;
import uk.ac.starlink.util.DataSource;

public class CsvStarTable
extends StreamStarTable {
    private final Boolean fixHasHeaderLine_;
    private final int maxSample_;
    private final RowEvaluator.Decoder<?>[] decoders_;
    private final char delimiter_;
    private boolean hasHeading_;

    public CsvStarTable(DataSource datsrc) throws TableFormatException, IOException {
        this(datsrc, null, 0, ',', RowEvaluator.getStandardDecoders());
    }

    public CsvStarTable(DataSource datsrc, Boolean fixHasHeaderLine, int maxSample, char delimiter, RowEvaluator.Decoder<?>[] decoders) throws TableFormatException, IOException {
        this.fixHasHeaderLine_ = fixHasHeaderLine;
        this.maxSample_ = maxSample;
        this.delimiter_ = delimiter;
        this.decoders_ = decoders;
        this.init(datsrc);
    }

    @Override
    protected PushbackInputStream getInputStream() throws IOException {
        PushbackInputStream in = super.getInputStream();
        if (this.hasHeading_) {
            this.readRow(in);
        }
        return in;
    }

    @Override
    protected RowEvaluator.Metadata obtainMetadata() throws TableFormatException, IOException {
        PushbackInputStream in = super.getInputStream();
        long lrow = 0L;
        String[] row0 = this.readRow(in).toArray(new String[0]);
        ++lrow;
        RowEvaluator evaluator = new RowEvaluator(this.decoders_);
        try {
            List<String> row;
            while ((row = this.readRow(in)) != null && (this.maxSample_ <= 0 || lrow < (long)this.maxSample_)) {
                evaluator.submitRow(row);
                ++lrow;
            }
        }
        catch (TableFormatException e) {
            throw new TableFormatException(e.getMessage() + " at line " + (lrow + 1L), e);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        boolean isSampleLimited = this.maxSample_ > 0 && lrow >= (long)this.maxSample_;
        RowEvaluator.Metadata meta = evaluator.getMetadata();
        if (meta.nrow_ == 0L) {
            throw new TableFormatException("No rows");
        }
        RowEvaluator.Decoder<?>[] decoders = meta.decoders_;
        int ncol = meta.ncol_;
        if (row0.length == ncol) {
            boolean isDataRow;
            if (this.fixHasHeaderLine_ == null) {
                isDataRow = true;
                for (int icol = 0; icol < ncol; ++icol) {
                    String cell = row0[icol];
                    if (cell == null || cell.length() <= 0) continue;
                    isDataRow = isDataRow && decoders[icol].isValid(cell);
                }
            } else {
                isDataRow = this.fixHasHeaderLine_ == false;
            }
            boolean bl = this.hasHeading_ = !isDataRow;
            if (isDataRow) {
                evaluator.submitRow(Arrays.asList(row0));
                RowEvaluator.Metadata meta1 = evaluator.getMetadata();
                return new RowEvaluator.Metadata(meta1.colInfos_, meta1.decoders_, -1L);
            }
            assert (!isDataRow);
            ColumnInfo[] colinfos = meta.colInfos_;
            for (int icol = 0; icol < ncol; ++icol) {
                String h = row0[icol];
                if (h == null || h.trim().length() <= 0) continue;
                colinfos[icol].setName(h);
            }
            return new RowEvaluator.Metadata(colinfos, decoders, isSampleLimited ? -1L : meta.nrow_);
        }
        this.hasHeading_ = true;
        return new RowEvaluator.Metadata(meta.colInfos_, meta.decoders_, isSampleLimited ? -1L : meta.nrow_);
    }

    @Override
    protected List<String> readRow(PushbackInputStream in) throws IOException {
        ArrayList<String> cellList = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        boolean discard = false;
        boolean endFile = false;
        while (cellList.size() == 0 && !endFile) {
            boolean endLine = false;
            block7: while (!endLine) {
                char c = (char)in.read();
                if (c == this.delimiter_) {
                    if (discard) {
                        discard = false;
                    } else {
                        cellList.add(buffer.toString().trim());
                    }
                    buffer.setLength(0);
                    continue;
                }
                switch (c) {
                    case '\uffff': {
                        endFile = true;
                    }
                    case '\n': 
                    case '\r': {
                        boolean endLineChar = true;
                        while (endLineChar) {
                            int b = in.read();
                            endLineChar = b == 13 || b == 10;
                            if (endLineChar) continue;
                            in.unread(b);
                        }
                        if (discard) {
                            discard = false;
                        } else if (cellList.size() > 0 || !endFile) {
                            cellList.add(buffer.toString().trim());
                        }
                        buffer.setLength(0);
                        endLine = true;
                        continue block7;
                    }
                    case '\"': {
                        if (buffer.toString().trim().length() > 0) {
                            String msg = "Mixed quoted/unquoted cell '" + buffer + "'";
                            throw new TableFormatException(msg);
                        }
                        cellList.add(this.readString(in));
                        discard = true;
                        continue block7;
                    }
                    case '\t': 
                    case ' ': {
                        if (discard) continue block7;
                        buffer.append(c);
                        continue block7;
                    }
                }
                if (discard) {
                    throw new TableFormatException("Mixed quoted/unquoted cell '" + c + "'");
                }
                buffer.append(c);
            }
        }
        return cellList.size() == 0 ? null : cellList;
    }

    private String readString(PushbackInputStream in) throws IOException {
        StringBuffer buffer = new StringBuffer();
        block4: while (true) {
            char c = (char)in.read();
            switch (c) {
                case '\"': {
                    char c2 = (char)in.read();
                    if (c2 == '\"') {
                        buffer.append('\"');
                        continue block4;
                    }
                    if (c2 != '\uffff') {
                        in.unread(c2);
                    }
                    return buffer.toString();
                }
                case '\uffff': {
                    throw new TableFormatException("End of file within a string literal");
                }
            }
            buffer.append(c);
        }
    }
}

