/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import uk.ac.starlink.connect.Branch;
import uk.ac.starlink.connect.FileNode;
import uk.ac.starlink.connect.FilestoreChooser;
import uk.ac.starlink.connect.Leaf;
import uk.ac.starlink.connect.Node;
import uk.ac.starlink.table.MultiStarTableWriter;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.gui.SaveWorker;
import uk.ac.starlink.table.gui.TableSaveDialog;

public class FilestoreTableSaveDialog
implements TableSaveDialog {
    private final FilestoreChooser chooser_ = new FilestoreChooser(){

        public void leafSelected(Leaf leaf) {
            if (FilestoreTableSaveDialog.this.popup_ != null) {
                FilestoreTableSaveDialog.this.popup_.selected(leaf);
            }
        }
    };
    private FilestorePopup popup_;
    private static Icon icon_;

    public FilestoreTableSaveDialog() {
        this.chooser_.addDefaultBranches();
    }

    @Override
    public String getName() {
        return "Filestore Browser";
    }

    @Override
    public String getDescription() {
        return "Save table(s) to local or remote filespace";
    }

    @Override
    public Icon getIcon() {
        if (icon_ == null) {
            icon_ = new ImageIcon(this.getClass().getResource("filestore.png"));
        }
        return icon_;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean showSaveDialog(Component parent, StarTableOutput sto, ComboBoxModel<String> formatModel, StarTable[] tables) {
        if (this.popup_ != null) {
            throw new IllegalStateException("Dialogue already visible");
        }
        Frame frame = null;
        if (parent != null) {
            frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        }
        FilestorePopup popup = new FilestorePopup(frame, sto, tables, formatModel);
        popup.pack();
        popup.setLocationRelativeTo(parent);
        this.chooser_.refreshList();
        this.chooser_.setEnabled(true);
        this.popup_ = popup;
        this.popup_.setVisible(true);
        boolean success = this.popup_ == popup;
        this.popup_ = null;
        return success;
    }

    public FilestoreChooser getChooser() {
        return this.chooser_;
    }

    private static void attemptSave(StarTable[] tables, StarTableOutput sto, Leaf leaf, String format) throws IOException {
        String loc = leaf instanceof FileNode ? ((FileNode)leaf).getFile().toString() : null;
        if (loc != null) {
            sto.writeStarTables(tables, loc, format);
        } else {
            OutputStream stream = leaf.getOutputStream();
            StarTableWriter handler = sto.getHandler(format, leaf.getName());
            if (tables.length == 1) {
                sto.writeStarTable(tables[0], stream, handler);
            } else if (handler instanceof MultiStarTableWriter) {
                sto.writeStarTables(tables, stream, (MultiStarTableWriter)handler);
            } else {
                throw new IOException("Can't write multiple tables to format " + handler.getFormatName());
            }
        }
    }

    private static boolean exists(Leaf leaf) {
        String name = leaf.getName();
        Branch parent = leaf.getParent();
        if (parent != null) {
            Node[] siblings = parent.getChildren();
            for (int i = 0; i < siblings.length; ++i) {
                if (!siblings[i].getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean confirmOverwrite(Component parent, String loc) {
        String[] msg = new String[]{"Overwrite existing file \"" + loc + "\"?"};
        String cancelOption = "Cancel";
        String overwriteOption = "Overwrite";
        Object[] options = new Object[]{cancelOption, overwriteOption};
        int result = JOptionPane.showOptionDialog(parent, msg, "Confirm overwrite", 0, 2, null, options, cancelOption);
        return result == 1;
    }

    private class FilestorePopup
    extends JDialog {
        SaveWorker worker_;
        final JProgressBar progBar_;
        final StarTableOutput sto_;
        final StarTable[] tables_;
        final ComboBoxModel<String> formatModel_;

        FilestorePopup(Frame frame, StarTableOutput sto, StarTable[] tables, ComboBoxModel<String> formatModel) {
            super(frame, "Save Table", true);
            this.sto_ = sto;
            this.tables_ = tables;
            this.formatModel_ = formatModel;
            this.setDefaultCloseOperation(2);
            AbstractAction cancelAction = new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (FilestorePopup.this.worker_ != null) {
                        FilestorePopup.this.worker_.cancel();
                        FilestorePopup.this.worker_ = null;
                    } else if (FilestoreTableSaveDialog.this.popup_ == FilestorePopup.this) {
                        FilestoreTableSaveDialog.this.popup_.dispose();
                        FilestoreTableSaveDialog.this.popup_ = null;
                    }
                    FilestoreTableSaveDialog.this.chooser_.setEnabled(true);
                }
            };
            this.progBar_ = new JProgressBar();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.progBar_, "South");
            JPanel main = new JPanel(new BorderLayout());
            this.getContentPane().add((Component)main, "Center");
            main.add((Component)FilestoreTableSaveDialog.this.chooser_, "Center");
            Box formatBox = Box.createHorizontalBox();
            formatBox.add(new JLabel("Output Format: "));
            JComboBox<String> formatSelector = new JComboBox<String>(formatModel);
            formatSelector.setEditable(true);
            formatBox.add(formatSelector);
            Box controlBox = Box.createHorizontalBox();
            controlBox.add(Box.createHorizontalGlue());
            controlBox.add(new JButton(FilestoreTableSaveDialog.this.chooser_.getOkAction()));
            controlBox.add(Box.createHorizontalStrut(5));
            controlBox.add(new JButton(cancelAction));
            Box botBox = Box.createVerticalBox();
            botBox.add(formatBox);
            botBox.add(Box.createVerticalStrut(5));
            botBox.add(controlBox);
            botBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            main.add((Component)botBox, "South");
        }

        public void selected(final Leaf leaf) {
            if (this.worker_ == null) {
                if (FilestoreTableSaveDialog.exists(leaf) && !FilestoreTableSaveDialog.confirmOverwrite(this, leaf.toString())) {
                    return;
                }
                this.worker_ = new SaveWorker(this.progBar_, this.tables_, leaf.toString()){

                    @Override
                    protected void attemptSave(StarTable[] tables) throws IOException {
                        FilestoreTableSaveDialog.attemptSave(tables, FilestorePopup.this.sto_, leaf, (String)FilestorePopup.this.formatModel_.getSelectedItem());
                    }

                    @Override
                    protected void done(boolean success) {
                        FilestorePopup.this.worker_ = null;
                        if (success) {
                            FilestorePopup.this.dispose();
                        }
                        FilestoreTableSaveDialog.this.chooser_.setEnabled(true);
                    }
                };
                FilestoreTableSaveDialog.this.chooser_.setEnabled(false);
                this.worker_.invoke();
            }
        }
    }
}

