/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import uk.ac.starlink.table.storage.NioByteStoreAccess;

class SingleNioAccess
extends NioByteStoreAccess {
    private final ByteBuffer bbuf_;

    public SingleNioAccess(ByteBuffer bbuf) {
        this.bbuf_ = bbuf;
    }

    @Override
    protected ByteBuffer getBuffer(int nbyte) throws IOException {
        int remaining = this.bbuf_.remaining();
        if (remaining >= nbyte) {
            return this.bbuf_;
        }
        if (remaining == 0) {
            throw new EOFException();
        }
        throw new EOFException("Requested " + nbyte + " bytes, only " + remaining + " left");
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < 0L || pos >= (long)this.bbuf_.limit()) {
            throw new IOException("Out of range " + pos);
        }
        this.bbuf_.position((int)pos);
    }

    @Override
    public void skip(int n) throws IOException {
        this.getBuffer(n);
        this.bbuf_.position(this.bbuf_.position() + n);
    }
}

