/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ecsv;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import uk.ac.starlink.ecsv.EcsvColumn;
import uk.ac.starlink.ecsv.EcsvDecoder;
import uk.ac.starlink.ecsv.EcsvFormatException;
import uk.ac.starlink.ecsv.EcsvHeader;
import uk.ac.starlink.ecsv.EcsvMeta;
import uk.ac.starlink.ecsv.LineReader;
import uk.ac.starlink.ecsv.MessagePolicy;
import uk.ac.starlink.ecsv.YamlParser;

public class EcsvReader
implements Closeable {
    private final LineReader lineRdr_;
    private final EcsvMeta meta_;
    private final char delim_;
    private final int ncol_;
    private final EcsvDecoder<?>[] decoders_;
    private final List<String> words_ = new ArrayList<String>();
    private final StringBuilder wbuf_ = new StringBuilder();
    private List<String> cellWords_;
    private long irow_;
    private long nError_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ecsv");

    public EcsvReader(InputStream in, YamlParser yamlParser, MessagePolicy colCheck) throws IOException, EcsvFormatException {
        LineReader namesLineReader;
        List<String> nameWords;
        int nName;
        this.lineRdr_ = LineReader.createAsciiLineReader(in);
        EcsvHeader header = EcsvHeader.readHeader(this.lineRdr_);
        this.meta_ = yamlParser.parseMeta(header.getYamlLines());
        this.delim_ = this.meta_.getDelimiter();
        EcsvColumn<?>[] columns = this.meta_.getColumns();
        this.ncol_ = columns.length;
        this.decoders_ = new EcsvDecoder[this.ncol_];
        for (int ic = 0; ic < this.ncol_; ++ic) {
            this.decoders_[ic] = columns[ic].getDecoder();
        }
        if (this.delim_ != ' ' && this.delim_ != ',') {
            logger_.warning("Illegal delimiter character '" + Character.toString(this.delim_) + "' - may cause trouble");
        }
        int n = nName = (nameWords = this.readNextRowWords(namesLineReader = LineReader.createArrayLineReader(new String[]{header.getNamesLine()}))) == null ? -1 : nameWords.size();
        if (nName != this.ncol_) {
            throw new EcsvFormatException("Names line/YAML column count mismatch: " + nName + " != " + this.ncol_);
        }
        ArrayList<String> colMismatches = new ArrayList<String>();
        for (int ic = 0; ic < this.ncol_; ++ic) {
            String csvName = nameWords.get(ic);
            String yamlName = columns[ic].getName();
            if (yamlName.equalsIgnoreCase(csvName)) continue;
            colMismatches.add(csvName + "!=" + yamlName);
        }
        int nMis = colMismatches.size();
        if (nMis > 0) {
            int nMax = 5;
            StringBuffer sbuf = new StringBuffer().append("YAML/CSV column name ").append(nMis > 1 ? "mismatches: " : "mismatch: ").append(colMismatches.stream().limit(nMax).collect(Collectors.joining(", ")));
            if (nMis > nMax) {
                sbuf.append(", ...");
            }
            colCheck.deliverMessage(sbuf.toString());
        }
    }

    public EcsvMeta getMeta() {
        return this.meta_;
    }

    public boolean next() throws IOException, EcsvFormatException {
        this.cellWords_ = this.readNextRowWords(this.lineRdr_);
        if (this.cellWords_ != null) {
            int nword = this.cellWords_.size();
            if (nword == this.ncol_) {
                ++this.irow_;
                return true;
            }
            throw new EcsvFormatException("Wrong number of fields at line " + this.irow_ + " (" + nword + " != " + this.ncol_ + ")");
        }
        if (this.nError_ > 0L) {
            logger_.warning("Cell parse errors: " + this.nError_);
        }
        return false;
    }

    public Object getCell(int icol) {
        if (this.cellWords_ == null) {
            throw new IllegalStateException("No current row");
        }
        String word = this.cellWords_.get(icol);
        if (word == null || word.length() == 0) {
            return null;
        }
        try {
            return this.decoders_[icol].decode(word);
        }
        catch (NumberFormatException e) {
            ++this.nError_;
            return null;
        }
    }

    public Object[] getRow() {
        Object[] values = new Object[this.ncol_];
        for (int ic = 0; ic < this.ncol_; ++ic) {
            values[ic] = this.getCell(ic);
        }
        return values;
    }

    @Override
    public void close() throws IOException {
        this.lineRdr_.close();
    }

    private List<String> readNextRowWords(LineReader lineReader) throws IOException {
        String line;
        this.words_.clear();
        this.wbuf_.setLength(0);
        boolean inQuote = false;
        while ((line = lineReader.readLine()) != null) {
            int nc = line.length();
            block5: for (int i = 0; i < nc; ++i) {
                char c = line.charAt(i);
                switch (c) {
                    case ' ': 
                    case ',': {
                        if (c == this.delim_ && !inQuote) {
                            this.words_.add(this.wbuf_.toString());
                            this.wbuf_.setLength(0);
                            continue block5;
                        }
                        this.wbuf_.append(c);
                        continue block5;
                    }
                    case '\"': {
                        if (!inQuote) {
                            inQuote = true;
                            continue block5;
                        }
                        if (line.length() > i + 1 && line.charAt(i + 1) == '\"') {
                            ++i;
                            this.wbuf_.append('\"');
                            continue block5;
                        }
                        inQuote = false;
                        continue block5;
                    }
                    default: {
                        this.wbuf_.append(c);
                    }
                }
            }
            if (inQuote) {
                this.wbuf_.append('\n');
                continue;
            }
            if (this.words_.size() == 0 && this.wbuf_.length() == 0) {
                return null;
            }
            this.words_.add(this.wbuf_.toString());
            this.wbuf_.setLength(0);
            return this.words_;
        }
        return null;
    }
}

