/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.registry.search;

import javax.xml.soap.SOAPException;
import net.ivoa.registry.RegistryCommException;
import net.ivoa.registry.RegistryFormatException;
import net.ivoa.registry.RegistryServiceException;
import net.ivoa.registry.search.Searcher;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SearchResults {
    Searcher search = null;
    LinkedElement buffer = null;
    Element currentBatch = null;
    Node currentRecord = null;
    String elname = null;
    int count = 0;
    int nextfetch = 0;
    int prevfetch = 0;
    int fetchesFromUnknown = 0;
    int defnum;
    int prevnum = this.defnum = 250;
    int nextnum = this.defnum;
    boolean haveLast = false;
    boolean seenLast = false;
    short strictness = 1;
    int bufpos = 0;
    int bufnum = 0;
    int abspos = 0;

    SearchResults(Searcher searcher, short strictness, String elementName) throws RegistryServiceException, RegistryFormatException, RegistryCommException {
        this.strictness = strictness;
        this.elname = elementName;
        this.search = searcher;
        this.nextnum = this.defnum = searcher.getMax();
        this.prevnum = this.defnum;
        this.retrieveNext();
        if (this.buffer != null) {
            this.bufnum = this.buffer.getRecordCount();
            this.currentBatch = this.buffer.element;
            this.currentRecord = null;
        }
    }

    public int getRetrievedCount() {
        return this.count;
    }

    public boolean isCountFinal() {
        return this.seenLast;
    }

    private static Element getFirstChildElement(Element parent) throws RegistryFormatException {
        Node child;
        for (child = parent.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        if (child == null) {
            throw new RegistryFormatException("Empty response wrapper: " + parent.getTagName());
        }
        return (Element)child;
    }

    int retrieveNext() throws RegistryServiceException, RegistryFormatException, RegistryCommException {
        this.search.setFrom(this.nextfetch);
        this.search.setMax(this.nextnum);
        if (this.buffer != null && this.buffer.size() > 1) {
            this.buffer.dropFirst();
        }
        Element result = null;
        int num = -1;
        try {
            result = this.search.exec();
        }
        catch (SOAPException ex) {
            throw new RegistryCommException((Exception)((Object)ex));
        }
        result = SearchResults.getFirstChildElement(result);
        String attval = result.getAttribute("more");
        if (attval == null || !attval.equalsIgnoreCase("true") && !attval.equalsIgnoreCase("false")) {
            throw new RegistryFormatException("bad format for more attribute: " + attval);
        }
        boolean more = Boolean.valueOf(attval);
        try {
            num = Integer.parseInt(result.getAttribute("numberReturned"));
        }
        catch (NumberFormatException ex) {
            this.complianceError("VOResources element with illegal numberReturned: " + result.getAttribute("numberReturned"));
            num = this.countRecords(result);
        }
        if (this.fetchesFromUnknown < 1) {
            this.count += num;
        } else {
            --this.fetchesFromUnknown;
        }
        if (!more) {
            this.haveLast = true;
            this.seenLast = true;
            if (num < this.nextnum) {
                this.nextnum = num;
            }
        }
        this.nextfetch += num;
        if (this.buffer == null) {
            this.buffer = new LinkedElement(result, num);
        } else {
            this.buffer.addLast(result, num);
        }
        return num;
    }

    int countRecords(Element parent) throws RegistryFormatException {
        this.count = 0;
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            ++this.count;
        }
        return this.count;
    }

    int retrievePrevious() throws RegistryServiceException, RegistryFormatException, RegistryCommException {
        this.search.setFrom(this.prevfetch);
        this.search.setMax(this.prevnum);
        if (this.buffer != null && this.buffer.size() > 1) {
            this.buffer.dropLast();
            if (this.haveLast) {
                this.haveLast = false;
            }
            ++this.fetchesFromUnknown;
        }
        Element result = null;
        int num = -1;
        try {
            result = this.search.exec();
        }
        catch (SOAPException ex) {
            throw new RegistryCommException((Exception)((Object)ex));
        }
        String attval = result.getAttribute("more");
        if (attval == null || !attval.equalsIgnoreCase("true") && !attval.equalsIgnoreCase("false")) {
            throw new RegistryFormatException("bad format for more attribute: " + attval);
        }
        boolean more = Boolean.valueOf(attval);
        try {
            num = Integer.parseInt(result.getAttribute("numberReturned"));
        }
        catch (NumberFormatException ex) {
            this.complianceError("VOResources element with illegal numberReturned: " + result.getAttribute("numberReturned"));
            num = this.countRecords(result);
        }
        if (this.prevfetch == 1) {
            this.prevnum = this.nextnum;
        } else {
            this.prevnum = num;
            this.prevfetch -= this.prevnum;
            if (this.prevfetch < 1) {
                this.prevnum = this.prevnum + this.prevfetch - 1;
                this.prevfetch = 1;
            }
        }
        this.buffer.addLast(result, num);
        return num;
    }

    public boolean hasNext() {
        return this.bufpos < this.bufnum || !this.haveLast;
    }

    public boolean hasPrevious() {
        return this.abspos > 1;
    }

    private void complianceError(String msg) throws RegistryFormatException {
        if (this.strictness > 1) {
            throw new RegistryFormatException(msg);
        }
        if (this.strictness == 1) {
            System.err.println(msg);
        }
    }

    Element nextElement() throws RegistryServiceException, RegistryFormatException, RegistryCommException {
        if (!this.hasNext()) {
            return null;
        }
        if (++this.bufpos > this.bufnum) {
            if (this.buffer.next == null) {
                this.retrieveNext();
            }
            this.buffer = this.buffer.next;
            this.bufnum = this.buffer.getRecordCount();
            this.bufpos = 0;
            this.currentBatch = this.buffer.element;
            this.currentRecord = null;
        }
        if (this.bufpos > this.bufnum) {
            if (!this.hasNext()) {
                return null;
            }
            this.complianceError("VOResources element with numReturned=\"0\" but more=\"false\" (record no.=" + this.abspos + ").");
            return this.nextElement();
        }
        String underflow = "VOResources element has fewer records (" + this.bufpos + ") than expected (" + this.bufnum + ").";
        this.currentRecord = this.currentRecord == null ? this.currentBatch.getFirstChild() : this.currentRecord.getNextSibling();
        if (this.currentRecord == null) {
            if (!this.hasNext()) {
                return null;
            }
            if (this.bufpos < this.bufnum) {
                this.complianceError(underflow);
            }
            return this.nextElement();
        }
        while (this.currentRecord.getNodeType() != 1 || !this.elname.equals(this.currentRecord.getLocalName())) {
            this.currentRecord = this.currentRecord.getNextSibling();
            if (this.currentRecord != null) continue;
            if (!this.hasNext()) {
                return null;
            }
            if (this.bufpos < this.bufnum) {
                this.complianceError(underflow);
            }
            return this.nextElement();
        }
        ++this.abspos;
        return (Element)this.currentRecord;
    }

    Element previousElement() throws RegistryServiceException, RegistryFormatException, RegistryCommException {
        if (!this.hasPrevious()) {
            return null;
        }
        if (--this.bufpos <= 0) {
            if (this.buffer.prev == null) {
                this.retrievePrevious();
            }
            this.buffer = this.buffer.prev;
            this.bufnum = this.buffer.getRecordCount();
            this.bufpos = this.bufnum - 1;
            this.currentBatch = this.buffer.element;
            this.currentRecord = null;
        }
        if (this.bufpos < 0) {
            if (!this.hasPrevious()) {
                return null;
            }
            this.complianceError("VOResources element with numReturned=\"0\" on previous records (record no.=" + this.abspos + ").");
            return this.previousElement();
        }
        String underflow = "VOResources element has fewer records (" + this.bufpos + ") than expected (" + this.bufnum + ").";
        this.currentRecord = this.currentRecord == null ? this.currentBatch.getLastChild() : this.currentRecord.getPreviousSibling();
        if (this.currentRecord == null) {
            return this.previousElement();
        }
        while (this.currentRecord.getNodeType() != 1 || !this.elname.equals(this.currentRecord.getLocalName())) {
            this.currentRecord = this.currentRecord.getPreviousSibling();
            if (this.currentRecord != null) continue;
            return this.previousElement();
        }
        --this.abspos;
        return (Element)this.currentRecord;
    }

    class LinkedElement {
        public Element element = null;
        public LinkedElement next = null;
        public LinkedElement prev = null;
        int[] linkcount = new int[]{1};
        int reccount = 0;

        public LinkedElement(Element el) {
            this(el, 1);
        }

        public LinkedElement(Element el, int count) {
            this.element = el;
            this.reccount = count;
        }

        public int size() {
            return this.linkcount[0];
        }

        public int getRecordCount() {
            return this.reccount;
        }

        public void addFirst(Element el, int count) {
            LinkedElement first = this;
            while (first.prev != null) {
                first = first.prev;
            }
            first.prev = new LinkedElement(el, count);
            first.prev.linkcount = this.linkcount;
            this.linkcount[0] = this.linkcount[0] + 1;
            first.prev.next = first;
        }

        public void addLast(Element el, int count) {
            LinkedElement last = this;
            while (last.next != null) {
                last = last.next;
            }
            last.next = new LinkedElement(el, count);
            last.next.linkcount = this.linkcount;
            this.linkcount[0] = this.linkcount[0] + 1;
            last.next.prev = last;
        }

        public void dropFirst() {
            LinkedElement first = this;
            while (first.prev != null) {
                first = first.prev;
            }
            if (first != this) {
                first.next.prev = null;
                first.next = null;
                this.linkcount[0] = this.linkcount[0] - 1;
            }
        }

        public void dropLast() {
            LinkedElement last = this;
            while (last.prev != null) {
                last = last.prev;
            }
            if (last != this) {
                last.prev.next = null;
                last.prev = null;
                this.linkcount[0] = this.linkcount[0] - 1;
            }
        }
    }
}

