/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableSequence;

public class QueueTableSequence
implements TableSequence {
    private final List<Object> queue_ = new LinkedList<Object>();

    public synchronized void addTable(StarTable table) {
        this.queue_.add(table);
        this.notifyAll();
    }

    public synchronized void addError(Throwable error) {
        this.queue_.add(error);
        this.notifyAll();
    }

    public synchronized void endSequence() {
        this.queue_.add(null);
        this.notifyAll();
    }

    @Override
    public synchronized StarTable nextTable() throws IOException {
        try {
            while (this.queue_.isEmpty()) {
                this.wait();
            }
            if (this.queue_.get(0) == null) {
                return null;
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new IOException("Interrupted").initCause(e);
        }
        Object obj = this.queue_.remove(0);
        if (obj instanceof StarTable) {
            return (StarTable)obj;
        }
        if (obj instanceof Throwable) {
            Throwable err = (Throwable)obj;
            throw (IOException)new IOException(err.getMessage()).initCause(err);
        }
        throw new AssertionError();
    }
}

