/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import uk.ac.starlink.table.ProgressRowSplittable;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public class ProgressBarStarTable
extends WrapperStarTable {
    private JProgressBar progBar_;
    private BooleanSupplier isCancelled_;
    private String label_;
    private static final int INTERVAL = 250;

    public ProgressBarStarTable(StarTable baseTable, JProgressBar progBar) {
        this(baseTable, progBar, Thread::interrupted);
    }

    public ProgressBarStarTable(StarTable baseTable, JProgressBar progBar, BooleanSupplier isCancelled) {
        super(baseTable);
        this.setProgressBar(progBar);
        this.isCancelled_ = isCancelled;
    }

    public void setProgressBar(JProgressBar progBar) {
        this.progBar_ = progBar;
    }

    public JProgressBar getProgressBar() {
        return this.progBar_;
    }

    public void setActiveLabel(String label) {
        this.label_ = label;
        this.progBar_.setStringPainted(label != null && label.trim().length() > 0);
    }

    public String getActiveLabel() {
        return this.label_;
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        this.setZero(true);
        return new WrapperRowSequence(this.baseTable.getRowSequence()){
            long irow;
            Timer timer;
            {
                this.timer = ProgressBarStarTable.this.startProgressTimer(() -> this.irow);
            }

            @Override
            public boolean next() throws IOException {
                if (ProgressBarStarTable.this.isCancelled_.getAsBoolean()) {
                    this.timer.stop();
                    throw new IOException("Cancelled");
                }
                ++this.irow;
                return super.next();
            }

            @Override
            public void close() throws IOException {
                this.timer.stop();
                ProgressBarStarTable.this.setZero(false);
                super.close();
            }
        };
    }

    @Override
    public RowSplittable getRowSplittable() throws IOException {
        this.setZero(true);
        ProgressRowSplittable.Target target = new ProgressRowSplittable.Target(){
            AtomicLong irow = new AtomicLong();
            Timer timer = ProgressBarStarTable.access$000(ProgressBarStarTable.this, () -> this.irow.get());

            @Override
            public void updateCount(long count) throws IOException {
                if (ProgressBarStarTable.this.isCancelled_.getAsBoolean()) {
                    this.timer.stop();
                    throw new IOException("Cancelled");
                }
                this.irow.set(count);
            }

            @Override
            public void done(long count) {
                this.timer.stop();
                ProgressBarStarTable.this.setZero(false);
            }
        };
        return new ProgressRowSplittable(super.getRowSplittable(), target);
    }

    private Timer startProgressTimer(LongSupplier counter) {
        Timer timer = new Timer(250, evt -> {
            if (this.progBar_ != null) {
                this.progBar_.setValue((int)counter.getAsLong());
            }
        });
        timer.setInitialDelay(0);
        timer.setCoalesce(true);
        timer.start();
        return timer;
    }

    private void setZero(final boolean labelOn) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ProgressBarStarTable.this.progBar_ != null) {
                    ProgressBarStarTable.this.progBar_.setMinimum(0);
                    ProgressBarStarTable.this.progBar_.setValue(0);
                    long nrow = ProgressBarStarTable.this.getRowCount();
                    boolean determinate = nrow > 0L && nrow < Integer.MAX_VALUE;
                    ProgressBarStarTable.this.progBar_.setIndeterminate(!determinate);
                    if (determinate) {
                        ProgressBarStarTable.this.progBar_.setMaximum((int)nrow);
                    }
                    ProgressBarStarTable.this.progBar_.setString(labelOn ? ProgressBarStarTable.this.label_ : "");
                }
            }
        });
    }
}

