/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import uk.ac.starlink.table.storage.ByteStoreColumnReader;
import uk.ac.starlink.table.storage.Codec;
import uk.ac.starlink.table.storage.ColumnReader;
import uk.ac.starlink.table.storage.ColumnStore;
import uk.ac.starlink.table.storage.SingleNioAccess;

class MappedColumnStore
implements ColumnStore {
    private final Codec codec_;
    private final int itemSize_;
    private final ByteBuffer bbuf_;
    private final BufferIOAccess access_;
    private long nrow_;

    public MappedColumnStore(Codec codec, ByteBuffer bbuf) {
        this.codec_ = codec;
        this.itemSize_ = codec.getItemSize();
        this.bbuf_ = bbuf;
        this.access_ = new BufferIOAccess(bbuf);
        if (this.itemSize_ < 0) {
            throw new IllegalArgumentException("Must have fixed size codec");
        }
    }

    @Override
    public void acceptCell(Object value) throws IOException {
        ++this.nrow_;
        int nbyte = this.codec_.encode(value, this.access_);
        assert (nbyte == this.itemSize_);
    }

    @Override
    public void endCells() {
    }

    @Override
    public ColumnReader createReader() {
        SingleNioAccess roAccess = new SingleNioAccess(this.bbuf_.asReadOnlyBuffer());
        return new ByteStoreColumnReader(this.codec_, roAccess, this.nrow_){

            @Override
            public long getAccessOffset(long ix) {
                return ix * (long)MappedColumnStore.this.itemSize_;
            }
        };
    }

    private static class BufferIOAccess
    extends SingleNioAccess
    implements DataOutput {
        BufferIOAccess(ByteBuffer bbuf) {
            super(bbuf);
        }

        @Override
        public void write(int b) throws IOException {
            this.getBuffer(1).put((byte)b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.getBuffer(len).put(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.getBuffer(b.length).put(b);
        }

        @Override
        public void writeBoolean(boolean val) throws IOException {
            this.getBuffer(1).put(val ? (byte)1 : 0);
        }

        @Override
        public void writeByte(int val) throws IOException {
            this.getBuffer(1).put((byte)val);
        }

        @Override
        public void writeChar(int val) throws IOException {
            this.getBuffer(2).putChar((char)val);
        }

        @Override
        public void writeShort(int val) throws IOException {
            this.getBuffer(2).putShort((short)val);
        }

        @Override
        public void writeInt(int val) throws IOException {
            this.getBuffer(4).putInt(val);
        }

        @Override
        public void writeLong(long val) throws IOException {
            this.getBuffer(8).putLong(val);
        }

        @Override
        public void writeFloat(float val) throws IOException {
            this.getBuffer(4).putFloat(val);
        }

        @Override
        public void writeDouble(double val) throws IOException {
            this.getBuffer(8).putDouble(val);
        }

        @Override
        public void writeBytes(String val) throws IOException {
            throw new UnsupportedOperationException("Incomplete DataOutput implementation");
        }

        @Override
        public void writeChars(String val) throws IOException {
            throw new UnsupportedOperationException("Incomplete DataOutput implementation");
        }

        @Override
        public void writeUTF(String val) throws IOException {
            throw new UnsupportedOperationException("Incomplete DataOutput implementation");
        }
    }
}

