/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class PdfArray
extends PdfObject {
    protected ArrayList arrayList;

    public PdfArray() {
        super(5);
        this.arrayList = new ArrayList();
    }

    public PdfArray(PdfObject pdfObject) {
        super(5);
        this.arrayList = new ArrayList();
        this.arrayList.add(pdfObject);
    }

    public PdfArray(float[] fArray) {
        super(5);
        this.arrayList = new ArrayList();
        this.add(fArray);
    }

    public PdfArray(int[] nArray) {
        super(5);
        this.arrayList = new ArrayList();
        this.add(nArray);
    }

    public PdfArray(PdfArray pdfArray) {
        super(5);
        this.arrayList = new ArrayList(pdfArray.arrayList);
    }

    public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
        PdfObject pdfObject;
        outputStream.write(91);
        Iterator iterator = this.arrayList.iterator();
        int n = 0;
        if (iterator.hasNext()) {
            pdfObject = (PdfObject)iterator.next();
            if (pdfObject == null) {
                pdfObject = PdfNull.PDFNULL;
            }
            pdfObject.toPdf(pdfWriter, outputStream);
        }
        while (iterator.hasNext()) {
            pdfObject = (PdfObject)iterator.next();
            if (pdfObject == null) {
                pdfObject = PdfNull.PDFNULL;
            }
            if ((n = pdfObject.type()) != 5 && n != 6 && n != 4 && n != 3) {
                outputStream.write(32);
            }
            pdfObject.toPdf(pdfWriter, outputStream);
        }
        outputStream.write(93);
    }

    public String toString() {
        return this.arrayList.toString();
    }

    public PdfObject set(int n, PdfObject pdfObject) {
        return this.arrayList.set(n, pdfObject);
    }

    public ArrayList getArrayList() {
        return this.arrayList;
    }

    public int size() {
        return this.arrayList.size();
    }

    public boolean isEmpty() {
        return this.arrayList.isEmpty();
    }

    public boolean add(PdfObject pdfObject) {
        return this.arrayList.add(pdfObject);
    }

    public boolean add(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            this.arrayList.add(new PdfNumber(fArray[i]));
        }
        return true;
    }

    public boolean add(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.arrayList.add(new PdfNumber(nArray[i]));
        }
        return true;
    }

    public void addFirst(PdfObject pdfObject) {
        this.arrayList.add(0, pdfObject);
    }

    public boolean contains(PdfObject pdfObject) {
        return this.arrayList.contains(pdfObject);
    }

    public ListIterator listIterator() {
        return this.arrayList.listIterator();
    }

    public PdfObject getPdfObject(int n) {
        return (PdfObject)this.arrayList.get(n);
    }

    public PdfObject getDirectObject(int n) {
        return PdfReader.getPdfObject(this.getPdfObject(n));
    }

    public PdfDictionary getAsDict(int n) {
        PdfDictionary pdfDictionary = null;
        PdfObject pdfObject = this.getDirectObject(n);
        if (pdfObject != null && pdfObject.isDictionary()) {
            pdfDictionary = (PdfDictionary)pdfObject;
        }
        return pdfDictionary;
    }

    public PdfName getAsName(int n) {
        PdfName pdfName = null;
        PdfObject pdfObject = this.getDirectObject(n);
        if (pdfObject != null && pdfObject.isName()) {
            pdfName = (PdfName)pdfObject;
        }
        return pdfName;
    }

    public PdfIndirectReference getAsIndirectObject(int n) {
        PdfIndirectReference pdfIndirectReference = null;
        PdfObject pdfObject = this.getPdfObject(n);
        if (pdfObject != null && pdfObject.isIndirect()) {
            pdfIndirectReference = (PdfIndirectReference)pdfObject;
        }
        return pdfIndirectReference;
    }
}

