/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.logging.Logger;

abstract class AngleOptimiser {
    private final double tol_;
    private final int maxIts_;
    private final int nRestart_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.join");

    public AngleOptimiser(double tol, int maxIts, int nRestart) {
        this.tol_ = tol;
        this.maxIts_ = maxIts;
        this.nRestart_ = nRestart;
    }

    public abstract double[] calcDerivs(double var1);

    private double findMinimum(double phi0) {
        for (int ir = 0; ir < this.nRestart_; ++ir) {
            double phi = phi0 + Math.PI * 2 * (double)ir / (double)this.nRestart_;
            double min = this.findExtremum(phi, Boolean.TRUE);
            if (Double.isNaN(min)) continue;
            if (ir > 0) {
                logger_.info("Minimisation required " + ir + " restarts");
            }
            return min;
        }
        logger_.warning("Fail to find any minimum");
        return Double.NaN;
    }

    public double findExtremum(double phi0, Boolean requireMin) {
        double phi = phi0;
        int n = 0;
        do {
            boolean isMin;
            double[] derivs;
            double dphi;
            if (!(Math.abs(dphi = (derivs = this.calcDerivs(phi))[1] / derivs[2]) < 1.5707963267948966)) {
                dphi = Math.signum(dphi) * Math.PI * 0.01;
            }
            phi = (phi - dphi + Math.PI * 2) % (Math.PI * 2);
            if (!(Math.abs(dphi) < this.tol_)) continue;
            if (requireMin == null) {
                return phi;
            }
            if (derivs[2] == 0.0) {
                return Double.NaN;
            }
            boolean reqMin = requireMin;
            boolean bl = isMin = derivs[2] > 0.0;
            assert (Math.signum(this.calcDerivs(phi + 10.0 * this.tol_)[0] - this.calcDerivs(phi)[0]) == (double)(isMin ? 1 : -1));
            assert (Math.signum(this.calcDerivs(phi - 10.0 * this.tol_)[0] - this.calcDerivs(phi)[0]) == (double)(isMin ? 1 : -1));
            return reqMin == isMin ? phi : Double.NaN;
        } while (n++ <= this.maxIts_);
        return Double.NaN;
    }
}

