/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.function.Supplier;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AbstractCartesianMatchEngine;
import uk.ac.starlink.table.join.Coverage;
import uk.ac.starlink.table.join.CuboidCoverage;
import uk.ac.starlink.table.join.MatchKit;

public class CuboidCartesianMatchEngine
extends AbstractCartesianMatchEngine {
    private final int ndim_;
    private final double[] err2s_;
    private final DescribedValue[] matchParams_;
    private double scoreScale_;
    private static final ValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Unscaled distance between matched points");

    public CuboidCartesianMatchEngine(double[] errs) {
        super(errs.length);
        this.ndim_ = errs.length;
        this.err2s_ = new double[this.ndim_];
        this.matchParams_ = new DescribedValue[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            this.matchParams_[id] = new ErrorParameter(id);
            this.setScale(id, errs[id]);
        }
    }

    public void setError(int idim, double err) {
        this.setScale(idim, err);
    }

    public double getError(int idim) {
        return this.getScale(idim);
    }

    @Override
    protected void setScale(int idim, double err) {
        super.setScale(idim, err);
        this.err2s_[idim] = err * err;
        double sscale2 = 0.0;
        for (int i = 0; i < this.ndim_; ++i) {
            sscale2 += this.err2s_[i];
        }
        this.scoreScale_ = Math.sqrt(sscale2);
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        ValueInfo[] infos = new ValueInfo[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            infos[id] = this.createCoordinateInfo(id);
        }
        return infos;
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    @Override
    public Supplier<MatchKit> createMatchKitFactory() {
        Supplier<AbstractCartesianMatchEngine.CartesianBinner> binnerFact = this.createBinnerFactory();
        double[] err2s = (double[])this.err2s_.clone();
        return () -> new CuboidCartesianMatchKit(err2s, (AbstractCartesianMatchEngine.CartesianBinner)binnerFact.get());
    }

    @Override
    public Supplier<Coverage> createCoverageFactory() {
        double[] errs = new double[this.ndim_];
        for (int idim = 0; idim < this.ndim_; ++idim) {
            errs[idim] = this.getError(idim);
        }
        return () -> CuboidCoverage.createFixedCartesianCoverage(this.ndim_, errs);
    }

    @Override
    public double getScoreScale() {
        return this.scoreScale_;
    }

    @Override
    public String toString() {
        return this.ndim_ + "-d Cuboid";
    }

    private class ErrorParameter
    extends DescribedValue {
        private final int idim_;

        ErrorParameter(int idim) {
            super(new DefaultValueInfo("Error in " + CuboidCartesianMatchEngine.this.getCoordinateName(idim), Number.class, "Half length of cuboid in " + CuboidCartesianMatchEngine.this.getCoordinateDescription(idim) + " direction"));
            this.idim_ = idim;
        }

        @Override
        public Object getValue() {
            return CuboidCartesianMatchEngine.this.getError(this.idim_);
        }

        @Override
        public void setValue(Object value) {
            CuboidCartesianMatchEngine.this.setError(this.idim_, AbstractCartesianMatchEngine.getNumberValue(value));
        }
    }

    private static class CuboidCartesianMatchKit
    implements MatchKit {
        final double[] err2s_;
        final AbstractCartesianMatchEngine.CartesianBinner binner_;
        final int ndim_;
        final double[] work0_;
        final double[] work1_;
        final double[] work2_;

        CuboidCartesianMatchKit(double[] err2s, AbstractCartesianMatchEngine.CartesianBinner binner) {
            this.err2s_ = err2s;
            this.binner_ = binner;
            this.ndim_ = binner.getNdim();
            this.work0_ = new double[this.ndim_];
            this.work1_ = new double[this.ndim_];
            this.work2_ = new double[this.ndim_];
        }

        @Override
        public double matchScore(Object[] tuple1, Object[] tuple2) {
            this.binner_.toCoords(tuple1, this.work1_);
            this.binner_.toCoords(tuple2, this.work2_);
            double dist2 = 0.0;
            for (int id = 0; id < this.ndim_; ++id) {
                double d = this.work2_[id] - this.work1_[id];
                double d2 = d * d;
                if (d2 > this.err2s_[id]) {
                    return -1.0;
                }
                dist2 += d2;
            }
            return Math.sqrt(dist2);
        }

        @Override
        public Object[] getBins(Object[] tuple) {
            this.binner_.toCoords(tuple, this.work0_);
            return this.binner_.getScaleBins(this.work0_);
        }
    }
}

