/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.io.IOException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.join.ProgressIndicator;

public class ProgressRowSequence
extends WrapperRowSequence {
    private final double nrow_;
    private final ProgressIndicator indicator_;
    private final int blockSize_;
    private boolean closed;
    private long lrow_;
    private int iprog_;

    public ProgressRowSequence(StarTable table, ProgressIndicator indicator, String stage) throws IOException {
        super(table.getRowSequence());
        this.nrow_ = table.getRowCount();
        this.indicator_ = indicator;
        this.blockSize_ = 10000;
        this.indicator_.startStage(stage);
    }

    public boolean nextProgress() throws IOException, InterruptedException {
        if (this.next()) {
            if (++this.iprog_ >= this.blockSize_) {
                this.iprog_ = 0;
                if (this.nrow_ > 0.0) {
                    this.indicator_.setLevel((double)this.lrow_ / this.nrow_);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean next() throws IOException {
        if (super.next()) {
            ++this.lrow_;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (this.nrow_ > 0.0) {
                try {
                    this.indicator_.setLevel((double)this.lrow_ / this.nrow_);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.indicator_.endStage();
            this.closed = true;
        }
        super.close();
    }
}

