/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;

public class DefaultValueInfo
implements ValueInfo {
    private String name_;
    private String unitString_;
    private String ucd_;
    private String utype_;
    private String xtype_;
    private String description_;
    private Class<?> contentClass_;
    private DomainMapper[] domainMappers_;
    private boolean isNullable_;
    private int[] shape_;
    private int elementSize_;
    private List<DescribedValue> auxData_;
    private Function<String, ?> fromString_;
    private static Pattern trailDigits = Pattern.compile("\\.([0-9]+)$");
    private static Pattern trailSpaces = Pattern.compile("( +)$");

    public DefaultValueInfo() {
        this((String)null);
    }

    public DefaultValueInfo(String name) {
        this(name, Object.class);
    }

    public DefaultValueInfo(String name, Class<?> contentClass) {
        this(name, contentClass, "");
    }

    public DefaultValueInfo(String name, Class<?> contentClass, String description) {
        this.name_ = name;
        this.description_ = description;
        this.domainMappers_ = new DomainMapper[0];
        this.isNullable_ = true;
        this.shape_ = new int[]{-1};
        this.elementSize_ = -1;
        this.auxData_ = new ArrayList<DescribedValue>();
        this.configureContentClass(contentClass);
    }

    public DefaultValueInfo(ValueInfo base) {
        this(base.getName(), base.getContentClass(), base.getDescription());
        this.unitString_ = base.getUnitString();
        this.ucd_ = base.getUCD();
        this.utype_ = base.getUtype();
        this.xtype_ = base.getXtype();
        this.shape_ = base.getShape() == null ? null : (int[])base.getShape().clone();
        this.elementSize_ = base.getElementSize();
        this.isNullable_ = base.isNullable();
        this.domainMappers_ = base.getDomainMappers() == null ? null : (DomainMapper[])base.getDomainMappers().clone();
        this.auxData_ = new ArrayList<DescribedValue>(base.getAuxData());
    }

    public void setName(String name) {
        this.name_ = name;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    public void setUnitString(String unitString) {
        this.unitString_ = unitString;
    }

    @Override
    public String getUnitString() {
        return this.unitString_;
    }

    public void setUCD(String ucd) {
        this.ucd_ = ucd;
    }

    @Override
    public String getUCD() {
        return this.ucd_;
    }

    public void setUtype(String utype) {
        this.utype_ = utype;
    }

    @Override
    public String getUtype() {
        return this.utype_;
    }

    public void setXtype(String xtype) {
        this.xtype_ = xtype;
    }

    @Override
    public String getXtype() {
        return this.xtype_;
    }

    public void setDescription(String description) {
        this.description_ = description;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    @Override
    public Class<?> getContentClass() {
        return this.contentClass_;
    }

    public void setContentClass(Class<?> contentClass) {
        this.configureContentClass(contentClass);
    }

    private final void configureContentClass(Class<?> contentClass) {
        if (contentClass.isPrimitive()) {
            throw new IllegalArgumentException("Primitive content class " + contentClass + " not permitted");
        }
        this.contentClass_ = contentClass;
        if (!this.isArray()) {
            this.shape_ = null;
        } else if (this.shape_ == null) {
            this.shape_ = new int[]{-1};
        }
        this.fromString_ = DefaultValueInfo.createUnformatter(contentClass);
    }

    @Override
    public boolean isArray() {
        return this.contentClass_.isArray();
    }

    @Override
    public int[] getShape() {
        return this.shape_ == null ? null : (int[])this.shape_.clone();
    }

    public void setShape(int[] shape) {
        if (shape != null) {
            for (int i = 0; i < shape.length - 1; ++i) {
                if (shape[i] > 0) continue;
                throw new IllegalArgumentException("Bad shape");
            }
        }
        this.shape_ = shape;
    }

    @Override
    public int getElementSize() {
        return this.elementSize_;
    }

    public void setElementSize(int size) {
        this.elementSize_ = size;
    }

    @Override
    public boolean isNullable() {
        return this.isNullable_;
    }

    public void setNullable(boolean isNullable) {
        this.isNullable_ = isNullable;
    }

    @Override
    public DomainMapper[] getDomainMappers() {
        return this.domainMappers_;
    }

    public void setDomainMappers(DomainMapper[] domainMappers) {
        this.domainMappers_ = domainMappers;
    }

    @Override
    public List<DescribedValue> getAuxData() {
        return this.auxData_;
    }

    public void setAuxData(List<DescribedValue> auxData) {
        this.auxData_ = auxData;
    }

    public static ValueInfo generalise(ValueInfo vi1, ValueInfo vi2) {
        if (vi1.equals(vi2)) {
            return vi1;
        }
        DefaultValueInfo vi = new DefaultValueInfo(vi1){

            @Override
            public String formatValue(Object obj, int leng) {
                try {
                    return super.formatValue(obj, leng);
                }
                catch (RuntimeException e) {
                    String rep = String.valueOf(obj);
                    return rep.length() > leng ? rep.substring(0, leng) : rep;
                }
            }

            @Override
            public Object unformatString(String rep) {
                try {
                    return super.unformatString(rep);
                }
                catch (RuntimeException e) {
                    return null;
                }
            }
        };
        if (vi1.getUnitString() != null && !vi1.getUnitString().equals(vi2.getUnitString())) {
            vi.setUnitString(null);
        }
        if (vi1.getUCD() != null && !vi1.getUCD().equals(vi2.getUCD())) {
            vi.setUCD(null);
        }
        if (vi1.getDescription() != null && !vi1.getDescription().equals(vi2.getDescription())) {
            vi.setDescription("");
        }
        Class<?> c2 = vi2.getContentClass();
        vi.setContentClass(Object.class);
        for (Class<?> c1 = vi1.getContentClass(); c1 != null; c1 = c1.getSuperclass()) {
            if (!c1.isAssignableFrom(c2)) continue;
            vi.setContentClass(c1);
            break;
        }
        if (vi.isArray()) {
            int[] s1 = vi1.getShape();
            int[] s2 = vi2.getShape();
            if (s1 != null && s2 != null) {
                if (s1.length != s2.length) {
                    vi.setShape(new int[]{-1});
                } else {
                    int ndim = s1.length;
                    boolean same = true;
                    for (int i = 0; i < ndim - 1 && same; ++i) {
                        if (s1[i] == s2[i]) continue;
                        same = false;
                    }
                    if (same) {
                        if (ndim > 1 && s1[ndim - 1] != s2[ndim - 1]) {
                            s1[ndim - 1] = -1;
                        }
                        vi.setShape(s1);
                    } else {
                        vi.setShape(new int[]{-1});
                    }
                }
            }
        }
        if (vi1.isNullable() || vi2.isNullable()) {
            vi.setNullable(true);
        }
        return vi;
    }

    @Override
    public String formatValue(Object value, int maxLength) {
        int over;
        Matcher tmatch;
        if (maxLength <= 0) {
            return "";
        }
        if (Tables.isBlank(value)) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (!this.isArray()) {
            buf.append(value == null ? "" : value.toString());
        } else {
            int[] ashape = DefaultValueInfo.getActualShape(this.shape_, Array.getLength(value));
            DefaultValueInfo.appendElements(buf, value, 0, ashape, maxLength);
        }
        if (buf.length() > maxLength && (value instanceof Float || value instanceof Double) && (tmatch = trailDigits.matcher(buf)).find()) {
            over = buf.length() - maxLength;
            if (tmatch.group(1).length() > over) {
                buf.setLength(maxLength);
            }
        }
        if (buf.length() > maxLength && (tmatch = trailSpaces.matcher(buf)).lookingAt()) {
            over = buf.length() - maxLength;
            if (tmatch.group(1).length() > buf.length() - maxLength) {
                buf.setLength(maxLength);
            }
        }
        if (buf.length() > maxLength) {
            buf.setLength(Math.max(0, maxLength - 3));
            buf.append("...");
        }
        return buf.toString();
    }

    private static int appendElements(StringBuffer sb, Object array, int pos, int[] dims, int maxChars) {
        block7: {
            int leng = Array.getLength(array);
            int ndim = dims.length;
            int limit = dims[ndim - 1];
            if (sb.length() >= maxChars) break block7;
            sb.append('(');
            if (ndim == 1) {
                for (int i = 0; i < limit && sb.length() < maxChars; ++i) {
                    if (pos < leng) {
                        sb.append(Array.get(array, pos++));
                    }
                    if (i < limit - 1) {
                        sb.append(", ");
                        continue;
                    }
                    sb.append(")");
                }
            } else {
                int[] subdims = new int[ndim - 1];
                System.arraycopy(dims, 0, subdims, 0, ndim - 1);
                for (int i = 0; i < limit && sb.length() < maxChars; ++i) {
                    pos = DefaultValueInfo.appendElements(sb, array, pos, subdims, maxChars);
                    if (i < limit - 1) {
                        sb.append(", ");
                        continue;
                    }
                    sb.append(")");
                }
            }
        }
        return pos;
    }

    public static String formatClass(Class<?> clazz) {
        String basename;
        int ndim;
        block18: {
            int pos;
            String cname;
            block17: {
                cname = clazz.getName();
                pos = -1;
                ndim = 0;
                while (cname.charAt(++pos) == '[') {
                    ++ndim;
                }
                if (cname.length() != pos + 1) break block17;
                switch (cname.charAt(pos)) {
                    case 'B': {
                        basename = "byte";
                        break block18;
                    }
                    case 'C': {
                        basename = "char";
                        break block18;
                    }
                    case 'D': {
                        basename = "double";
                        break block18;
                    }
                    case 'F': {
                        basename = "float";
                        break block18;
                    }
                    case 'I': {
                        basename = "int";
                        break block18;
                    }
                    case 'J': {
                        basename = "long";
                        break block18;
                    }
                    case 'S': {
                        basename = "short";
                        break block18;
                    }
                    case 'Z': {
                        basename = "boolean";
                        break block18;
                    }
                    case 'V': {
                        basename = "void";
                        break block18;
                    }
                    default: {
                        throw new AssertionError((Object)("What class is " + cname + "??"));
                    }
                }
            }
            if (ndim == 0) {
                basename = cname;
            } else {
                assert (cname.charAt(pos) == 'L');
                assert (cname.charAt(cname.length() - 1) == ';');
                basename = cname.substring(pos + 1, cname.length() - 1);
            }
        }
        basename = basename.replaceFirst("^.*\\.", "");
        StringBuffer buf = new StringBuffer(basename);
        for (int i = 0; i < ndim; ++i) {
            buf.append("[]");
        }
        return buf.toString();
    }

    public static String formatShape(int[] shape) {
        if (shape == null || shape.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < shape.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            if (shape[i] <= 0) {
                buf.append('*');
                continue;
            }
            buf.append(shape[i]);
        }
        return buf.toString();
    }

    public static int[] unformatShape(String txt) {
        if (txt == null || txt.trim().length() == 0) {
            return null;
        }
        String[] els = txt.split(",", -1);
        int nel = els.length;
        int[] shape = new int[nel];
        for (int i = 0; i < nel; ++i) {
            String el = els[i].trim();
            try {
                shape[i] = i == nel - 1 && "*".equals(el) ? -1 : Integer.parseInt(el);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bad shape format: " + txt);
            }
        }
        return shape;
    }

    @Override
    public Object unformatString(String rep) {
        return rep == null || rep.length() == 0 ? null : this.fromString_.apply(rep);
    }

    public String toString() {
        StringBuffer typeRep = new StringBuffer();
        typeRep.append(DefaultValueInfo.formatClass(this.getContentClass()));
        int trlen = typeRep.length();
        if (typeRep.charAt(trlen - 2) == '[' && typeRep.charAt(trlen - 1) == ']') {
            typeRep.insert(trlen - 1, DefaultValueInfo.formatShape(this.getShape()));
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName()).append("(").append(typeRep).append(")");
        if (this.getUnitString() != null && this.getUnitString().trim().length() > 0) {
            buf.append("/").append(this.getUnitString().trim());
        }
        return buf.toString();
    }

    private static int[] getActualShape(int[] basicShape, int nel) {
        int ndim;
        int[] ashape = (int[])basicShape.clone();
        if (ashape[(ndim = ashape.length) - 1] <= 0) {
            int slice = 1;
            for (int i = 0; i < ndim - 1; ++i) {
                slice *= ashape[i];
            }
            ashape[ndim - 1] = (nel + slice - 1) / slice;
        }
        return ashape;
    }

    private static Function<String, ?> createUnformatter(Class<?> clazz) {
        if (Boolean.class.equals(clazz)) {
            return Boolean::valueOf;
        }
        if (Character.class.equals(clazz)) {
            return txt -> {
                if (txt.length() == 1) {
                    return Character.valueOf(txt.charAt(0));
                }
                if (txt.trim().length() == 1) {
                    return Character.valueOf(txt.trim().charAt(0));
                }
                throw new IllegalArgumentException("Not char");
            };
        }
        if (Byte.class.equals(clazz)) {
            return Byte::valueOf;
        }
        if (Short.class.equals(clazz)) {
            return Short::valueOf;
        }
        if (Integer.class.equals(clazz)) {
            return Integer::valueOf;
        }
        if (Long.class.equals(clazz)) {
            return Long::valueOf;
        }
        if (Float.class.equals(clazz)) {
            return Float::valueOf;
        }
        if (Double.class.equals(clazz)) {
            return Double::valueOf;
        }
        if (BigInteger.class.equals(clazz)) {
            return BigInteger::new;
        }
        if (BigDecimal.class.equals(clazz)) {
            return BigDecimal::new;
        }
        if (String.class.equals(clazz)) {
            return Function.identity();
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return Double::valueOf;
        }
        return txt -> {
            throw new UnsupportedOperationException("No unformatter available");
        };
    }
}

