/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import uk.ac.starlink.table.ProgressRowSplittable;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public class ProgressLineStarTable
extends WrapperStarTable {
    private static final char[] SPINNER = new char[]{'|', '/', '-', '\\'};
    private static final int INTERVAL = 500;
    private static final int INITIAL_WAIT = 500;
    private final PrintStream out_;

    public ProgressLineStarTable(StarTable baseTable, PrintStream out) {
        super(baseTable);
        this.out_ = out;
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        final ProgressShower ps = this.createProgressShower();
        return new WrapperRowSequence(this.baseTable.getRowSequence()){
            final Timer timer_;
            boolean started_;
            long irow_;
            {
                super(baseSeq);
                this.started_ = false;
                this.irow_ = 0L;
                this.timer_ = new Timer("progress", true);
                this.timer_.schedule(new TimerTask(){
                    long ir = -1L;

                    @Override
                    public void run() {
                        if (irow_ > this.ir) {
                            this.ir = irow_;
                            ProgressLineStarTable.this.out_.print(ps.getProgressLine(this.ir));
                            started_ = true;
                        }
                    }
                }, 500L, 500L);
            }

            @Override
            public boolean next() throws IOException {
                if (super.next()) {
                    ++this.irow_;
                    return true;
                }
                return false;
            }

            @Override
            public void close() throws IOException {
                this.timer_.cancel();
                if (this.started_) {
                    ProgressLineStarTable.this.out_.println(ps.getFinishedLine(this.irow_));
                }
                super.close();
            }
        };
    }

    @Override
    public RowSplittable getRowSplittable() throws IOException {
        final ProgressShower ps = this.createProgressShower();
        ProgressRowSplittable.Target target = new ProgressRowSplittable.Target(){
            final Timer timer_;
            boolean started_;
            final AtomicLong count_ = new AtomicLong();
            {
                this.timer_ = new Timer("progress", true);
                this.timer_.schedule(new TimerTask(){
                    long ir = -1L;

                    @Override
                    public void run() {
                        long c = count_.get();
                        if (c > this.ir) {
                            this.ir = c;
                            ProgressLineStarTable.this.out_.print(ps.getProgressLine(this.ir));
                            started_ = true;
                        }
                    }
                }, 500L, 500L);
            }

            @Override
            public void updateCount(long count) {
                this.count_.set(count);
            }

            @Override
            public void done(long count) {
                this.timer_.cancel();
                if (this.started_) {
                    ProgressLineStarTable.this.out_.print(ps.getProgressLine(count));
                }
            }
        };
        return new ProgressRowSplittable(this.baseTable.getRowSplittable(), target);
    }

    private ProgressShower createProgressShower() {
        long nrow = this.getRowCount();
        return nrow > 0L ? new DeterminateProgressShower(nrow) : new IndeterminateProgressShower();
    }

    private static class DeterminateProgressShower
    extends ProgressShower {
        int progCount = 0;
        final long nRow;
        final String nRowString;
        final int nDigit;

        DeterminateProgressShower(long nRow) {
            this.nRow = nRow;
            this.nRowString = Long.toString(nRow);
            this.nDigit = this.nRowString.length();
        }

        @Override
        String getProgressLine(long irow) {
            StringBuffer buf = new StringBuffer().append('\r').append(' ').append(SPINNER[this.progCount]).append(' ');
            this.progCount = (this.progCount + 1) % SPINNER.length;
            String rowCountString = Long.toString(irow);
            int pad = this.nDigit - rowCountString.length();
            for (int i = 0; i < pad; ++i) {
                buf.append(' ');
            }
            buf.append(rowCountString).append('/').append(this.nRowString).append(' ').append('|');
            int nLeft = 78 - buf.length();
            int nDone = (int)(irow * (long)nLeft / this.nRow);
            for (int i = 0; i < nLeft; ++i) {
                buf.append(i < nDone ? (char)'+' : ' ');
            }
            buf.append('|').append('\r');
            return buf.toString();
        }

        @Override
        String getFinishedLine(long irow) {
            StringBuffer buf = new StringBuffer(this.getProgressLine(irow));
            buf.setCharAt(2, ' ');
            return buf.toString();
        }
    }

    private static class IndeterminateProgressShower
    extends ProgressShower {
        int progCount;

        private IndeterminateProgressShower() {
        }

        @Override
        String getProgressLine(long irow) {
            StringBuffer buf = new StringBuffer().append('\r').append(SPINNER[this.progCount]).append(' ').append(irow).append('\r');
            this.progCount = (this.progCount + 1) % SPINNER.length;
            return buf.toString();
        }

        @Override
        String getFinishedLine(long irow) {
            return new StringBuffer().append('\r').append(' ').append(' ').append(irow).append(' ').append("(done)").append('\r').toString();
        }
    }

    private static abstract class ProgressShower {
        private ProgressShower() {
        }

        abstract String getProgressLine(long var1);

        abstract String getFinishedLine(long var1);
    }
}

