/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.logging.Logger;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.storage.AdaptiveByteStore;
import uk.ac.starlink.table.storage.ByteStoreStoragePolicy;
import uk.ac.starlink.table.storage.DiscardByteStore;
import uk.ac.starlink.table.storage.DiscardRowStore;
import uk.ac.starlink.table.storage.DiskRowStore;
import uk.ac.starlink.table.storage.FileByteStore;
import uk.ac.starlink.table.storage.ListRowStore;
import uk.ac.starlink.table.storage.MemoryByteStore;
import uk.ac.starlink.table.storage.SidewaysRowStore;
import uk.ac.starlink.util.Loader;

public abstract class StoragePolicy {
    private static StoragePolicy defaultInstance_;
    private static final Logger logger_;
    private static boolean defaultLogged_;
    private static final int MIN_DISK_CELLS = 1000;
    public static final String PREF_PROPERTY = "startable.storage";
    public static final StoragePolicy PREFER_MEMORY;
    public static final StoragePolicy PREFER_DISK;
    public static final StoragePolicy SIDEWAYS;
    public static final StoragePolicy DISCARD;
    public static final StoragePolicy ADAPTIVE;

    public static StoragePolicy getDefaultPolicy() {
        if (defaultInstance_ == null) {
            try {
                StoragePolicy named;
                String pref = System.getProperty(PREF_PROPERTY);
                defaultInstance_ = "adaptive".equals(pref) ? ADAPTIVE : ("memory".equals(pref) ? PREFER_MEMORY : ("disk".equals(pref) ? PREFER_DISK : ("sideways".equals(pref) ? SIDEWAYS : ("discard".equals(pref) ? DISCARD : ((named = Loader.getClassInstance(pref, StoragePolicy.class)) != null ? named : ADAPTIVE)))));
            }
            catch (SecurityException e) {
                defaultInstance_ = ADAPTIVE;
            }
        }
        if (!defaultLogged_) {
            defaultLogged_ = true;
            logger_.config("Initial default StoragePolicy is " + defaultInstance_);
        }
        return defaultInstance_;
    }

    public static void setDefaultPolicy(StoragePolicy policy) {
        defaultInstance_ = policy;
    }

    public abstract ByteStore makeByteStore();

    public abstract RowStore makeRowStore();

    public abstract RowStore makeConfiguredRowStore(StarTable var1);

    public StarTable randomTable(StarTable table) throws IOException {
        if (table.isRandom()) {
            return table;
        }
        return this.copyTable(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StarTable copyTable(StarTable table) throws IOException {
        RowStore store = this.makeConfiguredRowStore(table);
        try (RowSequence rseq = table.getRowSequence();){
            while (rseq.next()) {
                store.acceptRow(rseq.getRow());
            }
        }
        store.endRows();
        StarTable out = store.getStarTable();
        assert (out.isRandom());
        return out;
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.table.storage");
        PREFER_MEMORY = new StoragePolicy(){

            @Override
            public ByteStore makeByteStore() {
                return new MemoryByteStore();
            }

            @Override
            public RowStore makeRowStore() {
                return new ListRowStore();
            }

            @Override
            public RowStore makeConfiguredRowStore(StarTable meta) {
                ListRowStore store = new ListRowStore();
                store.acceptMetadata(meta);
                return store;
            }

            public String toString() {
                return "StoragePolicy.PREFER_MEMORY";
            }
        };
        PREFER_DISK = new DiskStoragePolicy("PREFER_DISK", 1000){

            @Override
            protected RowStore makeDiskRowStore() throws IOException {
                return new DiskRowStore();
            }
        };
        SIDEWAYS = new DiskStoragePolicy("SIDEWAYS", 1000){

            @Override
            protected RowStore makeDiskRowStore() throws IOException {
                return new SidewaysRowStore();
            }
        };
        DISCARD = new StoragePolicy(){

            @Override
            public ByteStore makeByteStore() {
                return new DiscardByteStore();
            }

            @Override
            public RowStore makeRowStore() {
                return new DiscardRowStore();
            }

            @Override
            public RowStore makeConfiguredRowStore(StarTable meta) {
                DiscardRowStore store = new DiscardRowStore();
                store.acceptMetadata(meta);
                return store;
            }

            public String toString() {
                return "StoragePolicy.DISCARD";
            }
        };
        ADAPTIVE = new ByteStoreStoragePolicy(){

            @Override
            protected ByteStore attemptMakeByteStore() throws IOException {
                return new AdaptiveByteStore();
            }

            public String toString() {
                return "StoragePolicy.ADAPTIVE";
            }
        };
    }

    private static abstract class DiskStoragePolicy
    extends StoragePolicy {
        private final String name_;

        DiskStoragePolicy(String name, int minDiskCells) {
            this.name_ = name;
        }

        protected abstract RowStore makeDiskRowStore() throws IOException;

        @Override
        public ByteStore makeByteStore() {
            Exception error;
            try {
                return new FileByteStore();
            }
            catch (SecurityException e) {
                error = e;
            }
            catch (IOException e) {
                error = e;
            }
            assert (error != null);
            logger_.warning("Failed to create disk storage: " + error + " - using memory instead");
            return new MemoryByteStore();
        }

        @Override
        public RowStore makeRowStore() {
            Exception error;
            try {
                return this.makeDiskRowStore();
            }
            catch (SecurityException e) {
                error = e;
            }
            catch (IOException e) {
                error = e;
            }
            assert (error != null);
            logger_.warning("Failed to create disk storage: " + error + " - using memory instead");
            return new ListRowStore();
        }

        @Override
        public RowStore makeConfiguredRowStore(StarTable meta) {
            long nrow = meta.getRowCount();
            if (nrow > 0L && nrow * (long)meta.getColumnCount() < 1000L) {
                ListRowStore store = new ListRowStore();
                store.acceptMetadata(meta);
                return store;
            }
            try {
                RowStore store = this.makeRowStore();
                store.acceptMetadata(meta);
                return store;
            }
            catch (TableFormatException e) {
                logger_.warning("Disk store " + this + " unsuitable for table: " + e + " - using memory instead");
                ListRowStore store = new ListRowStore();
                store.acceptMetadata(meta);
                return store;
            }
        }

        public String toString() {
            return "StoragePolicy." + this.name_;
        }
    }
}

