/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.LongSupplier;
import java.util.function.ToIntFunction;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.RandomRowSplittable;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowPermutedStarTable;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.SequentialRowSplittable;
import uk.ac.starlink.table.ShapeIterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.TableSorter;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.formats.TextTableWriter;

public class Tables {
    public static final ValueInfo NULL_VALUE_INFO = new DefaultValueInfo("NULL_VALUE", Object.class, "Integer value which represents a null");
    public static final ValueInfo UBYTE_FLAG_INFO = new DefaultValueInfo("UBYTE_FLAG", Boolean.class, "If true, data represents unsigned byte values");
    public static final ValueInfo QUERY_STATUS_INFO = new DefaultValueInfo("QUERY_STATUS", String.class, "Indicator of query status; anything other than OK means something wrong");
    public static final String PARSE_COUNT_MAY_BE_GIVEN = " may be given as a plain integer (<code>1000</code>),\nor with embedded underscores (<code>1_000</code>),\nor in exponential format (<code>1e3</code>).";
    public static final DefaultValueInfo RA_INFO = new DefaultValueInfo("RA", Number.class, "Right Ascension");
    public static final DefaultValueInfo DEC_INFO = new DefaultValueInfo("Dec", Number.class, "Declination");

    private Tables() {
    }

    public static StarTable randomTable(StarTable startab) throws IOException {
        return StoragePolicy.getDefaultPolicy().randomTable(startab);
    }

    public static ColumnInfo[] getColumnInfos(StarTable startab) {
        int ncol = startab.getColumnCount();
        ColumnInfo[] infos = new ColumnInfo[ncol];
        for (int i = 0; i < ncol; ++i) {
            infos[i] = startab.getColumnInfo(i);
        }
        return infos;
    }

    public static StarTable deleteColumn(StarTable startab, int icol) {
        int ncol = startab.getColumnCount();
        if (icol < 0 || icol >= ncol) {
            throw new IndexOutOfBoundsException("Deleted column " + icol + " out of range 0.." + (ncol - 1));
        }
        int[] colmap = new int[ncol - 1];
        int j = 0;
        for (int i = 0; i < ncol; ++i) {
            if (i == icol) continue;
            colmap[j++] = i;
        }
        assert (j == ncol - 1);
        return new ColumnPermutedStarTable(startab, colmap);
    }

    public static void streamStarTable(StarTable source, TableSink sink) throws IOException {
        sink.acceptMetadata(source);
        try (RowSequence rseq = source.getRowSequence();){
            while (rseq.next()) {
                sink.acceptRow(rseq.getRow());
            }
        }
        sink.endRows();
    }

    public static RowSplittable getDefaultRowSplittable(StarTable table) throws IOException {
        return table.isRandom() ? new RandomRowSplittable(table) : new SequentialRowSplittable(table);
    }

    public static void checkTable(StarTable table) throws IOException {
        boolean hasRowIndex;
        int formatChars = 100;
        int ncol = table.getColumnCount();
        long nrow = table.getRowCount();
        boolean isRandom = table.isRandom();
        if (isRandom) {
            Tables.assertTrue(nrow >= 0L);
            RowAccess racc = table.getRowAccess();
            Tables.assertTrue(racc != null);
            racc.close();
        }
        int[] nels = new int[ncol];
        Class[] classes = new Class[ncol];
        ColumnInfo[] colinfos = new ColumnInfo[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnInfo cinfo;
            colinfos[icol] = cinfo = table.getColumnInfo(icol);
            classes[icol] = cinfo.getContentClass();
            int[] dims = cinfo.getShape();
            if (dims != null) {
                int ndim = dims.length;
                Tables.assertTrue(ndim > 0);
                Tables.assertTrue(cinfo.getContentClass().isArray());
                int nel = 1;
                for (int i = 0; i < ndim; ++i) {
                    nel *= dims[i];
                    Tables.assertTrue(dims[i] != 0);
                    if (i >= ndim - 1) continue;
                    Tables.assertTrue(dims[i] > 0);
                }
                nels[icol] = nel;
            }
            Tables.assertTrue(cinfo.getContentClass().isArray() == cinfo.isArray());
        }
        RowSequence rseq = table.getRowSequence();
        try {
            rseq.getRow();
            Tables.assertTrue(false);
        }
        catch (IllegalStateException cinfo) {
            // empty catch block
        }
        long lrow = 0L;
        RowAccess racc = isRandom ? table.getRowAccess() : null;
        RowSplittable rsplit = table.getRowSplittable();
        RowSequence rseq2 = table.getRowSequence();
        while (rseq.next()) {
            boolean isEven = lrow % 2L == 0L;
            Tables.assertTrue(rsplit.next());
            Tables.assertTrue(rseq2.next());
            Object[] row = rseq.getRow();
            Object[] rowSplit = rsplit.getRow();
            Object[] row2 = isEven ? rseq2.getRow() : null;
            for (int icol = 0; icol < ncol; ++icol) {
                boolean isNull;
                Object val7;
                Object cell;
                Object val1 = cell = row[icol];
                Object val2 = rseq.getCell(icol);
                Object val3 = null;
                Object val4 = null;
                Object val5 = rowSplit[icol];
                Object val6 = rsplit.getCell(icol);
                Object object = val7 = isEven ? row2[icol] : null;
                if (isRandom) {
                    val3 = table.getCell(lrow, icol);
                    racc.setRowIndex(lrow);
                    val4 = racc.getCell(icol);
                }
                boolean bl = isNull = cell == null;
                if (isNull) {
                    Tables.assertTrue(colinfos[icol].isNullable());
                    Tables.assertTrue(val2 == null);
                    Tables.assertTrue(val5 == null);
                    Tables.assertTrue(val6 == null);
                    if (isRandom) {
                        Tables.assertTrue(val3 == null);
                        Tables.assertTrue(val4 == null);
                    }
                    if (isEven) {
                        Tables.assertTrue(val7 == null);
                    }
                } else {
                    ColumnInfo cinfo = colinfos[icol];
                    String s1 = cinfo.formatValue(val1, formatChars);
                    Tables.assertTrue(s1.equals(cinfo.formatValue(val2, formatChars)));
                    Tables.assertTrue(s1.equals(cinfo.formatValue(val5, formatChars)));
                    Tables.assertTrue(s1.equals(cinfo.formatValue(val6, formatChars)));
                    if (isRandom) {
                        Tables.assertTrue(s1.equals(cinfo.formatValue(val3, formatChars)));
                        Tables.assertTrue(s1.equals(cinfo.formatValue(val4, formatChars)));
                    }
                    if (isEven) {
                        Tables.assertTrue(s1.equals(cinfo.formatValue(val7, formatChars)));
                    }
                }
                if (cell != null && cell.getClass().isArray()) {
                    int nel = Array.getLength(cell);
                    if (nels[icol] < 0) {
                        Tables.assertTrue(nel % nels[icol] == 0);
                    } else {
                        Tables.assertTrue(nels[icol] == nel);
                    }
                }
                if (cell != null && !classes[icol].isAssignableFrom(cell.getClass())) {
                    throw new AssertionError((Object)("Column " + (icol + 1) + ": " + cell + " is a " + cell.getClass().getName() + " not a " + classes[icol].getName()));
                }
            }
            ++lrow;
        }
        rseq.close();
        Tables.assertTrue(!rsplit.next());
        rsplit.close();
        RowSplittable split1 = table.getRowSplittable();
        RowSplittable split2 = (RowSplittable)split1.split();
        LongSupplier rowIndex1 = split1.rowIndex();
        boolean bl = hasRowIndex = rowIndex1 != null;
        if (split2 != null) {
            LongSupplier rowIndex2 = split2.rowIndex();
            Tables.assertTrue(rowIndex2 != null == hasRowIndex);
            BitSet bits = hasRowIndex && nrow < Integer.MAX_VALUE ? new BitSet(nrow >= 0L ? (int)nrow : 1024) : null;
            int nr = 0;
            while (split2.next()) {
                ++nr;
                if (bits == null) continue;
                bits.set((int)rowIndex2.getAsLong());
            }
            while (split1.next()) {
                ++nr;
                if (bits == null) continue;
                bits.set((int)rowIndex1.getAsLong());
            }
            split2.close();
            if (nrow >= 0L) {
                Tables.assertTrue(nrow == (long)nr);
            }
            if (bits != null) {
                Tables.assertTrue(nr == bits.nextClearBit(0));
            }
        }
        split1.close();
        if (nrow >= 0L) {
            Tables.assertTrue(lrow == nrow);
        }
    }

    public static int checksumData(StarTable table) throws IOException {
        Adler32 checksum = new Adler32();
        Tables.checksumData(table, checksum);
        return (int)checksum.getValue();
    }

    public static long checksumData(StarTable table, Checksum checksum) throws IOException {
        long lrow = 0L;
        int ncol = table.getColumnCount();
        ToIntFunction[] hashers = new ToIntFunction[ncol];
        for (int ic = 0; ic < ncol; ++ic) {
            Class<?> clazz = table.getColumnInfo(ic).getContentClass();
            ToIntFunction<Object> hasher = clazz == boolean[].class ? a -> Arrays.hashCode((boolean[])a) : (clazz == byte[].class ? a -> Arrays.hashCode((byte[])a) : (clazz == short[].class ? a -> Arrays.hashCode((short[])a) : (clazz == int[].class ? a -> Arrays.hashCode((int[])a) : (clazz == long[].class ? a -> Arrays.hashCode((long[])a) : (clazz == char[].class ? a -> Arrays.hashCode((char[])a) : (clazz == float[].class ? a -> Arrays.hashCode((float[])a) : (clazz == double[].class ? a -> Arrays.hashCode((double[])a) : a -> a.hashCode())))))));
            hashers[ic] = hasher;
        }
        try (RowSequence rseq = table.getRowSequence();){
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                for (int ic = 0; ic < ncol; ++ic) {
                    Object cell = row[ic];
                    int hash = Tables.isBlank(cell) ? -654321 : hashers[ic].applyAsInt(cell);
                    checksum.update((byte)(hash >>> 24));
                    checksum.update((byte)(hash >>> 16));
                    checksum.update((byte)(hash >>> 8));
                    checksum.update((byte)(hash >>> 0));
                }
                ++lrow;
            }
        }
        return lrow;
    }

    public static boolean isBlank(Object value) {
        return value == null || value instanceof Float && ((Float)value).isNaN() || value instanceof Double && ((Double)value).isNaN() || value instanceof String && ((String)value).length() == 0 || value.getClass().isArray() && Array.getLength(value) == 0;
    }

    public static String collapseWhitespace(String txt) {
        return txt == null ? null : txt.trim().replaceAll("\\s+", " ");
    }

    public static TableSequence singleTableSequence(StarTable table) {
        return Tables.arrayTableSequence(new StarTable[]{table});
    }

    public static TableSequence arrayTableSequence(StarTable[] tables) {
        final Iterator<StarTable> it = Arrays.asList(tables).iterator();
        return new TableSequence(){

            @Override
            public StarTable nextTable() {
                return it.hasNext() ? (StarTable)it.next() : null;
            }
        };
    }

    public static StarTable[] tableArray(TableSequence tseq) throws IOException {
        StarTable table;
        ArrayList<StarTable> list = new ArrayList<StarTable>();
        while ((table = tseq.nextTable()) != null) {
            list.add(table);
        }
        return list.toArray(new StarTable[0]);
    }

    public static StarTable sortTable(StarTable table, int[] colIndices, boolean up, boolean nullsLast) throws IOException {
        long[] rowMap = TableSorter.getSortedOrder(table, colIndices, up, nullsLast);
        return new RowPermutedStarTable(table, rowMap);
    }

    public static String tableToString(StarTable table, String ofmt) {
        StarTableWriter handler;
        if (ofmt != null) {
            try {
                handler = new StarTableOutput().getHandler(ofmt);
            }
            catch (TableFormatException e) {
                throw new IllegalArgumentException("No such format \"" + ofmt + "\"", e);
            }
        } else {
            TextTableWriter textHandler = new TextTableWriter();
            textHandler.setWriteParameters(false);
            textHandler.setMaxWidth(40);
            handler = textHandler;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            handler.writeStarTable(table, out);
            out.close();
            return new String(out.toByteArray(), "utf-8");
        }
        catch (IOException e) {
            return "Formatting error: " + e;
        }
    }

    public static int checkedLongToInt(long lval) {
        int ival = (int)lval;
        if ((long)ival == lval) {
            return ival;
        }
        if (ival < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Out of supported range: " + ival + " < Integer.MIN_VALUE");
        }
        if (ival > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Out of supported range: " + ival + " > Integer.MAX_VALUE");
        }
        throw new AssertionError();
    }

    public static int assertLongToInt(long lval) {
        int ival = (int)lval;
        assert ((long)ival == lval) : "Long value " + lval + " unexpectedly out of int range";
        return ival;
    }

    public static String[] getElementLabels(int[] shape) {
        if (shape == null || shape.length == 0) {
            return null;
        }
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] > 0) continue;
            return null;
        }
        ArrayList<String> labels = new ArrayList<String>();
        ShapeIterator it = new ShapeIterator(shape);
        while (it.hasNext()) {
            int[] pos = (int[])it.next();
            StringBuffer sbuf = new StringBuffer();
            for (int i = 0; i < pos.length; ++i) {
                sbuf.append('_').append(Integer.toString(pos[i] + 1));
            }
            labels.add(sbuf.toString());
        }
        return labels.toArray(new String[0]);
    }

    @Deprecated
    public static String getUtype(ValueInfo info) {
        return info.getUtype();
    }

    @Deprecated
    public static void setUtype(ValueInfo info, String utype) {
        if (info instanceof DefaultValueInfo) {
            ((DefaultValueInfo)info).setUtype(utype);
        }
    }

    @Deprecated
    public static String getXtype(ValueInfo info) {
        return info.getXtype();
    }

    @Deprecated
    public static void setXtype(ValueInfo info, String xtype) {
        if (info instanceof DefaultValueInfo) {
            ((DefaultValueInfo)info).setXtype(xtype);
        }
    }

    public static void setDescribedValue(Collection<DescribedValue> dvals, DescribedValue dval) {
        DescribedValue old = Tables.getDescribedValueByName(dvals, dval.getInfo().getName());
        if (old != null) {
            dvals.remove(old);
        }
        dvals.add(dval);
    }

    public static DescribedValue getDescribedValueByName(Collection<DescribedValue> dvals, String name) {
        for (DescribedValue dval : dvals) {
            if (!name.equals(dval.getInfo().getName())) continue;
            return dval;
        }
        return null;
    }

    public static <T> T getAuxDatumValue(ValueInfo info, ValueInfo auxKey, Class<T> auxClazz) {
        return Tables.getTypedValue(info.getAuxDatumByName(auxKey.getName()), auxClazz);
    }

    public static <T> T getTypedValue(DescribedValue dval, Class<T> clazz) {
        return dval == null ? null : (T)dval.getTypedValue(clazz);
    }

    public static Object getValue(Collection<DescribedValue> dvals, ValueInfo info) {
        String iname = info.getName();
        Class<?> iclazz = info.getContentClass();
        if (iname != null && iclazz != null) {
            for (DescribedValue dval : dvals) {
                ValueInfo dinfo = dval.getInfo();
                if (!iname.equals(dinfo.getName()) || !iclazz.equals(dinfo.getContentClass())) continue;
                return dval.getValue();
            }
        }
        return null;
    }

    public static void fixColumns(ColumnInfo[][] infoLists, JoinFixAction[] fixActs) {
        int nt = infoLists.length;
        if (fixActs.length != nt) {
            throw new IllegalArgumentException();
        }
        int maxNc = 0;
        for (int it = 0; it < nt; ++it) {
            maxNc = Math.max(infoLists[it].length, maxNc);
        }
        String[] names = new String[maxNc * nt];
        for (int it = 0; it < nt; ++it) {
            ColumnInfo[] infos = infoLists[it];
            for (int ic = 0; ic < infos.length; ++ic) {
                int ix = it * maxNc + ic;
                names[ix] = infos[ic].getName();
            }
        }
        ArrayList<String> nameList = new ArrayList<String>(Arrays.asList(names));
        for (int it = 0; it < nt; ++it) {
            ColumnInfo[] infos = infoLists[it];
            JoinFixAction fixAct = fixActs[it];
            for (int ic = 0; ic < infos.length; ++ic) {
                int ix = it * maxNc + ic;
                String origName = (String)nameList.remove(ix);
                assert (origName.equals(infos[ic].getName()));
                String name = fixAct.getFixedName(origName, nameList);
                nameList.add(ix, origName);
                if (name.equals(origName)) continue;
                nameList.add(name);
                infos[ic].setName(name);
            }
        }
    }

    public static long parseCount(String countTxt) {
        double d;
        long l;
        if ((countTxt = countTxt.trim()).startsWith("0x")) {
            return Long.parseLong(countTxt.substring(2).replaceAll("_", ""), 16);
        }
        if (countTxt.matches("[0-9]+")) {
            return Long.parseLong(countTxt);
        }
        if (countTxt.matches("[0-9_]+")) {
            return Long.parseLong(countTxt.replaceAll("_", ""));
        }
        if (countTxt.matches("[0-9.]+[eE][+]?[0-9]+") && (double)(l = (long)(d = Double.parseDouble(countTxt))) == d) {
            return l;
        }
        String msg = "Can't be interpreted as non-negative integer: " + countTxt;
        throw new NumberFormatException(msg);
    }

    private static void assertTrue(boolean ok) {
        if (!ok) {
            throw new AssertionError();
        }
    }

    static {
        RA_INFO.setUnitString("radians");
        DEC_INFO.setUnitString("radians");
        RA_INFO.setNullable(false);
        DEC_INFO.setNullable(false);
        RA_INFO.setUCD("POS_EQ_RA");
        DEC_INFO.setUCD("POS_EQ_DEC");
    }
}

