/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.formats.RowEvaluator;
import uk.ac.starlink.table.formats.StreamStarTable;
import uk.ac.starlink.util.DataSource;

public class AsciiStarTable
extends StreamStarTable {
    private final int maxSample_;
    private final RowEvaluator.Decoder<?>[] decoders_;
    private List<String> comments_;
    private boolean dataStarted_;

    public AsciiStarTable(DataSource datsrc) throws TableFormatException, IOException {
        this(datsrc, 0, RowEvaluator.getStandardDecoders());
    }

    public AsciiStarTable(DataSource datsrc, int maxSample, RowEvaluator.Decoder<?>[] decoders) throws TableFormatException, IOException {
        this.maxSample_ = maxSample;
        this.decoders_ = decoders;
        this.init(datsrc);
    }

    @Override
    protected RowEvaluator.Metadata obtainMetadata() throws TableFormatException, IOException {
        long lrow;
        PushbackInputStream in = this.getInputStream();
        RowEvaluator evaluator = new RowEvaluator(this.decoders_);
        this.comments_ = new ArrayList<String>();
        try {
            List<String> row;
            for (lrow = 0L; (row = this.readRow(in)) != null && (this.maxSample_ <= 0 || lrow < (long)this.maxSample_); ++lrow) {
                evaluator.submitRow(row);
            }
        }
        catch (TableFormatException e) {
            throw new TableFormatException(e.getMessage() + " at row " + lrow, e);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        boolean isSampleLimited = this.maxSample_ > 0 && lrow >= (long)this.maxSample_;
        RowEvaluator.Metadata meta = evaluator.getMetadata();
        if (meta.nrow_ == 0L) {
            throw new TableFormatException("No rows");
        }
        this.interpretComments(meta.colInfos_);
        this.comments_ = null;
        return new RowEvaluator.Metadata(meta.colInfos_, meta.decoders_, isSampleLimited ? -1L : meta.nrow_);
    }

    private void interpretComments(ColumnInfo[] colInfos) throws IOException {
        String hline;
        List<String> headings;
        AsciiStarTable.trimLines(this.comments_);
        int ncol = colInfos.length;
        if (this.comments_.size() > 0 && (headings = this.readHeadings(new PushbackInputStream(new ByteArrayInputStream((hline = this.comments_.get(this.comments_.size() - 1)).getBytes())))).size() == ncol) {
            this.comments_.remove(this.comments_.size() - 1);
            for (int i = 0; i < ncol; ++i) {
                colInfos[i].setName(headings.get(i));
            }
            AsciiStarTable.trimLines(this.comments_);
        }
        if (this.comments_.size() > 0) {
            StringBuffer dbuf = new StringBuffer();
            Iterator<String> it = this.comments_.iterator();
            while (it.hasNext()) {
                dbuf.append(it.next());
                if (!it.hasNext()) continue;
                dbuf.append('\n');
            }
            DefaultValueInfo descriptionInfo = new DefaultValueInfo("Description", String.class, "Comments included in text file");
            this.getParameters().add(new DescribedValue(descriptionInfo, dbuf.toString()));
        }
    }

    @Override
    protected List<String> readRow(PushbackInputStream in) throws IOException {
        ArrayList<String> cellList = new ArrayList<String>();
        while (cellList.size() == 0) {
            boolean startLine = true;
            boolean endLine = false;
            while (!endLine) {
                int c = in.read();
                switch ((char)c) {
                    case '\uffff': {
                        if (cellList.size() == 0) {
                            return null;
                        }
                        endLine = true;
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if (cellList.size() == 0) break;
                        endLine = true;
                        break;
                    }
                    case '#': {
                        if (!this.dataStarted_) {
                            this.comments_.add(this.eatLine(in));
                        } else {
                            this.eatLine(in);
                        }
                        endLine = true;
                        break;
                    }
                    case '\t': 
                    case ' ': {
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        in.unread(c);
                        cellList.add(this.readString(in));
                        break;
                    }
                    case '!': {
                        if (startLine) {
                            if (!this.dataStarted_) {
                                this.comments_.add(this.eatLine(in));
                            } else {
                                this.eatLine(in);
                            }
                            endLine = true;
                            break;
                        }
                    }
                    default: {
                        in.unread(c);
                        String tok = this.readToken(in);
                        cellList.add("null".equals(tok) ? "" : tok);
                    }
                }
                startLine = false;
            }
        }
        this.dataStarted_ = true;
        return cellList;
    }

    private String eatLine(InputStream stream) throws IOException {
        StringBuffer buffer = new StringBuffer();
        boolean done = false;
        block3: while (!done) {
            int c = stream.read();
            switch ((char)c) {
                case '\n': 
                case '\r': 
                case '\uffff': {
                    done = true;
                    continue block3;
                }
            }
            buffer.append((char)c);
        }
        return buffer.toString();
    }

    private String readString(InputStream stream) throws IOException {
        int c;
        char delimiter = (char)stream.read();
        StringBuffer buffer = new StringBuffer();
        block5: while ((c = stream.read()) != delimiter) {
            switch ((char)c) {
                case '\n': 
                case '\r': {
                    throw new TableFormatException("End of line within a string literal");
                }
                case '\\': {
                    buffer.append((char)stream.read());
                    continue block5;
                }
                case '\uffff': {
                    throw new TableFormatException("End of file within a string literal");
                }
            }
            buffer.append((char)c);
        }
        return buffer.toString();
    }

    private String readToken(PushbackInputStream stream) throws IOException {
        StringBuffer buffer = new StringBuffer();
        boolean done = false;
        block4: while (!done) {
            int c = stream.read();
            switch ((char)c) {
                case '\n': 
                case '\r': {
                    stream.unread(c);
                    done = true;
                    continue block4;
                }
                case '\t': 
                case ' ': 
                case '\uffff': {
                    done = true;
                    continue block4;
                }
            }
            buffer.append((char)c);
        }
        return buffer.toString();
    }

    private List<String> readHeadings(PushbackInputStream stream) throws IOException {
        ArrayList<String> headings = new ArrayList<String>();
        boolean done = false;
        block6: while (!done) {
            int c = stream.read();
            switch ((char)c) {
                case '\n': 
                case '\r': {
                    done = true;
                    continue block6;
                }
                case '\t': 
                case ' ': {
                    continue block6;
                }
                case '\"': 
                case '\'': {
                    stream.unread(c);
                    headings.add(this.readString(stream));
                    continue block6;
                }
                case '\uffff': {
                    done = true;
                    continue block6;
                }
            }
            stream.unread(c);
            headings.add(this.readToken(stream));
        }
        return headings;
    }

    private static void trimLines(List<String> lines) {
        String line;
        ListIterator<String> it = lines.listIterator(0);
        while (it.hasNext() && (line = it.next()).trim().length() == 0) {
            it.remove();
        }
        it = lines.listIterator(lines.size());
        while (it.hasPrevious() && (line = it.previous()).trim().length() == 0) {
            it.remove();
        }
    }
}

