/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.MultiStarTableWriter;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.formats.DocumentedStreamStarTableWriter;
import uk.ac.starlink.util.ConfigMethod;
import uk.ac.starlink.util.URLUtils;

public class HTMLTableWriter
extends DocumentedStreamStarTableWriter
implements MultiStarTableWriter {
    private boolean standalone_;
    private boolean useRowGroups_;
    private int maxWidth_;
    private static final int DFLT_MAX_WIDTH = 200;

    public HTMLTableWriter() {
        this(false, true);
    }

    public HTMLTableWriter(boolean standalone, boolean useRowGroups) {
        super(new String[]{"html", "htm"});
        this.setStandalone(standalone);
        this.useRowGroups_ = useRowGroups;
        this.maxWidth_ = 200;
    }

    @ConfigMethod(property="standalone", doc="If true, the output is a freestanding HTML document complete with HTML, HEAD and BODY tags. If false, the output is just a TABLE element.")
    public void setStandalone(boolean standalone) {
        this.standalone_ = standalone;
    }

    public boolean isStandalone() {
        return this.standalone_;
    }

    @ConfigMethod(property="maxCell", doc="Maximum width in characters of an output table cell. Cells longer than this will be truncated.")
    public void setMaxWidth(int maxWidth) {
        this.maxWidth_ = maxWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth_;
    }

    @Override
    public String getFormatName() {
        return "HTML";
    }

    @Override
    public String getMimeType() {
        return "text/html";
    }

    @Override
    public boolean docIncludesExample() {
        return true;
    }

    @Override
    public String getXmlDescription() {
        return String.join((CharSequence)"\n", "<p>Writes a basic HTML <code>TABLE</code> element", "suitable for use as a web page or for insertion into one.", "</p>", "");
    }

    @Override
    public void writeStarTable(StarTable table, OutputStream out) throws IOException {
        if (this.standalone_) {
            this.printHeader(out, table);
        }
        this.writeTableElement(table, out);
        if (this.standalone_) {
            this.printFooter(out);
        }
    }

    @Override
    public void writeStarTables(TableSequence tableSeq, OutputStream out) throws IOException {
        StarTable table;
        if (this.standalone_) {
            this.printHeader(out, null);
        }
        while ((table = tableSeq.nextTable()) != null) {
            this.printLine(out, "<P>");
            this.writeTableElement(table, out);
            this.printLine(out, "</P>");
        }
        if (this.standalone_) {
            this.printFooter(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStarTables(TableSequence tableSeq, String location, StarTableOutput sto) throws IOException {
        try (OutputStream out = sto.getOutputStream(location);){
            out = new BufferedOutputStream(out);
            this.writeStarTables(tableSeq, out);
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTableElement(StarTable table, OutputStream ostrm) throws IOException {
        try (RowSequence rseq = table.getRowSequence();){
            String unit;
            this.printLine(ostrm, "<TABLE BORDER='1'>");
            String tname = table.getName();
            if (tname != null) {
                this.printLine(ostrm, "<CAPTION><STRONG>" + tname + "</STRONG></CAPTION>");
            }
            int ncol = table.getColumnCount();
            ColumnInfo[] colinfos = Tables.getColumnInfos(table);
            String[] names = new String[ncol];
            String[] units = new String[ncol];
            boolean hasUnits = false;
            for (int icol = 0; icol < ncol; ++icol) {
                ColumnInfo colinfo = colinfos[icol];
                String name = colinfo.getName();
                unit = colinfo.getUnitString();
                if (unit != null) {
                    hasUnits = true;
                    unit = "(" + unit + ")";
                }
                names[icol] = name;
                units[icol] = unit;
            }
            String[] headings = new String[ncol];
            for (int icol = 0; icol < ncol; ++icol) {
                String heading = names[icol];
                unit = units[icol];
                if (hasUnits) {
                    heading = heading + "<BR>";
                    if (unit != null) {
                        heading = heading + "(" + unit + ")";
                    }
                }
                headings[icol] = heading;
            }
            if (this.useRowGroups_) {
                this.printLine(ostrm, "<THEAD>");
            }
            this.outputRow(ostrm, "TH", null, names);
            if (hasUnits) {
                this.outputRow(ostrm, "TH", null, units);
            }
            this.printLine(ostrm, "<TR><TD colspan='" + ncol + "'></TD></TR>");
            if (this.useRowGroups_) {
                this.printLine(ostrm, "</THEAD>");
            }
            if (this.useRowGroups_) {
                this.printLine(ostrm, "<TBODY>");
            }
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                String[] cells = new String[ncol];
                for (int icol = 0; icol < ncol; ++icol) {
                    cells[icol] = colinfos[icol].formatValue(row[icol], this.getMaxWidth());
                }
                this.outputRow(ostrm, "TD", null, cells);
            }
            if (this.useRowGroups_) {
                this.printLine(ostrm, "</TBODY>");
            }
            this.printLine(ostrm, "</TABLE>");
        }
    }

    private void outputRow(OutputStream ostrm, String tagname, String attlist, String[] values) throws IOException {
        int ncol = values.length;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<TR>");
        for (int icol = 0; icol < ncol; ++icol) {
            String value;
            sbuf.append(' ').append('<').append(tagname);
            if (attlist != null) {
                sbuf.append(" " + attlist);
            }
            sbuf.append('>');
            String string = value = values[icol] == null ? null : this.escape(values[icol]);
            if (value == null || value.length() == 0) {
                sbuf.append("&nbsp;");
            } else if (this.isUrl(value)) {
                sbuf.append("<A href='").append(value).append("'>").append(value).append("</A>");
            } else {
                sbuf.append(value);
            }
            sbuf.append("</").append(tagname).append(">");
        }
        sbuf.append("</TR>");
        this.printLine(ostrm, sbuf.toString());
    }

    private void printLine(OutputStream ostrm, String str) throws IOException {
        ostrm.write(str.getBytes());
        ostrm.write(10);
    }

    protected void printHeader(OutputStream ostrm, StarTable table) throws IOException {
        String tname;
        String publicId = this.useRowGroups_ ? "-//W3C//DTD HTML 4.01 Transitional//EN" : "-//W3C//DTD HTML 3.2 Final//EN";
        String declaration = "<!DOCTYPE HTML PUBLIC \"" + publicId + "\">";
        this.printLine(ostrm, declaration);
        this.printLine(ostrm, "<HTML>");
        String string = tname = table == null ? null : table.getName();
        if (tname != null && tname.trim().length() > 0) {
            this.printLine(ostrm, "<HEAD><TITLE>Table " + this.escape(tname) + "</TITLE></HEAD>");
        }
        this.printLine(ostrm, "<BODY>");
    }

    protected void printFooter(OutputStream ostrm) throws IOException {
        this.printLine(ostrm, "</BODY>");
        this.printLine(ostrm, "</HTML>");
    }

    private String escape(String line) {
        StringBuffer sbuf = new StringBuffer();
        block7: for (int i = 0; i < line.length(); ++i) {
            char chr = line.charAt(i);
            switch (chr) {
                case '&': {
                    sbuf.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sbuf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sbuf.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sbuf.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sbuf.append("&apos;");
                    continue block7;
                }
                default: {
                    sbuf.append(chr > '\u0000' && chr < '\u00fe' ? chr : (char)'?');
                }
            }
        }
        return sbuf.toString();
    }

    protected boolean isUrl(String txt) {
        if (txt.startsWith("http:") || txt.startsWith("https:") || txt.startsWith("ftp:") || txt.startsWith("mailto:")) {
            try {
                URLUtils.newURL(txt);
                return true;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return false;
    }
}

