/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import uk.ac.starlink.table.storage.ByteStoreAccess;
import uk.ac.starlink.table.storage.ByteStoreColumnReader;
import uk.ac.starlink.table.storage.Codec;
import uk.ac.starlink.table.storage.ColumnReader;
import uk.ac.starlink.table.storage.ColumnStore;
import uk.ac.starlink.table.storage.FileByteStore;
import uk.ac.starlink.table.storage.NioByteStoreAccess;
import uk.ac.starlink.util.DataBufferedOutputStream;

public class StreamColumnStore
implements ColumnStore {
    private final Codec codec_;
    private final File dataFile_;
    private final DataBufferedOutputStream dataOut_;
    private final int itemSize_;
    private long nrow_;
    private ByteBuffer[] bbufs_;

    public StreamColumnStore(Codec codec, File dataFile) throws IOException {
        this.codec_ = codec;
        this.dataFile_ = dataFile;
        this.itemSize_ = codec.getItemSize();
        if (this.itemSize_ < 0) {
            throw new IllegalArgumentException("Must have fixed size codec");
        }
        this.dataOut_ = new DataBufferedOutputStream(new FileOutputStream(dataFile));
    }

    @Override
    public void acceptCell(Object value) throws IOException {
        int nbyte = this.codec_.encode(value, this.dataOut_);
        assert (nbyte == this.itemSize_);
        ++this.nrow_;
    }

    @Override
    public void endCells() throws IOException {
        this.dataOut_.close();
        this.bbufs_ = FileByteStore.toByteBuffers(this.dataFile_);
    }

    @Override
    public ColumnReader createReader() {
        ByteStoreAccess access = NioByteStoreAccess.createAccess(NioByteStoreAccess.copyBuffers(this.bbufs_));
        return new ByteStoreColumnReader(this.codec_, access, this.nrow_){

            @Override
            public long getAccessOffset(long ix) {
                return ix * (long)StreamColumnStore.this.itemSize_;
            }
        };
    }
}

