/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.tfcat;

import uk.ac.starlink.tfcat.Position;

public class Bbox {
    private final double tmin_;
    private final double smin_;
    private final double tmax_;
    private final double smax_;

    public Bbox(double tmin, double smin, double tmax, double smax) {
        this.tmin_ = tmin;
        this.smin_ = smin;
        this.tmax_ = tmax;
        this.smax_ = smax;
    }

    public double getTimeMin() {
        return this.tmin_;
    }

    public double getSpectralMin() {
        return this.smin_;
    }

    public double getTimeMax() {
        return this.tmax_;
    }

    public double getSpectralMax() {
        return this.smax_;
    }

    public boolean isInside(Position pos) {
        double t = pos.getTime();
        double s = pos.getSpectral();
        return t >= this.tmin_ && t <= this.tmax_ && s >= this.smin_ && s <= this.smax_;
    }

    public String toString() {
        return new StringBuffer().append("[").append(this.tmin_).append(", ").append(this.smin_).append(", ").append(this.tmax_).append(", ").append(this.smax_).append("]").toString();
    }
}

