/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.auth.AuthManager;
import uk.ac.starlink.auth.UserInterface;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableScheme;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.plot2.task.TypedPlot2Task;
import uk.ac.starlink.ttools.scheme.AttractorScheme;
import uk.ac.starlink.ttools.scheme.SkySimScheme;
import uk.ac.starlink.ttools.task.LineInvoker;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.util.Loader;
import uk.ac.starlink.util.ObjectFactory;
import uk.ac.starlink.util.Pair;
import uk.ac.starlink.util.URLUtils;

public class Stilts {
    private static ObjectFactory<Task> taskFactory_;
    private static ObjectFactory<TypedPlot2Task<?, ?>> plot2TaskFactory_;
    private static ObjectFactory<ProcessingMode> modeFactory_;
    private static TableScheme[] stdSchemes_;
    private static final Logger logger_;
    public static final String VERSION_RESOURCE = "stilts.version";

    public static void main(String[] args) {
        Loader.loadProperties();
        Loader.setHttpAgent((String)("STILTS/" + Stilts.getVersion()));
        Loader.setDefaultProperty((String)"java.awt.Window.locationByPlatform", (String)"true");
        LineInvoker invoker = new LineInvoker("stilts", taskFactory_);
        int status = invoker.invoke(args, new Runnable(){

            @Override
            public void run() {
                URLUtils.installCustomHandlers();
                AuthManager.getInstance().setUserInterface(Stilts.getAuthUi());
            }
        });
        if (status != 0) {
            System.exit(status);
        }
    }

    public static ObjectFactory<ProcessingMode> getModeFactory() {
        return modeFactory_;
    }

    public static ObjectFactory<Task> getTaskFactory() {
        return taskFactory_;
    }

    public static ObjectFactory<TypedPlot2Task<?, ?>> getPlot2TaskFactory() {
        return plot2TaskFactory_;
    }

    public static TableScheme[] getStandardSchemes() {
        return (TableScheme[])stdSchemes_.clone();
    }

    public static void addStandardSchemes(StarTableFactory tfact) {
        for (TableScheme scheme : stdSchemes_) {
            tfact.addScheme(scheme);
        }
    }

    public static String getVersion() {
        return IOUtils.getResourceContents(Stilts.class, (String)VERSION_RESOURCE, null);
    }

    public static String getStarjavaRevision() {
        return IOUtils.getResourceContents(Stilts.class, (String)"revision-string", (Level)Level.CONFIG);
    }

    private static UserInterface getAuthUi() {
        UserInterface propsUi = UserInterface.getPropertiesUi();
        if (propsUi != null) {
            String user = System.getProperty("auth.username");
            if (user != null && user.trim().length() > 0) {
                logger_.warning("Automatic system-property-based authentication for user " + user);
            }
            return propsUi;
        }
        return UserInterface.CLI;
    }

    private static void init() {
        ObjectFactory p2fact;
        taskFactory_ = new ObjectFactory(Task.class);
        plot2TaskFactory_ = p2fact = new ObjectFactory(TypedPlot2Task.class);
        String taskPkg = "uk.ac.starlink.ttools.task.";
        taskFactory_.register("arrayjoin", taskPkg + "ArrayJoin");
        taskFactory_.register("calc", taskPkg + "Calc");
        taskFactory_.register("cdsskymatch", taskPkg + "CdsUploadSkyMatch");
        taskFactory_.register("cone", taskPkg + "TableCone");
        taskFactory_.register("coneskymatch", taskPkg + "MultiCone");
        taskFactory_.register("datalinklint", taskPkg + "DatalinkLint");
        taskFactory_.register("funcs", taskPkg + "ShowFunctions");
        taskFactory_.register("mocshape", taskPkg + "MocShape");
        taskFactory_.register("parqlint", taskPkg + "VOParquetLint");
        taskFactory_.register("parqlook", taskPkg + "ParquetTool");
        taskFactory_.register("pixfoot", taskPkg + "PixFootprint");
        taskFactory_.register("pixsample", taskPkg + "PixSample");
        taskFactory_.register("plot2d", taskPkg + "TablePlot2D");
        taskFactory_.register("plot3d", taskPkg + "TablePlot3D");
        taskFactory_.register("plothist", taskPkg + "TableHistogram");
        taskFactory_.register("regquery", taskPkg + "RegQuery");
        taskFactory_.register("server", taskPkg + "StiltsServer");
        taskFactory_.register("sqlclient", taskPkg + "SqlClient");
        taskFactory_.register("sqlskymatch", taskPkg + "SqlCone");
        taskFactory_.register("sqlupdate", taskPkg + "SqlUpdate");
        taskFactory_.register("taplint", taskPkg + "TapLint");
        taskFactory_.register("tapquery", taskPkg + "TapQuerier");
        taskFactory_.register("tapresume", taskPkg + "TapResume");
        taskFactory_.register("tapskymatch", taskPkg + "TapUploadSkyMatch");
        taskFactory_.register("tcat", taskPkg + "TableCat");
        taskFactory_.register("tcatn", taskPkg + "TableCatN");
        taskFactory_.register("tcopy", taskPkg + "TableCopy");
        taskFactory_.register("tcube", taskPkg + "TableCube");
        taskFactory_.register("tgridmap", taskPkg + "GridDensityMap");
        taskFactory_.register("tgroup", taskPkg + "TableGroup");
        taskFactory_.register("tjoin", taskPkg + "TableJoinN");
        taskFactory_.register("tloop", taskPkg + "TableLoop");
        taskFactory_.register("tmatch1", taskPkg + "TableMatch1");
        taskFactory_.register("tmatch2", taskPkg + "TableMatch2");
        taskFactory_.register("tmatchn", taskPkg + "TableMatchN");
        taskFactory_.register("tmulti", taskPkg + "MultiCopy");
        taskFactory_.register("tmultin", taskPkg + "MultiCopyN");
        taskFactory_.register("tpipe", taskPkg + "TablePipe");
        taskFactory_.register("tskymap", taskPkg + "SkyDensityMap");
        taskFactory_.register("tskymatch2", taskPkg + "SkyMatch2");
        taskFactory_.register("votcopy", taskPkg + "VotCopy");
        taskFactory_.register("votlint", taskPkg + "VotLint");
        taskFactory_.register("xsdvalidate", taskPkg + "XsdValidate");
        String plot2Pkg = "uk.ac.starlink.ttools.plot2.task.";
        for (Pair pair : Arrays.asList(new Pair((Object)"plot2plane", (Object)(plot2Pkg + "PlanePlot2Task")), new Pair((Object)"plot2sky", (Object)(plot2Pkg + "SkyPlot2Task")), new Pair((Object)"plot2cube", (Object)(plot2Pkg + "CubePlot2Task")), new Pair((Object)"plot2sphere", (Object)(plot2Pkg + "SpherePlot2Task")), new Pair((Object)"plot2corner", (Object)(plot2Pkg + "MatrixPlot2Task")), new Pair((Object)"plot2time", (Object)(plot2Pkg + "TimePlot2Task")))) {
            String name = (String)pair.getItem1();
            String clazzName = (String)pair.getItem2();
            taskFactory_.register(name, clazzName);
            plot2TaskFactory_.register(name, clazzName);
        }
        modeFactory_ = new ObjectFactory(ProcessingMode.class);
        String modePkg = "uk.ac.starlink.ttools.mode.";
        modeFactory_.register("out", modePkg + "CopyMode");
        modeFactory_.register("meta", modePkg + "MetadataMode");
        modeFactory_.register("stats", modePkg + "StatsMode");
        modeFactory_.register("count", modePkg + "CountMode");
        modeFactory_.register("checksum", modePkg + "ChecksumMode");
        modeFactory_.register("cgi", modePkg + "CgiMode");
        modeFactory_.register("discard", modePkg + "NullMode");
        modeFactory_.register("topcat", modePkg + "TopcatMode");
        modeFactory_.register("samp", modePkg + "SampMode");
        modeFactory_.register("plastic", modePkg + "PlasticMode");
        modeFactory_.register("tosql", modePkg + "JdbcMode");
        modeFactory_.register("gui", modePkg + "SwingMode");
        stdSchemes_ = new TableScheme[]{new SkySimScheme(), new AttractorScheme()};
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.ttools");
        Stilts.init();
    }
}

