/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.starlink.table.Documented;
import uk.ac.starlink.table.MultiStarTableWriter;
import uk.ac.starlink.table.MultiTableBuilder;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.formats.DocumentedIOHandler;
import uk.ac.starlink.table.formats.DocumentedTableBuilder;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.util.BeanConfig;
import uk.ac.starlink.util.ConfigMethod;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.URLDataSource;

public class HandlerDoc {
    private final StarTableFactory tfact_;
    private final StarTableOutput tout_;
    private final StarTable exampleTable_;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public HandlerDoc(StarTableFactory tfact, StarTableOutput tout, StarTable exampleTable) {
        this.tfact_ = tfact;
        this.tout_ = tout;
        this.exampleTable_ = exampleTable;
    }

    public String getBuilderDoc(TableBuilder builder) throws IOException {
        String fname = builder.getFormatName();
        StringBuffer sbuf = new StringBuffer();
        if (builder instanceof Documented) {
            sbuf.append(DocUtils.getXmlDescription((Documented)builder));
        }
        this.tfact_.getTableBuilder(this.getConfigExample(fname, builder));
        sbuf.append(this.getConfigOptionXml(fname, builder));
        if (builder instanceof MultiTableBuilder) {
            sbuf.append(String.join((CharSequence)"\n", "<p>Files in this format may contain multiple tables;", "depending on the context, either one or all tables", "will be read.", "Where only one table is required,", "either the first one in the file is used,", "or the required one can be specified after the", "\"<code>#</code>\" character at the end of the filename.", "</p>", ""));
        }
        if (this.isAutoDetect(builder)) {
            sbuf.append(String.join((CharSequence)"\n", "<p>This format can be automatically identified by its content", "so you do not need to specify the format explicitly", "when reading", fname, "tables, regardless of the filename.", "</p>", ""));
        } else {
            String[] extensions;
            sbuf.append(String.join((CharSequence)"\n", "<p>This format cannot be automatically identified", "by its content, so in general it is necessary", "to specify that a table is in", fname, "format when reading it.", ""));
            String[] stringArray = extensions = builder instanceof DocumentedIOHandler ? ((DocumentedIOHandler)builder).getExtensions() : new String[]{};
            if (extensions.length > 0) {
                sbuf.append(String.join((CharSequence)"\n", "However, if the input file has", this.getExtensionListXml(extensions), "an attempt will be made to read it using this format.", ""));
            }
            sbuf.append("</p>\n");
        }
        if (builder instanceof DocumentedIOHandler && ((DocumentedIOHandler)builder).docIncludesExample()) {
            sbuf.append(this.getExampleOutputXml(this.tout_.getHandler(fname)));
        }
        return sbuf.toString();
    }

    public String getWriterDoc(StarTableWriter writer) throws IOException {
        String[] extensions;
        String fname = writer.getFormatName();
        StringBuffer sbuf = new StringBuffer();
        if (writer instanceof Documented) {
            sbuf.append(DocUtils.getXmlDescription((Documented)writer));
        }
        this.tout_.getHandler(this.getConfigExample(fname, writer));
        sbuf.append(this.getConfigOptionXml(fname, writer));
        if (writer instanceof MultiStarTableWriter) {
            sbuf.append("<p>Multiple tables may be written to a single\n").append("output file using this format.\n").append("</p>\n");
        }
        String[] stringArray = extensions = writer instanceof DocumentedIOHandler ? ((DocumentedIOHandler)writer).getExtensions() : new String[]{};
        if (extensions.length > 0) {
            sbuf.append(String.join((CharSequence)"\n", "<p>If no output format is explicitly chosen,", "writing to a filename with", this.getExtensionListXml(extensions), "will select <code>" + fname + "</code> format for output.", "</p>", ""));
        }
        if (writer instanceof DocumentedIOHandler && ((DocumentedIOHandler)writer).docIncludesExample()) {
            sbuf.append(this.getExampleOutputXml(writer));
        }
        return sbuf.toString();
    }

    private String getExampleOutputXml(StarTableWriter writer) throws IOException {
        StringBuffer sbuf = new StringBuffer();
        if (this.exampleTable_ != null) {
            sbuf.append("<p>An example looks like this:\n").append("<verbatim><![CDATA[\n").append(this.serializeTable(writer)).append("]]></verbatim>\n").append("</p>\n");
        }
        return sbuf.toString();
    }

    private String serializeTable(StarTableWriter handler) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        handler.writeStarTable(this.exampleTable_, (OutputStream)out);
        out.flush();
        return new String(out.toByteArray(), UTF8);
    }

    private String getExtensionListXml(String[] extensions) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("the extension");
        int next = extensions.length;
        for (int i = 0; i < next; ++i) {
            sbuf.append(" \"<code>.").append(extensions[i]).append("</code>\"");
            if (i < next - 2) {
                sbuf.append(", ");
                continue;
            }
            if (i != next - 2) continue;
            sbuf.append(" or");
        }
        sbuf.append(" (case insensitive)");
        return sbuf.toString();
    }

    private String getConfigExample(String handlerName, Object handler) {
        StringBuffer sbuf = new StringBuffer(handlerName.toLowerCase());
        ArrayList<String> examplePairs = new ArrayList<String>();
        List<Method> meths = HandlerDoc.getConfigMethods(handler.getClass());
        for (Method meth : meths) {
            ConfigMethod ann = meth.getAnnotation(ConfigMethod.class);
            String propName = ann.property();
            String propValue = HandlerDoc.getExampleValue(handler, meth);
            if (propValue != null) {
                examplePairs.add(propName + "=" + propValue);
                continue;
            }
            throw new RuntimeException("No example text for " + handlerName + " property " + propName);
        }
        if (examplePairs.size() > 0) {
            sbuf.append("(").append(examplePairs.stream().limit(2L).collect(Collectors.joining(","))).append(")");
        }
        return sbuf.toString();
    }

    private String getConfigOptionXml(String handlerName, Object handler) {
        List<Method> meths = HandlerDoc.getConfigMethods(handler.getClass());
        StringBuffer sbuf = new StringBuffer();
        if (meths.size() > 0) {
            sbuf.append(String.join((CharSequence)"\n", "<p>The handler behaviour may be modified by specifying", "one or more comma-separated name=value configuration options", "in parentheses after the handler name, e.g.", "\"<code>" + this.getConfigExample(handlerName, handler) + "</code>\".", "The following options are available:", "<dl>", ""));
            for (Method meth : meths) {
                ConfigMethod ann = meth.getAnnotation(ConfigMethod.class);
                String dfltTxt = HandlerDoc.getDefaultConfigString(handler, meth);
                sbuf.append("<dt><code>").append(ann.property()).append(" = <![CDATA[").append(BeanConfig.getMethodUsage((Method)meth)).append("]]></code></dt>\n").append("<dd>").append(HandlerDoc.docToXml(ann.doc(), dfltTxt)).append("</dd>\n");
            }
            sbuf.append("</dl>\n").append("</p>\n");
        }
        return sbuf.toString();
    }

    private static List<Method> getConfigMethods(Class<?> clazz) {
        return Arrays.stream(clazz.getMethods()).filter(m -> m.getAnnotation(ConfigMethod.class) != null).sorted(Comparator.comparingInt(m -> m.getAnnotation(ConfigMethod.class).sequence())).collect(Collectors.toList());
    }

    private static String getDefaultConfigString(Object handler, Method setMethod) {
        Object decodedValue;
        Object value;
        Method getMethod;
        String propName;
        String setName = setMethod.getName();
        String string = propName = setName.startsWith("set") ? setName.substring(3) : null;
        if (propName == null || setMethod.getParameterCount() != 1) {
            return null;
        }
        Class<?> propClazz = setMethod.getParameterTypes()[0];
        Class<?> handlerClazz = handler.getClass();
        try {
            getMethod = handlerClazz.getMethod("get" + propName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (Boolean.TYPE.equals(propClazz) || Boolean.class.equals(propClazz)) {
                try {
                    getMethod = handlerClazz.getMethod("is" + propName, new Class[0]);
                }
                catch (NoSuchMethodException e2) {
                    return null;
                }
            }
            return null;
        }
        int mods = getMethod.getModifiers();
        if (Modifier.isStatic(mods)) {
            return null;
        }
        try {
            value = getMethod.invoke(handler, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
        if (value == null) {
            return "null";
        }
        if (value instanceof String || value instanceof Number || value instanceof Boolean || value.getClass().isEnum()) {
            return value.toString();
        }
        String valueTxt = value.toString();
        try {
            decodedValue = BeanConfig.decodeTypedValue(propClazz, (String)valueTxt, (Object)handler);
        }
        catch (RuntimeException e) {
            return null;
        }
        if (value.equals(decodedValue)) {
            return valueTxt;
        }
        return null;
    }

    private static String getExampleValue(Object handler, Method mutatorMethod) {
        ConfigMethod ann = mutatorMethod.getAnnotation(ConfigMethod.class);
        String annExample = ann.example();
        if (annExample != null && annExample.length() > 0) {
            return annExample;
        }
        String mutatorName = mutatorMethod.getName();
        Class<?> hclazz = handler.getClass();
        if (mutatorName.startsWith("set")) {
            Object value;
            try {
                value = hclazz.getMethod("get" + mutatorName.substring(3), new Class[0]).invoke(handler, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                try {
                    value = hclazz.getMethod("is" + mutatorName.substring(3), new Class[0]).invoke(handler, new Object[0]);
                }
                catch (ReflectiveOperationException e2) {
                    return null;
                }
            }
            return value.toString();
        }
        return null;
    }

    private boolean isAutoDetect(TableBuilder handler) {
        return this.tfact_.getDefaultBuilders().contains(handler);
    }

    private static String docToXml(String docTxt, String dfltTxt) {
        int iend;
        String docXml;
        String string = docXml = docTxt.startsWith("<") ? docTxt : new StringBuffer().append("<p>").append(HandlerDoc.escapeXml(docTxt)).append("</p>").toString();
        if (dfltTxt != null && (iend = docXml.lastIndexOf("</p>")) > 0) {
            docXml = docXml.substring(0, iend) + "\n(Default: <code>" + HandlerDoc.escapeXml(dfltTxt) + "</code>)\n" + docXml.substring(iend);
        }
        return docXml;
    }

    private static String escapeXml(String txt) {
        return txt.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private static <T> void writeDocs(String filePrefix, List<String> names, Class<?> docClazz, IOFunction<String, T> getHandler, IOFunction<T, String> getXml) throws IOException {
        boolean isFileOutput = filePrefix != null;
        for (String name : names) {
            T handler = getHandler.apply(name = name.toLowerCase());
            if (docClazz.isInstance(handler)) {
                OutputStream out;
                if (isFileOutput) {
                    File file = new File(filePrefix + name + ".xml");
                    System.out.println("Writing " + file);
                    out = new FileOutputStream(file);
                } else {
                    out = System.out;
                    System.out.println("-------------------------------");
                    System.out.println("* " + name);
                    System.out.println("-------------------------------");
                }
                out.write(getXml.apply(handler).getBytes(UTF8));
                if (!isFileOutput) continue;
                out.close();
                continue;
            }
            System.err.println("No XML for undocumented handler " + name);
        }
    }

    public static void main(String[] args) throws IOException {
        String usage = "\n   Usage: " + HandlerDoc.class.getSimpleName() + " [-[no]files] [-in|-out|-inout]\n";
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        boolean toFiles = false;
        boolean doIn = true;
        boolean doOut = true;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if ("-files".equals(arg)) {
                it.remove();
                toFiles = true;
                continue;
            }
            if ("-nofiles".equals(arg)) {
                it.remove();
                toFiles = false;
                continue;
            }
            if ("-in".equals(arg)) {
                it.remove();
                doIn = true;
                doOut = false;
                continue;
            }
            if ("-out".equals(arg)) {
                it.remove();
                doOut = true;
                doIn = false;
                continue;
            }
            if (!"-inout".equals(arg)) continue;
            it.remove();
            doIn = true;
            doOut = true;
        }
        if (argList.size() > 0) {
            System.err.println(usage);
            return;
        }
        URL exampleUrl = HandlerDoc.class.getResource("animals.vot");
        StarTableFactory tfact = new StarTableFactory();
        StarTableOutput tout = new StarTableOutput();
        StarTable exTable = tfact.makeStarTable((DataSource)new URLDataSource(exampleUrl), "votable");
        HandlerDoc hdoc = new HandlerDoc(tfact, tout, exTable);
        if (doIn) {
            HandlerDoc.writeDocs(toFiles ? "in-" : null, tfact.getKnownFormats(), DocumentedTableBuilder.class, arg_0 -> ((StarTableFactory)tfact).getTableBuilder(arg_0), hdoc::getBuilderDoc);
        }
        if (doOut) {
            List ofmts = tout.getKnownFormats();
            ofmts.remove("jdbc");
            HandlerDoc.writeDocs(toFiles ? "out-" : null, ofmts, DocumentedIOHandler.class, arg_0 -> ((StarTableOutput)tout).getHandler(arg_0), hdoc::getWriterDoc);
        }
    }

    @FunctionalInterface
    private static interface IOFunction<T, R> {
        public R apply(T var1) throws IOException;
    }
}

