/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.build.JupyterCell;

public class Plot2Notebook {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.build");
    public static final String PLOTSERV_PY_RESOURCE = "/uk/ac/starlink/ttools/server/plotserv.py";
    public static final JupyterCell PLOT_CELL = new JupyterCell(Plot2Notebook.readLines("/uk/ac/starlink/ttools/server/plotserv.py"));
    public static final String PLOTWORDS_FUNC = "plot";

    private Plot2Notebook() {
    }

    private static List<String> readLines(String resource) {
        URL url = Plot2Notebook.class.getResource(resource);
        ArrayList<String> lines = new ArrayList<String>();
        if (url == null) {
            logger_.warning("Missing local resource: " + resource);
        }
        try {
            String line;
            BufferedReader rdr = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            while ((line = rdr.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            logger_.log(Level.WARNING, "Error reading local resource: " + resource, e);
        }
        return lines;
    }

    public static JupyterCell createPlotWordsCell(String[] words) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("plot([");
        for (String word : words) {
            lines.add("    \"" + word + "\",");
        }
        lines.add("])");
        return new JupyterCell(lines);
    }

    public static void main(String[] args) {
        ArrayList<JupyterCell> cells = new ArrayList<JupyterCell>();
        cells.add(PLOT_CELL);
        cells.add(Plot2Notebook.createPlotWordsCell(new String[]{"plot2plane", "layer1=function", "fexpr1=sin(x)/x", "thick1=3", "xmin=0", "xmax=30", "ymin=-0.25", "ymax=0.25"}));
        cells.add(Plot2Notebook.createPlotWordsCell(new String[]{"plot2sky", "ofmt=png", "viewsys=ecliptic", "layer_g=skygrid", "gridsys_g=galactic", "gridcolor_g=hotpink", "labelpos_g=none"}));
        System.out.println(JupyterCell.toNotebook(cells).toString(1));
    }
}

