/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import gnu.jel.CompilationException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import uk.ac.starlink.table.RowPermutedStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Tokenizer;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.IntComparator;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.gpl.SortUtils;
import uk.ac.starlink.ttools.jel.RandomJELEvaluator;

public class SortFilter
extends BasicFilter {
    private static final int PARALLEL_THRESHOLD = 100000;

    public SortFilter() {
        super("sort", "[-down] [-nullsfirst] [-[no]parallel] <key-list>");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Sorts the table according to the value of one or more", "algebraic expressions.", "The sort key expressions appear,", "as separate (space-separated) words,", "in <code>&lt;key-list&gt;</code>; sorting is done on the", "first expression first, but if that results in a tie then", "the second one is used, and so on.", "</p>", "<p>Each expression must evaluate to a type that", "it makes sense to sort, for instance numeric.", "If the <code>-down</code> flag is used, the sort order is", "descending rather than ascending.", "</p>", "<p>Blank entries are by default considered to come at the end", "of the collation sequence, but if the <code>-nullsfirst</code>", "flag is given then they are considered to come at the start", "instead.", "</p>", "<p>By default, sorting is done sequentially for small tables", "and in parallel for large tables, but this can be controlled", "with the <code>-parallel</code> or <code>-noparallel</code> flag.", "</p>", SortFilter.explainSyntax(new String[]{"key-list"})};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) throws ArgException {
        String[] keys;
        boolean up = true;
        boolean nullsLast = true;
        Boolean isParallel = null;
        String exprs = null;
        while (argIt.hasNext() && exprs == null) {
            String arg = argIt.next();
            if (arg.equals("-down")) {
                argIt.remove();
                up = false;
                continue;
            }
            if (arg.equals("-nullsfirst")) {
                argIt.remove();
                nullsLast = false;
                continue;
            }
            if (arg.equals("-parallel")) {
                argIt.remove();
                isParallel = Boolean.TRUE;
                continue;
            }
            if (arg.equals("-noparallel")) {
                argIt.remove();
                isParallel = Boolean.FALSE;
                continue;
            }
            if (exprs != null) continue;
            argIt.remove();
            exprs = arg;
        }
        if (exprs == null) {
            throw new ArgException("No sort keys given");
        }
        try {
            keys = Tokenizer.tokenizeWords(exprs);
            if (keys.length == 0) {
                throw new ArgException("No sort keys given");
            }
        }
        catch (TaskException e) {
            throw new ArgException("Bad <key-list>: " + exprs, e);
        }
        return new SortStep(keys, up, nullsLast, isParallel);
    }

    private static class SortException
    extends RuntimeException {
        SortException(String msg, Throwable e) {
            super(msg, e);
        }

        IOException asIOException() {
            Throwable error = this.getCause();
            return error instanceof IOException ? (IOException)error : (IOException)new IOException(error.getMessage()).initCause(error);
        }
    }

    private static class ComparatorManager
    implements Closeable {
        final List<Supplier<RandomJELEvaluator>> evaluatorSuppliers_;
        final boolean up_;
        final boolean nullsLast_;
        final Collection<RowComparator> comparators_;

        ComparatorManager(StarTable table, String[] keys, boolean up, boolean nullsLast) throws CompilationException {
            this.up_ = up;
            this.nullsLast_ = nullsLast;
            this.evaluatorSuppliers_ = new ArrayList<Supplier<RandomJELEvaluator>>();
            this.comparators_ = ConcurrentHashMap.newKeySet();
            for (String key : keys) {
                this.evaluatorSuppliers_.add(RandomJELEvaluator.createEvaluatorSupplier(table, key));
            }
        }

        RowComparator getComparator() {
            RandomJELEvaluator[] evaluators = (RandomJELEvaluator[])this.evaluatorSuppliers_.stream().map(Supplier::get).toArray(RandomJELEvaluator[]::new);
            RowComparator cmp = new RowComparator(evaluators, this.up_, this.nullsLast_);
            this.comparators_.add(cmp);
            return cmp;
        }

        @Override
        public void close() throws IOException {
            for (RowComparator cmp : this.comparators_) {
                cmp.close();
            }
        }
    }

    private static class RowComparator
    implements IntComparator,
    Closeable {
        final int nexpr_;
        final RandomJELEvaluator[] evaluators_;
        final boolean up_;
        final boolean nullsLast_;

        public RowComparator(RandomJELEvaluator[] keyEvaluators, boolean up, boolean nullsLast) {
            this.evaluators_ = keyEvaluators;
            this.up_ = up;
            this.nullsLast_ = nullsLast;
            this.nexpr_ = this.evaluators_.length;
        }

        @Override
        public void close() throws IOException {
            for (RandomJELEvaluator rev : this.evaluators_) {
                rev.close();
            }
        }

        @Override
        public int compare(int row1, int row2) {
            int c = 0;
            for (int i = 0; i < this.nexpr_ && c == 0; ++i) {
                Object val2;
                Object val1;
                RandomJELEvaluator evaluator = this.evaluators_[i];
                try {
                    val1 = evaluator.evaluateObject(row1);
                    val2 = evaluator.evaluateObject(row2);
                }
                catch (IOException e) {
                    throw new SortException("Sort error", e);
                }
                try {
                    c = this.compareValues(val1, val2);
                    continue;
                }
                catch (ClassCastException e) {
                    throw new SortException("Expression comparison error during sorting", e);
                }
            }
            return this.up_ ? c : -c;
        }

        private int compareValues(Object o1, Object o2) {
            boolean null1 = Tables.isBlank((Object)o1);
            boolean null2 = Tables.isBlank((Object)o2);
            if (null1 && null2) {
                return 0;
            }
            if (null1) {
                return this.nullsLast_ ? 1 : -1;
            }
            if (null2) {
                return this.nullsLast_ ? -1 : 1;
            }
            return ((Comparable)o1).compareTo((Comparable)o2);
        }
    }

    private static class SortStep
    implements ProcessingStep {
        final String[] keys_;
        final boolean up_;
        final boolean nullsLast_;
        final Boolean isParallel_;

        SortStep(String[] keys, boolean up, boolean nullsLast, Boolean isParallel) {
            this.keys_ = keys;
            this.up_ = up;
            this.nullsLast_ = nullsLast;
            this.isParallel_ = isParallel;
        }

        @Override
        public StarTable wrap(StarTable baseTable) throws IOException {
            long lnrow = (baseTable = Tables.randomTable((StarTable)baseTable)).getRowCount();
            if (lnrow > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Sorry, can't sort tables with >2^31 rows");
            }
            int nrow = (int)lnrow;
            boolean isParallel = this.isParallel_ == null ? nrow > 100000 : this.isParallel_;
            int[] rowMap = new int[nrow];
            for (int i = 0; i < nrow; ++i) {
                rowMap[i] = i;
            }
            try (ComparatorManager cmpMgr = new ComparatorManager(baseTable, this.keys_, this.up_, this.nullsLast_);){
                if (isParallel) {
                    SortUtils.parallelIntSort((int[])rowMap, cmpMgr::getComparator);
                } else {
                    SortUtils.intSort((int[])rowMap, (IntComparator)cmpMgr.getComparator());
                }
            }
            catch (CompilationException e) {
                throw (IOException)new IOException("Bad sort key(s)").initCause(e);
            }
            catch (SortException e) {
                throw e.asIOException();
            }
            long[] rmap = new long[nrow];
            for (int i = 0; i < nrow; ++i) {
                rmap[i] = rowMap[i];
            }
            return new RowPermutedStarTable(baseTable, rmap);
        }
    }
}

